package com.rocogz.merchant.dto.scm.qiaopai.req;

import com.rocogz.merchant.client.scm.intfc.BaseConfigReqDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 供应链系统查询壳牌附近油站请求实体
 * @author yinshiaho
 * @date 2022/7/30
 */
@Data
public class QiaoPaiPageQueryNearByStationRequest extends BaseConfigReqDto {

    /**
     * 经度
     */
    @NotBlank(message = "经度不能为空")
    private String longitude;

    /**
     * 纬度
     */
    @NotBlank(message = "纬度不能为空")
    private String latitude;

    /**
     * 当前页
     */
    @NotNull(message = "当前页为空")
    private Integer pageNo;

    /**
     * 条数
     */
    @NotNull(message = "条数为空")
    private Integer pageSize;


}
