package com.rocogz.merchant.client;

import com.rocogz.merchant.client.customer.CooperationCustomerReq;
import com.rocogz.merchant.client.goods.ReqParamGoods;
import com.rocogz.merchant.client.insurance.ReqParamGift;
import com.rocogz.merchant.client.scm.*;
import com.rocogz.merchant.client.store.ReqStore;
import com.rocogz.merchant.client.storeservice.ReqStoreService;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.dto.EvaluateDto;
import com.rocogz.merchant.dto.FilterAreaCountDto;
import com.rocogz.merchant.dto.GasStationDto;
import com.rocogz.merchant.dto.TreeDto;
import com.rocogz.merchant.dto.bAgent.goods.BAgentProductDetailRequestDto;
import com.rocogz.merchant.dto.bAgent.goods.BAgentProductResponseDto;
import com.rocogz.merchant.dto.bAgent.goods.ProductValidityRuleReqDto;
import com.rocogz.merchant.dto.channel.product.ChannelProductReqDto;
import com.rocogz.merchant.dto.channel.product.DeductSubjectParamRespDto;
import com.rocogz.merchant.dto.channel.product.DeductSubjectReqDto;
import com.rocogz.merchant.dto.combo.MerchantComboGearsDTO;
import com.rocogz.merchant.dto.customer.CategoryTreeDto;
import com.rocogz.merchant.dto.customer.goods.*;
import com.rocogz.merchant.dto.dataCorrect.IssuingCustomerAndProductParamDto;
import com.rocogz.merchant.dto.datapermission.*;
import com.rocogz.merchant.dto.electric.RechargeCardBatchExpireRefundDto;
import com.rocogz.merchant.dto.electric.rechargeCardBatch.RechargeCardBatchListDto;
import com.rocogz.merchant.dto.exchangeGoodsPoints.ExchangeGoodsPointAddingStatusReq;
import com.rocogz.merchant.dto.exchangeGoodsPoints.admin.ExchangeGoodsPointAdminPageReq;
import com.rocogz.merchant.dto.goods.GoodsPageTableReqDto;
import com.rocogz.merchant.dto.goods.GoodsStockAdminAdjustRequestDto;
import com.rocogz.merchant.dto.goods.GoodsVcardStockPageRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderBatchStockRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderStockRequestDTO;
import com.rocogz.merchant.dto.goodsStock.OrderVCardResponseItem;
import com.rocogz.merchant.dto.goodsVcard.VCardToVoidRequestDTO;
import com.rocogz.merchant.dto.report.ReportAdjustScmOrderMsgDto;
import com.rocogz.merchant.dto.report.SearchReportGrantBillListParamDto;
import com.rocogz.merchant.dto.report.SearchReportGrantBillListRespDto;
import com.rocogz.merchant.dto.report.SearchReportScmOrderParamDto;
import com.rocogz.merchant.dto.scm.*;
import com.rocogz.merchant.dto.scm.correction.CorrectScmOrderDto;
import com.rocogz.merchant.dto.scm.cover.CustomerPayReloadDTO;
import com.rocogz.merchant.dto.scm.didi.ExpireDidiCouponResultDto;
import com.rocogz.merchant.dto.scm.electric.ElectricScmOrderAmtDto;
import com.rocogz.merchant.dto.scm.order.*;
import com.rocogz.merchant.dto.scm.qiaopai.UpdateShellOilStationInfoDto;
import com.rocogz.merchant.dto.scm.qiaopai.UpdateShellOilStationResultDto;
import com.rocogz.merchant.dto.scmWarehouse.allocate.ScmStockAllocateApplyExtendDto;
import com.rocogz.merchant.dto.scmWarehouse.allocate.ScmStockAllocateApplySearchReq;
import com.rocogz.merchant.dto.scmWarehouse.stock.*;
import com.rocogz.merchant.dto.scmWarehouse.stock.pointExchange.ScmPointExchangeGoodsStockFrozenReq;
import com.rocogz.merchant.dto.scmWarehouse.stock.single.ScmGoodsStockSingleCancelReq;
import com.rocogz.merchant.dto.scmWarehouse.stock.single.ScmGoodsStockSingleOccupyReq;
import com.rocogz.merchant.dto.scmWarehouse.stock.single.ScmGoodsStockSingleOutReq;
import com.rocogz.merchant.dto.scmWarehouse.stock.single.ScmGoodsStockSingleUnFrozenReq;
import com.rocogz.merchant.dto.scmWarehouse.warehouse.ScmWarehouseChangeStatusReq;
import com.rocogz.merchant.dto.scmWarehouse.warehouse.ScmWarehouseCreateReq;
import com.rocogz.merchant.dto.scmWarehouse.warehouse.ScmWarehouseEditReq;
import com.rocogz.merchant.dto.scmWarehouse.warehouse.ScmWarehouseSearchReq;
import com.rocogz.merchant.dto.storeservice.CustomerMerchantStoreServiceQueryReq;
import com.rocogz.merchant.dto.storeservice.MerchantStorePageSearchDto;
import com.rocogz.merchant.dto.storeservice.MerchantStoreServicePageSearchDto;
import com.rocogz.merchant.dto.storeservice.StoreServiceCreateDto;
import com.rocogz.merchant.dto.storeservice.issuingBody.IssuingBodySelectStoreServiceGoodsListDto;
import com.rocogz.merchant.dto.storeservice.issuingBody.IssuingBodySelectStoreServiceGoodsPageReq;
import com.rocogz.merchant.dto.storeservice.issuingBody.IssuingBodyStoreServiceGoodsListDto;
import com.rocogz.merchant.dto.storeservice.issuingBody.IssuingBodyStoreServiceGoodsPageReq;
import com.rocogz.merchant.entity.agent.MerchantAgent;
import com.rocogz.merchant.entity.areaservice.MerchantAreaService;
import com.rocogz.merchant.entity.areaservice.MerchantAreaServiceSettlement;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.channel.product.*;
import com.rocogz.merchant.entity.club.MerchantClubDishes;
import com.rocogz.merchant.entity.club.MerchantClubRoom;
import com.rocogz.merchant.entity.combo.MerchantCombo;
import com.rocogz.merchant.entity.combo.MerchantComboDetail;
import com.rocogz.merchant.entity.combo.MerchantComboLog;
import com.rocogz.merchant.entity.cooperationCustomer.MerchantCooperationCustomer;
import com.rocogz.merchant.entity.customer.goods.MerchantCustomerGoods;
import com.rocogz.merchant.entity.customer.goods.MerchantIssuingBodyCustomerGoods;
import com.rocogz.merchant.entity.electric.southern.MerchantElectricRechargeCardBatch;
import com.rocogz.merchant.entity.evaluate.MerchantEvaluateKpi;
import com.rocogz.merchant.entity.exchangeGoods.MerchantExchangeGoods;
import com.rocogz.merchant.entity.exchangeGoods.MerchantExchangeGoodsLog;
import com.rocogz.merchant.entity.exchangeGoods.MerchantExchangeGoodsSpecialPrice;
import com.rocogz.merchant.entity.exchangeGoodsPoints.MerchantExchangeGoodsPoints;
import com.rocogz.merchant.entity.gears.MerchantComboGears;
import com.rocogz.merchant.entity.goods.*;
import com.rocogz.merchant.entity.identity.MerchantStoreAccountIdentity;
import com.rocogz.merchant.entity.impressionLabel.MerchantAreaServiceImpressionLabel;
import com.rocogz.merchant.entity.industry.MerchantIndustry;
import com.rocogz.merchant.entity.insuranceGift.*;
import com.rocogz.merchant.entity.label.MerchantLabel;
import com.rocogz.merchant.entity.log.MerchantChangeLog;
import com.rocogz.merchant.entity.product.MerchantProductType;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoods;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoodsLog;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoodsSpecialPrice;
import com.rocogz.merchant.entity.scm.*;
import com.rocogz.merchant.entity.scm.record.MerchantScmCnpcUsedRecord;
import com.rocogz.merchant.entity.scmWarehouse.MerchantScmStock;
import com.rocogz.merchant.entity.scmWarehouse.MerchantScmStockFlow;
import com.rocogz.merchant.entity.scmWarehouse.MerchantScmStockFlowLog;
import com.rocogz.merchant.entity.scmWarehouse.MerchantScmWarehouse;
import com.rocogz.merchant.entity.service.ServiceClassification;
import com.rocogz.merchant.entity.service.ServiceClassificationIndustry;
import com.rocogz.merchant.entity.store.*;
import com.rocogz.merchant.entity.storeservice.*;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.merchant.entity.supplier.MerchantSupplierUlog;
import com.rocogz.merchant.entity.type.MerchantType;
import com.rocogz.merchant.pager.Sort;
import com.rocogz.merchant.request.agent.goods.MerchantAgentGoodsBatchSaveReq;
import com.rocogz.merchant.request.agent.goods.MerchantAgentGoodsSaveReq;
import com.rocogz.merchant.request.customer.goods.BAgentSearchGoodsReq;
import com.rocogz.merchant.request.customer.goods.MerchantCustomerGoodsBatchSaveReq;
import com.rocogz.merchant.request.customer.goods.MerchantCustomerGoodsSaveReq;
import com.rocogz.merchant.request.customer.goods.MerchantCustomerGoodsSearchReq;
import com.rocogz.merchant.request.goods.BaseGoodsReq;
import com.rocogz.merchant.request.log.LogSearchReq;
import com.rocogz.merchant.request.validity.*;
import com.rocogz.merchant.response.agent.goods.MerchantAgentGoodsDetailExtResp;
import com.rocogz.merchant.response.agent.goods.MerchantAgentGoodsListResp;
import com.rocogz.merchant.response.customer.goods.MerchantCustomerGoodsDetailExtResp;
import com.rocogz.merchant.response.customer.goods.MerchantCustomerGoodsListResp;
import com.rocogz.merchant.response.goods.BaseGoodsResp;
import com.rocogz.merchant.response.validity.ProductValidityRuleResp;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 商户接口
 *
 * @author：liangyongtong
 * @since：2020/3/25
 */
public interface IMerchantClientService {

    /*********************************************  liangyongtong 商户相关 Start   ****************************************************************/
    /**
     * 更新保存商户
     *
     * @param store
     * @return
     */
    @PostMapping("/api/merchant/store")
    Response<String> saveMerchantStore(@RequestBody MerchantStore store);

    /**
     * 上架审批回调接口
     *
     * @param pass
     * @param code
     * @param updateUser
     * @return
     */
    @GetMapping("/api/merchant/store/storeApproveCallBlack")
    Response storeApproveCallBlack(@RequestParam(value = "pass") String pass, @RequestParam(value = "code") String code, @RequestParam(value = "updateUser") String updateUser);


    /**
     * 商户列表数据查询
     *
     * @param keyword 名称 模糊匹配
     * @param code    编码 全匹配
     * @param status  商户状态
     * @param limit   每页条数
     * @param page    页码
     * @return
     */
    @PostMapping("/api/merchant/store/queryPage")
    PageTable<MerchantStore> merchantStorePageTable(@RequestBody MerchantStorePageSearchDto req);

    /**
     * 商户列表Code数据查询
     *
     * @param keyword        名称 模糊匹配
     * @param code           编码 全匹配
     * @param areaCode       专区编码 全匹配
     * @param industryCode   行业编码 全匹配
     * @param settlementCode 结算编码 全匹配
     * @param type           商户类型
     * @param status         商户状态
     * @return
     */
    @GetMapping("/api/merchant/store/gainMerchantStoreCodeList")
    public Response<List<MerchantStore>> gainMerchantStoreCodeList(@RequestParam(value = "keyword", required = false) String keyword,
                                                                   @RequestParam(value = "code", required = false) String code,
                                                                   @RequestParam(value = "areaCode", required = false) String areaCode,
                                                                   @RequestParam(value = "industryCode", required = false) String industryCode,
                                                                   @RequestParam(value = "settlementCode", required = false) String settlementCode,
                                                                   @RequestParam(value = "type", required = false) String type,
                                                                   @RequestParam(value = "status", required = false) String status,
                                                                   @RequestParam(name = "settleSubjectList", required = false) List<String> settleSubjectList);

    /**
     * 商户列表数据查询(主表)
     *
     * @param keyword        名称 模糊匹配
     * @param code           编码 全匹配
     * @param areaCode       专区编码 全匹配
     * @param industryCode   行业编码 全匹配
     * @param settlementCode 结算编码 全匹配
     * @param type           商户类型
     * @param status         商户状态
     * @param limit          每页条数
     * @param page           页码
     * @return
     */
    @GetMapping("/api/merchant/store/basicQueryPage")
    PageTable<MerchantStore> merchantStoreBasicPageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                         @RequestParam(value = "code", required = false) String code,
                                                         @RequestParam(value = "areaCode", required = false) String areaCode,
                                                         @RequestParam(value = "industryCode", required = false) String industryCode,
                                                         @RequestParam(value = "settlementCode", required = false) String settlementCode,
                                                         @RequestParam(value = "type", required = false) String type,
                                                         @RequestParam(value = "status", required = false) String[] status,
                                                         @RequestParam(name = "settleSubjectList", required = false) List<String> settleSubjectList,
                                                         @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                         @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 操作商户状态
     *
     * @param code       商户编码
     * @param status     目标商户状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/store/operateStatus")
    Response merchantStoreStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "updateUser") String updateUser);

    /**
     * 根据商户编码删除商户
     *
     * @param code 商户编码
     * @return
     */
    @GetMapping("/api/merchant/store/deleteStore")
    Response merchantStoreDeleteByCode(@RequestParam(value = "code") String code);

    /**
     * 根据商户编码获取商户详情
     *
     * @param code 商户编码
     * @return
     */
    @GetMapping("/api/merchant/store/storeDetail")
    Response<MerchantStore> merchantStoreDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 更新保存账号信息
     *
     * @param account 账号对象
     * @return
     */
    @PostMapping("/api/merchant/store/account")
    Response merchantStoreAccountSave(@RequestBody MerchantStoreAccount account);

    /**
     * 商户账号列表查询
     *
     * @param storeCode 商户编码
     * @return
     */
    @GetMapping("/api/merchant/store/account/queryPage")
    PageTable<MerchantStoreAccount> merchantStoreAccountPageTable(@RequestParam(value = "storeCode") String storeCode,
                                                                  @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                  @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 商户账号管理-列表查询
     *
     * @param storeCode
     * @param code
     * @param name
     * @param mobile
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/account/queryPage")
    PageTable<MerchantStoreAccount> merchantStoreAccountPageTable(@RequestParam(value = "storeCode", required = false) String storeCode,
                                                                  @RequestParam(value = "code", required = false) String code,
                                                                  @RequestParam(value = "name", required = false) String name,
                                                                  @RequestParam(value = "mobile", required = false) String mobile,
                                                                  @RequestParam(value = "areaCode", required = false) String areaCode,
                                                                  @RequestParam(value = "settlementCode", required = false) String settlementCode,
                                                                  @RequestParam(value = "prefectureCodes", required = false) List<String> prefectureCodes,
                                                                  @RequestParam(value = "settleSubjectCodes", required = false) List<String> settleSubjectCodes,
                                                                  @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                  @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 导出商户账号列表查询
     *
     * @param storeCode 商户编码
     * @return
     */
    @GetMapping("/api/merchant/account/merchantStoreAccountList")
    Response<List<MerchantStoreAccount>> merchantStoreAccountList(@RequestParam(value = "storeCode", required = false) String storeCode,
                                                                  @RequestParam(value = "code", required = false) String code,
                                                                  @RequestParam(value = "name", required = false) String name,
                                                                  @RequestParam(value = "mobile", required = false) String mobile,
                                                                  @RequestParam(value = "areaCode", required = false) String areaCode,
                                                                  @RequestParam(value = "settlementCode", required = false) String settlementCode,
                                                                  @RequestParam(value = "prefectureCodes", required = false) List<String> prefectureCodes,
                                                                  @RequestParam(value = "settleSubjectCodes", required = false) List<String> settleSubjectCodes);


    /**
     * 根据商户编码查询对应的账号列表
     *
     * @param storeCode 商户编码
     * @param status    账号状态
     * @return
     */
    @GetMapping("/api/merchant/store/account/queryList")
    Response<List<MerchantStoreAccount>> merchantStoreAccountListByStoreCode(@RequestParam(value = "storeCode") String storeCode,
                                                                             @RequestParam(value = "status", required = false) String status);

    /**
     * 更改商户账号状态
     *
     * @param code   商户账号编码
     * @param status 目标状态
     * @return
     */
    @GetMapping("/api/merchant/store/account/operateStatus")
    Response merchantStoreAccountStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 重置商户账号密码
     *
     * @param code 待重置密码的商户账号编码
     * @return
     */
    @GetMapping("/api/merchant/store/account/resetpassword")
    Response merchantStoreAccountResetPassword(@RequestParam(value = "code") String code, @RequestParam(value = "newPass", required = false) String newPass, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 根据手机号返回账号列表
     *
     * @param mobile 手机号
     * @return
     */
    @GetMapping("/api/merchant/store/account/listbymobile")
    Response<List<MerchantStoreAccount>> merchantStoreAccountListByMobile(@RequestParam(value = "mobile") String mobile);

    /**
     * 商户操作日志记录
     *
     * @param storeCode 商户编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */
    @GetMapping("/api/merchant/store/ulog/queryPage")
    PageTable<MerchantStoreUlog> merchantStoreUlogPageTable(@RequestParam(value = "storeCode") String storeCode,
                                                            @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                            @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据商户编码获取商户基本信息 (merchant_store 表数据)
     *
     * @param code 商户编码
     * @return
     */
    @GetMapping("/api/merchant/store/storeBaseDetail")
    Response<MerchantStore> merchantStoreBaseInfoByCode(@RequestParam(value = "code") String code);

    /**
     * 更新商户基本信息表数据
     *
     * @param store 商户信息
     * @return
     */
    @PostMapping("/api/merchant/store/baseinfo")
    Response merchantStoreBaseSave(@RequestBody MerchantStore store);

    /**
     * 查询绑定过该商户账号的微信列表
     *
     * @param accountCode 商户账号
     * @return
     */
    @GetMapping("/api/merchant/store/account/wxlist")
    Response<List<MerchantStoreAccountLoginStatus>> merchantStoreAccountWxLoginList(@RequestParam(value = "accountCode") String accountCode);

    /**
     * 删除某个商户账号下关联的微信登录信息
     *
     * @param accountCode 商户账号
     * @param wxOpenid    关联的微信openid
     * @param operateUser 操作用户
     * @return
     */
    @GetMapping("/api/merchant/store/account/deletewx")
    Response merchantStoreAccountDeleteWx(@RequestParam(value = "accountCode") String accountCode, @RequestParam(value = "wxOpenid") String wxOpenid, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 通过商户账号编码获取账号详情
     *
     * @param code 账号编码
     * @return
     */
    @GetMapping("/api/merchant/store/account/detail")
    Response<MerchantStoreAccount> merchantStoreAccountDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 通过商户账号或者手机号查询列表
     *
     * @param codeOrMobile 商户账号或者手机号
     * @param status       状态，默认启用
     * @return
     */
    @GetMapping("/api/merchant/store/account/list/bycodeormobile")
    Response<List<MerchantStoreAccount>> merchantStoreAccountListByCodeOrMobile(@RequestParam(value = "codeOrMobile") String codeOrMobile, @RequestParam(value = "status", defaultValue = "OPEN") String status);

    /**
     * 通过商户账号和手机号查询
     *
     * @param storeCode 商户编码
     * @param mobile    手机号
     * @return
     */
    @GetMapping("/api/merchant/store/account/bystorecodeandmobile")
    Response<MerchantStoreAccount> merchantStoreAccountByStoreCodeAndMobile(@RequestParam(value = "storeCode") String storeCode, @RequestParam(value = "mobile") String mobile);

    /**
     * 按关联时间倒序返回登录关联列表
     *
     * @param openid openid
     * @return
     */
    @GetMapping("/api/merchant/store/account/statuslist")
    Response<List<MerchantStoreAccountLoginStatus>> merchantStoreAccountLoginStatusListByOpenid(@RequestParam(value = "openid") String openid);

    /**
     * 根据openid查询最新一个登录关联信息
     *
     * @param openid openid
     * @return
     */
    @GetMapping("/api/merchant/store/account/getLastLoginStatusByOpenid")
    Response<MerchantStoreAccountLoginStatus> merchantStoreAccountLastLoginStatusByOpenid(@RequestParam(value = "openid") String openid);

    /**
     * 获取商户标准礼包系数
     *
     * @param storeCode 商户编码
     * @return
     */
    @GetMapping("/api/merchant/store/coefficient")
    Response<MerchantStoreCoefficient> getMerchantStoreCoefficient(@RequestParam(value = "storeCode") String storeCode);

    /**
     * 更新商户标准礼包系数
     *
     * @param reqStore 参数
     * @return 结果
     */
    @PostMapping("/api/merchant/store/updateMerchantStoreCoefficient")
    Response updateMerchantStoreCoefficient(@RequestBody ReqStore reqStore);

    /**
     * 保存或者更新账号登录状态
     *
     * @param loginStatus 账号登录状态记录
     * @return
     */
    @PostMapping("/api/merchant/store/account/loginstatus/save")
    Response merchantStoreAccountLoginStatusSaveOrUpdate(@RequestBody MerchantStoreAccountLoginStatus loginStatus);

    /**
     * 门店登录日志
     *
     * @param storeCode   门店编号
     * @param accountCode 门店账号
     */
    @GetMapping("/api/merchant/store/loginLog")
    PageTable<MerchantStoreLoginLog> findStoreLoginLogs(@RequestParam(value = "storeCode", required = false) String storeCode,
                                                        @RequestParam(value = "accountCode", required = false) String accountCode,
                                                        @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                        @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 保存门店登录日志
     */
    @PostMapping("/api/merchant/store/loginLog/save")
    Response<String> saveStoreLoginLog(@RequestBody MerchantStoreLoginLog loginLog);

    /**
     * 返回限制规则列表
     *
     * @param areaCode        专区编码
     * @param areaServiceCode 专区服务编码
     * @return 限制列表
     */
    @GetMapping("/api/merchant/store/limitRules")
    Response<List<MerchantLimitRules>> merchantLimitRulesByAreaCodeAndAreaServiceCode(@RequestParam(value = "areaCode") String areaCode,
                                                                                      @RequestParam(value = "areaServiceCode") String areaServiceCode);


    /**
     * 运营管理-首页推荐商户-根据商户codelist查询商户列表---yifenrui
     *
     * @param listCode
     * @return
     */
    @GetMapping("/api/merchant/store/merchantStoreListByListCode")
    Response<List<MerchantStore>> merchantStoreListByListCode(@RequestParam(value = "code") List<String> listCode);

    /**
     * 添加商户和商户服务的订单数量
     *
     * @param storeCode        商户编码
     * @param storeServiceCode 商户服务编码
     * @param count            新添加的订单数量
     * @return 添加结果
     */
    @GetMapping("/api/merchant/store/appendOrderCount")
    Response appendStoreOrderCount(@RequestParam(value = "storeCode") String storeCode, @RequestParam(value = "storeServiceCode") String storeServiceCode, @RequestParam(value = "count") int count);

    /**
     * 获取加油站商户列表
     *
     * @param lat    纬度
     * @param lng    经度
     * @param types  商户类型
     * @param brands 商户品牌
     * @return 商户列表
     */
    @GetMapping("/api/merchant/wx/store/gaslist")
    Response<List<GasStationDto>> getGasStationList(@RequestParam(value = "lat", required = false) double lat,
                                                    @RequestParam(value = "lng", required = false) double lng,
                                                    @RequestParam(value = "types", required = false) String[] types,
                                                    @RequestParam(value = "brands", required = false) String[] brands);

    /**
     * 获取附近油站
     *
     * @param store 参数 {keyword, labels, distance}
     * @return
     */
    @PostMapping("/api/merchant/wx/store/gaslistNear")
    Response<List<GasStationDto>> getGasStationListNear(@RequestBody ReqStore store);

    /**
     * 获取城市油站数量
     *
     * @param store 参数 {cityName}
     * @return
     */
    @PostMapping("/api/merchant/wx/store/gasCount")
    Response<Integer> getGasCountWithCity(@RequestBody ReqStore store);

    /**
     * 获取加油站商户列表
     *
     * @param lat    纬度
     * @param lng    经度
     * @param types  商户类型
     * @param brands 商户品牌
     * @param tags   商户标签
     * @return 商户列表
     */
    @GetMapping("/api/merchant/wx/store/gaslistV2")
    Response<List<GasStationDto>> getGasStationListV2(@RequestParam(value = "lat", required = false) double lat,
                                                      @RequestParam(value = "lng", required = false) double lng,
                                                      @RequestParam(value = "types", required = false) String[] types,
                                                      @RequestParam(value = "brands", required = false) String[] brands,
                                                      @RequestParam(value = "tags", required = false) String[] tags);

    /**
     * 重新刷新对应的编码进redis缓存
     *
     * @return
     */
    @GetMapping("/api/merchant/wx/store/gaslist/refresh")
    Response refreshGasListToCache();

    /**
     * 判断是否是油站
     *
     * @param storeCode 商铺编码
     * @return
     */
    @GetMapping("/api/merchant/wx/store/isOil")
    Response<Boolean> isOil(@RequestParam(value = "storeCode") String storeCode);

    /**
     * 通过编码列表返回名称，手机号列表
     *
     * @param codes
     * @return
     */
    @GetMapping("/api/merchant/store/accounts/bycodes")
    Response<List<MerchantStoreAccount>> merchantStoreAccountListByAccountCodes(@RequestParam(value = "code") List<String> codes);

    /**
     * 测试事务
     *
     * @return
     */
    @GetMapping("/api/merchant/store/testtx")
    Response testTx();


    /**
     * 商户账号查看权限信息
     *
     * @param accountCode
     * @return
     */
    @GetMapping("/api/merchant/account/getPermissionListByAccountCode")
    Response<List<MerchantStoreAccountPermission>> getPermissionListByAccountCode(@RequestParam(value = "accountCode", required = false) String accountCode);
    /*********************************************   liangyongtong 商户相关 end   ********************************************************************/

    /*********************************************  liangyongtong 商户类型相关 Start   ****************************************************************/
    /**
     * 分页查询商户类型.
     *
     * @param name   商户类型名称(模糊匹配)
     * @param code   商户类型编码(模糊匹配)
     * @param status 商户类型状态
     * @param page   the page
     * @param limit  the limit
     * @return the prefecture tree
     */
    @GetMapping("/api/merchant/type/pageQuery")
    PageTable<MerchantType> merchantTypePageQuery(@RequestParam(value = "name", required = false) String name,
                                                  @RequestParam(value = "code", required = false) String code,
                                                  @RequestParam(value = "status", required = false) String status,
                                                  @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                  @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    @GetMapping("/api/merchant/type/pageQueryWithIndustry")
    PageTable<MerchantType> merchantTypePageQuery(@RequestParam(value = "name", required = false) String name,
                                                  @RequestParam(value = "code", required = false) String code,
                                                  @RequestParam(value = "industryCode", required = false) String industryCode,
                                                  @RequestParam(value = "status", required = false) String status,
                                                  @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                  @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * 查询商户类型.
     *
     * @param name         名称(精准匹配)
     * @param code         编码(精准匹配)
     * @param industryCode 行业编码(精准匹配)
     * @param status       the status
     * @return the response
     */
    @GetMapping("/api/merchant/type/list")
    Response<List<MerchantType>> listMerchantType(@RequestParam(value = "name", required = false) String name,
                                                  @RequestParam(value = "code", required = false) String code,
                                                  @RequestParam(value = "industryCode", required = false) String industryCode,
                                                  @RequestParam(value = "status", required = false, defaultValue = "OPEN") String status);

    /**
     * 根据id查询商户类型.
     *
     * @param id the id
     * @return the by id
     */
    @GetMapping("/api/merchant/type/{id}")
    Response<MerchantType> getMerchantTypeById(@PathVariable("id") Integer id);

    /**
     * 新增或者更新商户类型信息(对象的id属性为空时代表新增).
     *
     * @param merchantType 商户类型对象 {@link MerchantType}
     * @return the response
     */
    @PostMapping("/api/merchant/type")
    Response saveOrUpdateMerchantType(@RequestBody MerchantType merchantType);

    /*********************************************   liangyongtong商户类型相关 end   ********************************************************************/

    /*********************************************  yinshihao 商户品牌相关 Start   ****************************************************************/
    /**
     * 查询商户品牌列表(分页)
     *
     * @param code             品牌名
     * @param keyword          所属行业编码
     * @param status           品牌状态
     * @param industryCodeList 行业编码
     * @param page             页码
     * @param limit            每页条数
     * @return
     */
    @GetMapping("/api/merchant/brand")
    PageTable<MerchantBrand> findMerchantBrandList(@RequestParam(value = "code", required = false) String code,
                                                   @RequestParam(value = "keyword", required = false) String keyword,
                                                   @RequestParam(value = "status", required = false) String status,
                                                   @RequestParam(value = "industryCodeList", required = false) List<String> industryCodeList,
                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 加油行业品牌
     *
     * @param code
     * @param keyword
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/brand/gas")
    public PageTable<MerchantBrand> findMerchantBrandListWithOil(@RequestParam(value = "code", required = false) String code,
                                                                 @RequestParam(value = "keyword", required = false) String keyword,
                                                                 @RequestParam(value = "status", required = false) String status,
                                                                 @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                 @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 新增或编辑商户品牌
     *
     * @param merchantBrand 商户品牌
     * @return
     */
    @PostMapping("/api/merchant/brand/saveOrUpdateMerchantBrand")
    Response saveOrUpdateMerchantBrand(@RequestBody MerchantBrand merchantBrand);

    /**
     * 添加商户品牌对应的行业
     *
     * @param merchantBrand 商户品牌
     * @return
     */
    @PostMapping("/api/merchant/brand/addBrandIndustry")
    Response addBrandIndustry(@RequestBody MerchantBrand merchantBrand);

    /**
     * 改变商户品牌状态
     *
     * @param merchantBrand 商户品牌
     * @return
     */
    @PostMapping("/api/merchant/brand/status")
    Response switchMerchantBrandStatus(@RequestBody MerchantBrand merchantBrand);

    /**
     * 根据id查询商户品牌信息
     *
     * @param id 商户品牌id
     * @return
     */
    @GetMapping("/api/merchant/brand/{id}")
    Response<MerchantBrand> getMerchantBrandById(@PathVariable("id") Integer id);

    /**
     * 根据codeList查询品牌信息
     *
     * @param codeList 品牌codeList
     * @return
     */
    @GetMapping("/api/merchant/brand/selectMerchantBrandByCodeList")
    Response<List<MerchantBrand>> selectMerchantBrandByCodeList(@RequestParam(value = "codeList", required = false) List<String> codeList);

    /**
     * 根据id查询商户品牌全部信息(包括对应行业信息)
     *
     * @param id 品牌id
     * @return
     */
    @GetMapping("/api/merchant/brand/getAllInfoById/{id}")
    Response<MerchantBrand> getMerchantBrandAllInfoById(@PathVariable("id") Integer id);

    /**
     * 根据商户品牌编号删除专区信息
     *
     * @param name             品牌名称
     * @param brandCode        品牌编码
     * @param industryCodeList 专区编码
     * @return
     */
    @GetMapping("/api/merchant/brand/deleteIndustryByCode")
    Response deleteIndustryByCode(@RequestParam("name") String name, @RequestParam("brandCode") String brandCode, @RequestParam("industryCodeList") List<String> industryCodeList);

    /**
     * 获取启用的品牌列表
     *
     * @param industryCode 行业编码
     * @return
     */
    @GetMapping("/api/merchant/brand/listwithopen")
    Response<List<MerchantBrand>> getMerchantBrandListWithOpen(@RequestParam(value = "industryCode", required = false) String industryCode);

    /*********************************************   yinshihao 商户品牌 end   ********************************************************************/

    /*********************************************  yinshihao 商户行业相关 Start   ****************************************************************/
    /**
     * 商户行业列表(分页)
     *
     * @param keyword 行业名或简称
     * @param code    行业编码
     * @param page    页码
     * @param limit   每页条数
     * @return
     */
    @GetMapping("/api/merchant/industry")
    PageTable<MerchantIndustry> findMerchantIndustryList(@RequestParam(value = "keyword", required = false) String keyword,
                                                         @RequestParam(value = "code", required = false) String code,
                                                         @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                         @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 新增或编辑商户行业
     *
     * @param merchantIndustry 商户行业
     * @return
     */
    @PostMapping("/api/merchant/industry/saveOrUpdateMerchantIndustry")
    Response saveOrUpdateMerchantIndustry(@RequestBody MerchantIndustry merchantIndustry);

    /**
     * 根据id查询商户行业信息
     *
     * @param id 商户行业id
     * @return
     */
    @GetMapping("/api/merchant/industry/{id}")
    Response<MerchantIndustry> getMerchantIndustryById(@PathVariable("id") Integer id);

    /**
     * 根据code查询行业信息
     *
     * @param code 行业code
     * @return
     */
    @GetMapping("/api/merchant/industry/getByCode/{code}")
    Response<MerchantIndustry> getMerchantIndustryByCode(@PathVariable("code") String code);

    /**
     * 根据商户品牌编号查询对应专区编码
     *
     * @param brandCode    品牌编码
     * @param industryCode 行业编码
     * @param keyword      行业名称或简称
     * @return
     */
    @GetMapping("/api/merchant/industry/getIndustryByBrandCode")
    Response<List<MerchantIndustry>> getIndustryByBrandCode(@RequestParam("brandCode") String brandCode,
                                                            @RequestParam(value = "industryCode", required = false) String industryCode,
                                                            @RequestParam(value = "keyword", required = false) String keyword);

    /**
     * 根据服务分类编码查询其所有所属行业.
     *
     * @param serviceClassificationCode 服务分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/industry/listByServiceClassificationCode")
    Response<List<MerchantIndustry>> listByServiceClassificationCode(@RequestParam("serviceClassificationCode") String serviceClassificationCode);

    /**
     * 商户行业列表(服务分类页面使用，用于查询某服务分类未关联的行业)
     *
     * @param serviceClassificationCode 服务分类编码
     * @param industryCodeList          行业编码列表(not in)
     * @param keyword                   行业名或简称
     * @param code                      行业编码
     * @param page                      页码
     * @param limit                     每页条数
     * @return
     */
    @GetMapping("/api/merchant/industry/classificationSearchScrollPage")
    PageTable<MerchantIndustry> classificationSearchScrollPage(@RequestParam(value = "serviceClassificationCode", required = false) String serviceClassificationCode,
                                                               @RequestParam(value = "industryCodeList[]", required = false) List<String> industryCodeList,
                                                               @RequestParam(value = "keyword", required = false) String keyword,
                                                               @RequestParam(value = "code", required = false) String code,
                                                               @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                               @RequestParam(value = "page", defaultValue = "1") int page);
    /*********************************************   yinshihao 商户行业相关 end   ********************************************************************/

    /*********************************************  yinshihao 商户标签相关 Start   ****************************************************************/

    /**
     * 商户标签列表
     *
     * @param name           标签名
     * @param prefectureCode 所属行业编码
     * @param status         标签状态
     * @param page           页码
     * @param limit          每页条数
     * @return
     */
    @GetMapping("/api/merchant/label")
    PageTable<MerchantLabel> findMerchantLabelList(@RequestParam(value = "name", required = false) String name,
                                                   @RequestParam(value = "prefectureCode", required = false) String prefectureCode,
                                                   @RequestParam(value = "status", required = false) String status,
                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 新增或编辑商户标签
     *
     * @param merchantLabel
     * @return
     */
    @PostMapping("/api/merchant/label/saveOrUpdateMerchantLabel")
    Response saveOrUpdateMerchantLabel(@RequestBody MerchantLabel merchantLabel);

    /**
     * 添加标签对应专区
     *
     * @param merchantLabel
     * @return
     */
    @PostMapping("/api/merchant/label/addLabelPrefecture")
    Response addLabelPrefecture(@RequestBody MerchantLabel merchantLabel);

    /**
     * 商户标签状态改变
     *
     * @param merchantLabel 商户标签
     * @return
     */
    @PostMapping("/api/merchant/label/status")
    Response switchMerchantLabelStatus(@RequestBody MerchantLabel merchantLabel);

    /**
     * 根据id查询商户标签信息
     *
     * @param id 商户标签id
     * @return
     */
    @GetMapping("/api/merchant/label/{id}")
    Response<MerchantLabel> getMerchantLabelById(@PathVariable("id") Integer id);

    /**
     * 根据LabelCodes查询商户标签信息
     *
     * @param labelCodes 标签编码列表
     * @return
     */
    @GetMapping("/api/merchant/label/getMerchantLabelByLabelCodes")
    Response<List<MerchantLabel>> getMerchantLabelByLabelCodes(@RequestParam("labelCodes") List<String> labelCodes);

    /**
     * 根据商户标签编号查询对应专区编码
     *
     * @param labelCode      标签编码
     * @param prefectureCode 专区编码
     * @param prefectureName 专区名称
     * @return
     */
    @GetMapping("/api/merchant/label/getPrefectureByLabelCode")
    Response<List<String>> getPrefectureByLabelCode(@RequestParam("labelCode") String labelCode,
                                                    @RequestParam(value = "prefectureCode", required = false) String prefectureCode,
                                                    @RequestParam(value = "prefectureName", required = false) String prefectureName);

    /**
     * 根据code查询标签信息
     *
     * @param code 标签code
     * @return
     */
    @GetMapping("/api/merchant/label/getMerchantLabelByCode/{code}")
    Response<MerchantLabel> getMerchantLabelByCode(@PathVariable("code") String code);

    /**
     * 根据商户标签编号删除专区信息
     *
     * @param labelCode          标签编码
     * @param prefectureCodeList 专区编码
     * @return
     */
    @GetMapping("/api/merchant/label/deletePrefectureByCode")
    Response deletePrefectureByCode(@RequestParam("labelCode") String labelCode, @RequestParam("prefectureCodeList") List<String> prefectureCodeList);
    /*********************************************   yinshihao 商户标签相关 end   ********************************************************************/

    /*********************************************  ranxiangfu 服务分类和行业对应相关 Start   ****************************************************************/

    /**
     * 根据服务分类编码获取所属行业列表.
     *
     * @param serviceClassificationCode 服务分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/service-classification-industry/listByServiceClassificationCode")
    Response<List<ServiceClassificationIndustry>> listServiceClassificationIndustryByCode(@RequestParam("serviceClassificationCode") String serviceClassificationCode);

    /**
     * 新增服务分类所属行业.
     *
     * @param serviceClassificationIndustry 服务分类所属行业对象 {@link com.rocogz.merchant.entity.service.ServiceClassificationIndustry}
     * @return the response
     */
    @PostMapping("/api/merchant/service-classification-industry")
    Response addServiceClassificationIndustry(@RequestBody ServiceClassificationIndustry serviceClassificationIndustry);

    /**
     * 批量新增服务分类所属行业.
     *
     * @param serviceClassificationIndustryList 服务分类所属行业对象列表 {@link com.rocogz.merchant.entity.service.ServiceClassificationIndustry}
     * @return the response
     */
    @PostMapping("/api/merchant/service-classification-industry/saveBatch")
    Response saveBatchServiceClassificationIndustry(@RequestBody List<ServiceClassificationIndustry> serviceClassificationIndustryList);

    /**
     * 根据id删除服务分类所属行业.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/merchant/service-classification-industry")
    Response removeServiceClassificationIndustry(@RequestParam("id") Integer id);

    /**
     * 根据id删除服务分类所属行业.
     *
     * @param serviceClassificationCode 服务分类编码
     * @param industryCode              行业编码
     * @return the response
     */
    @DeleteMapping("/api/merchant/service-classification-industry/removeByCode")
    Response removeServiceClassificationIndustryByCode(@RequestParam("serviceClassificationCode") String serviceClassificationCode,
                                                       @RequestParam("industryCode") String industryCode);
    /*********************************************   ranxiangfu 服务分类和行业相关 end   ********************************************************************/

    /*********************************************  ranxiangfu 服务分类相关 Start   ****************************************************************/

    /**
     * 分页查询服务分类.
     *
     * @param page  the page
     * @param limit the limit
     * @return the prefecture tree
     */
    @GetMapping("/api/merchant/service-classification/pageQuery")
    PageTable<ServiceClassification> pageQueryServiceClassification(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                                                    @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * 获取服务分类树.
     *
     * @return the prefecture tree
     */
    @GetMapping("/api/merchant/service-classification/getTree")
    Response<List<TreeDto<ServiceClassification>>> getServiceClassificationTree();

    /**
     * 根据id查询服务分类.
     *
     * @param id the id
     * @return the by id
     */
    @GetMapping("/api/merchant/service-classification/{id}")
    Response<ServiceClassification> getServiceClassificationById(@PathVariable("id") Integer id);

    /**
     * 根据编码查询服务分类.
     *
     * @param code 服务分类编码
     * @return the by id
     */
    @GetMapping("/api/merchant/service-classification/getByCode")
    Response<ServiceClassification> getServiceClassificationByCode(@RequestParam("code") String code);

    /**
     * 新增或者更新服务分类信息(对象的id属性为空时代表新增).
     *
     * @param serviceClassification 专区对象 {@link com.rocogz.merchant.entity.service.ServiceClassification}
     * @return the response
     */
    @PostMapping("/api/merchant/service-classification")
    Response saveOrUpdateServiceClassification(@RequestBody ServiceClassification serviceClassification);

    /**
     * 返回叶子列表
     *
     * @return
     */
    @GetMapping("/api/merchant/service-classification/leafList")
    Response<List<ServiceClassification>> getLeafList();

    /**
     * 返回一级服务分类
     *
     * @return
     */
    @GetMapping("/api/merchant/service-classification/oneLevel")
    Response<List<ServiceClassification>> getOneLevel();
    /*********************************************   ranxiangfu 服务分类相关 end   ********************************************************************/

    /*********************************************  liangyongtong 专区服务相关 Start   ****************************************************************/
    /**
     * 保存更新专区服务项目
     *
     * @param areaService 专区服务项目对象
     * @return
     */
    @PostMapping("/api/merchant/areaservice")
    Response merchantAreaServiceSave(@RequestBody MerchantAreaService areaService);

    /**
     * 专区服务项目列表查询
     *
     * @param keyword           名称
     * @param code              编码
     * @param cataCode          服务分类编码
     * @param areaCodes         专区编码列表
     * @param nature            范围
     * @param status            状态
     * @param noRepeatStoreCode 商户编码，添加该商户的服务项目的时候选择的专区服务项目非套餐的情况下不能重复
     * @param limit             每页条数
     * @param page              页码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/queryPage")
    PageTable<MerchantAreaService> merchantAreaServicePageTable(@RequestParam(required = false, value = "keyword") String keyword,
                                                                @RequestParam(required = false, value = "code") String code,
                                                                @RequestParam(required = false, value = "cataCode") String cataCode,
                                                                @RequestParam(required = false, value = "areaCodes") String[] areaCodes,
                                                                @RequestParam(required = false, value = "nature") String nature,
                                                                @RequestParam(required = false, value = "status") String status,
                                                                @RequestParam(required = false, value = "noRepeatStoreCode") String noRepeatStoreCode,
                                                                @RequestParam(required = false, value = "settleCode") String[] settleCode,
                                                                @RequestParam(required = false, value = "limit", defaultValue = "20") int limit,
                                                                @RequestParam(required = false, value = "page", defaultValue = "1") int page);

    /**
     * 通过专区服务项目编码获取专区服务项目详情
     *
     * @param code 专区服务编码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/detailbycode")
    Response<MerchantAreaService> merchantAreaServiceDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 更新专区服务项目的状态
     *
     * @param code        专区服务项目编码
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/areaservice/operate/status")
    Response merchantAreaServiceOperateStatus(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 查询专区服务项目基本信息
     *
     * @param codes 专区服务项目编码列表 最多200个
     * @return 专区服务项目列表
     */
    @GetMapping("/api/merchant/areaservice/list/servicesByCodes")
    Response<List<MerchantAreaService>> merchantAreaServiceBaseInfoByCodes(@RequestParam(value = "codes") String[] codes);

    /**
     * 保存专区服务结算信息
     *
     * @param settlement 结算对象
     * @return
     */
    @PostMapping("/api/merchant/areaservice/settle/save")
    Response merchantAreaServiceSettleSave(@RequestBody MerchantAreaServiceSettlement settlement);

    /**
     * 获取结算信息详情
     *
     * @param settlementCode 结算信息编码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/settle/detail")
    Response<MerchantAreaServiceSettlement> merchantAreaServiceSettlementDetailBySettlementCode(@RequestParam(value = "settlementCode") String settlementCode);

    /**
     * 获取专区服务项目对应的结算列表
     *
     * @param code 专区服务项目编码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/settle/list")
    Response<List<MerchantAreaServiceSettlement>> merchantAreaServiceSettlementListByAreaServiceCode(@RequestParam(value = "code") String code);

    /**
     * 删除结算信息对象
     *
     * @param code 结算信息对象编码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/settle/remove")
    Response merchentAreaServiceSettlementRemoveBySettlementCode(@RequestParam(value = "code") String code);

    /**
     * 通过专区项目编码查询可关联的专区和结算商的数据
     *
     * @param code       专区服务项目编码
     * @param areaCode   专区编码
     * @param settleCode 结算商编码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/settle/pricelist")
    Response<MerchantAreaServiceSettlement> merchantAreaServiceSettlementByAreaCodeAndSettleCode(@RequestParam(value = "code") String code, @RequestParam(value = "areaCode") String areaCode, @RequestParam(value = "settleCode") String settleCode);

    /*********************************************   liangyongtong 专区服务相关 end   ********************************************************************/

    /*********************************************  liangyongtong 商户服务相关 Start   ****************************************************************/
    /**
     * 更新保存商户服务项目
     *
     * @param storeService 商户服务项目对象
     * @return
     */
    @PostMapping("/api/merchant/storeservice")
    Response merchantStoreServiceSave(@RequestBody MerchantStoreService storeService);

    /**
     * 商户服务项目列表查询 (关联商户表)
     *
     * @param keyword      名称
     * @param code         编码
     * @param excludedCode 不包含编码
     * @param cataCode     服务分类编码
     * @param areaCodes    专区编码列表
     * @param storeCodes   商户编码列表
     * @param status       状态
     * @param distinguish  是否车型
     * @param combo        是否套餐
     * @param limit        每页条数
     * @param page         页码
     * @return
     */
    @PostMapping("/api/merchant/storeservice/queryPage")
    PageTable<MerchantStoreService> merchantStoreServicePageTable(@RequestBody MerchantStoreServicePageSearchDto req);


    @GetMapping("/api/merchant/storeservice/queryByCodes")
    List<MerchantStoreService> queryMerchantStoreServiceByCodes(@RequestParam(value = "includedCode") List<String> includedCode, @RequestParam(value = "combo", required = false) String combo);

    /**
     * 商户服务项目列表查询 (只查询商户服务项目表)
     *
     * @param keyword      名称
     * @param code         编码
     * @param excludedCode 不包含编码
     * @param cataCode     服务分类编码
     * @param storeCode    商户编码
     * @param status       状态
     * @param limit        每页条数
     * @param page         页码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/base/queryPage")
    PageTable<MerchantStoreService> merchantStoreServiceBaseInfoPageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                                          @RequestParam(value = "code", required = false) String code,
                                                                          @RequestParam(value = "excludedCode", required = false) String excludedCode,
                                                                          @RequestParam(value = "cataCode", required = false) String cataCode,
                                                                          @RequestParam(value = "storeCode", required = false) String storeCode,
                                                                          @RequestParam(value = "status", required = false, defaultValue = Constant.DictData.MERCHANT_STORE_STATUS_UP_LIST) String status,
                                                                          @RequestParam(value = "limit", required = false, defaultValue = "20") int limit,
                                                                          @RequestParam(value = "page", required = false, defaultValue = "1") int page);

    /**
     * 商户服务项目查询
     *
     * @param req 查询参数
     * @return
     */
    @PostMapping("/api/merchant/storeservice/storeServicePageQuery")
    PageTable<MerchantStoreService> merchantStoreServiceInfoPageTable(@RequestBody ReqStoreService req);

    /**
     * 查询列表
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/storeservice/storeServiceListQuery")
    Response<List<MerchantStoreService>> merchantStoreServiceInfoList(@RequestBody ReqStoreService req);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/storeservice/batch/status")
    Response merchantStoreServiceBatchOperateStatus(@RequestParam(value = "codes") String[] codes, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 操作商户服务项目的状态
     *
     * @param code        待操作的商户服务项目编码
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/storeservice/operate/status")
    Response merchantStoreServiceOperateStatus(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 删除草稿状态的商户服务项目
     *
     * @param code 待删除的商户服务项目编码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/remove")
    Response merchantStoreServiceRemoveByCode(@RequestParam(value = "code") String code);

    /**
     * 获取商户服务项目详情信息
     *
     * @param code 商户服务项目编码
     * @returnmerchantStoreServiceBaseInfoPageTable
     */
    @GetMapping("/api/merchant/storeservice/detail")
    Response<MerchantStoreService> merchantStoreServiceDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 查询商户下的服务列表（不分页，不含结算信息)
     *
     * @param storeCode 商户编码
     * @param status    状态 （默认为上架，传 "")
     * @return 服务列表
     */
    @GetMapping("/api/merchant/storeservice/nopagelist")
    Response<List<MerchantStoreService>> merchantStoreServiceListByStoreCode(@RequestParam(value = "storeCode") String storeCode, @RequestParam(value = "status", required = false, defaultValue = Constant.DictData.MERCHANT_STORE_STATUS_UP_LIST) String status);


    /**
     * 查询商户下服务项目基本信息
     *
     * @param storeCode 商户编码
     * @param codes     服务项目编码列表
     * @return 服务项目列表
     */
    @GetMapping("/api/merchant/storeservice/store/services")
    Response<List<MerchantStoreService>> merchantStoreServiceBaseInfoByStoreCodeAndCodes(@RequestParam(value = "storeCode") String storeCode,
                                                                                         @RequestParam(value = "codes") String[] codes);

    /**
     * 返回该商户服务项目下对应车型的价格
     *
     * @param storeServiceCode 商户服务项目编码
     * @param carType          车型
     * @return 价格对象
     */
    @GetMapping("/api/merchant/storeservice/store/service/price")
    Response<MerchantStoreServicePrice> merchantStoreServicePriceByStoreServiceCodeAndCarType(@RequestParam(value = "storeServiceCode") String storeServiceCode, @RequestParam(value = "carType") String carType);

    /**
     * 查询服务项目基本信息
     *
     * @param codes 服务项目编码列表 最多200个
     * @return 服务项目列表
     */
    @GetMapping("/api/merchant/storeservice/store/servicesByCodes")
    Response<List<MerchantStoreService>> merchantStoreServiceBaseInfoByCodes(@RequestParam(value = "codes") String[] codes);

    /**
     * 对商户服务进行排序
     *
     * @param code   商户服务项目编码
     * @param newSeq 新的排序号
     * @return
     */
    @GetMapping("/api/merchant/storeservice/seq")
    Response merchantStoreServviceSeq(@RequestParam(value = "code") String code, @RequestParam(value = "newSeq") int newSeq);

    /**
     * 查询服务项目操作日志列表
     *
     * @param storeServiceCode 商户服务项目编码
     * @param limit            每页数量
     * @param page             当前页
     * @return 列表
     */
    @GetMapping("/api/merchant/storeservice/ulog/queryPage")
    PageTable<MerchantStoreServiceUlog> merchantStoreServiceUlogPageTable(@RequestParam(value = "storeServiceCode") String storeServiceCode,
                                                                          @RequestParam(required = false, defaultValue = "20", value = "limit") int limit,
                                                                          @RequestParam(required = false, defaultValue = "1", value = "page") int page);

    /**
     * 新增或保存预约数据
     *
     * @param storeService
     * @return
     */
    @PostMapping("/api/merchant/storeservice/appointment/saveorupdate")
    Response merchantStoreServiceAppointmentSaveOrUpdate(@RequestBody MerchantStoreService storeService);

    /**
     * 通过商户服务项目编码获取对应的预约数据
     *
     * @param storeServiceCode 商户服务项目编码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/appointment/listByStoreServiceCode")
    Response<List<MerchantStoreServiceAppointment>> merchantStoreServiceAppointmentByStoreServiceCode(@RequestParam(value = "storeServiceCode") String storeServiceCode);

    /**
     * 通过商户编码获取该商户下第一个开启了预约设置的商户服务项目对应的预约数据
     *
     * @param storeCode 商户编码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/appointment/listByStoreCode")
    Response<List<MerchantStoreServiceAppointment>> merchantStoreServiceAppointmentByStoreCode(@RequestParam(value = "storeCode") String storeCode);

    /**
     * 通过商户编码获取该商户下第一个开启了预约设置的商户服务项目
     *
     * @param storeCode 商户编码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/appointment/serviceItemByStoreCode")
    Response<MerchantStoreService> merchantStoreServiceAppointmentItemByStoreCode(@RequestParam(value = "storeCode") String storeCode);

    /**
     * 通过服务项目编码列表查询对应的套餐数据
     *
     * @param storeServiceComboCodes 商户服务项目编码列表
     * @return
     */
    @PostMapping("/api/merchant/storeservice/storeservicecombo")
    Response<Map<String, List<MerchantStoreService>>> merchantStoreServiceComboData(@RequestBody List<String> storeServiceComboCodes);

    /**
     * 商户端创建编码服务项目
     *
     * @param createDto 服务对象
     * @return
     */
    @PostMapping("/api/merchant/storeservice/saveStoreServiceFromStore")
    Response saveOrUpdateStoreServiceFromStore(@RequestBody StoreServiceCreateDto createDto);

    /**
     * 获取商户服务项目详情信息 商户商使用
     *
     * @param req {code}
     * @return
     */
    @PostMapping("/api/merchant/storeservice/detail/tostore")
    Response<StoreServiceCreateDto> merchantStoreServiceDetailWithStoreByCode(@RequestBody ReqStoreService req);

    /**
     * @param storeServiceCode 门店服务项目编号
     * @return 通过门店服务项目编号 获取所属门店下的专区列表
     */
    @GetMapping("/api/merchant/storeservice/findAreaListByStoreServiceCode")
    Response<List<MerchantStoreArea>> findAreaListByStoreServiceCode(@RequestParam("storeServiceCode") String storeServiceCode, @RequestParam(value = "miniAppid", required = false) String miniAppid);


    /*********************************************   liangyongtong 商户服务相关 end   ********************************************************************/

    /*********************************************   liangyongtong 商户服务标签 start   ********************************************************************/
    /**
     * 新增或更新商户服务标签
     *
     * @param label
     * @return
     */
    @PostMapping("/api/merchant/storeservice/label/saveOrUpdate")
    Response merchantStoreServiceLabelSaveOrUpdate(@RequestBody MerchantStoreServiceLabel label);

    /**
     * 查询商户服务项目标签列表
     *
     * @param keyword 标签名称关键字
     * @param status  状态
     * @param limit   每页长度
     * @param page    当前页
     * @return
     */
    @GetMapping("/api/merchant/storeservice/label/queryPage")
    PageTable<MerchantStoreServiceLabel> merchantStoreServiceLabelPageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                                            @RequestParam(value = "status", required = false) String status,
                                                                            @RequestParam(value = "limit", required = false, defaultValue = "20") int limit,
                                                                            @RequestParam(value = "page", required = false, defaultValue = "1") int page);

    /**
     * 变更标签的状态
     *
     * @param id          标签id
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/storeservice/label/operateStatus")
    Response merchantStoreServiceLabelOperateStatus(@RequestParam(value = "id") Integer id, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);
    /*********************************************   liangyongtong 商户服务标签 end   ********************************************************************/

    /*********************************************   liangyongtong 评价结果保存 start   ********************************************************************/
    /**
     * 更新商户、商户服务项目平均分，记录印象标签统计数量
     *
     * @param evaluate 评价结果
     * @return
     */
    @PostMapping("/api/merchant/evaluate/kpi/all")
    Response evaluateKpiAll(@RequestBody EvaluateDto evaluate);

    /**
     * 更新商户、商户服务项目订单数
     *
     * @param evaluate 记录结果
     * @return
     */
    @PostMapping("/api/merchant/evaluate/kpi/store")
    Response evaluateKpiForStore(@RequestBody EvaluateDto evaluate);

    /**
     * 获取商户服务项目的印象标签
     *
     * @param storeServiceCode 商户服务项目编码
     * @return 针对该商户服务项目的印象标签统计列表
     */
    @GetMapping("/api/merchant/evaluate/kpi/storeservice/impression")
    Response<List<MerchantEvaluateKpi>> merchantEvaluateKpiWithStoreService(@RequestParam(value = "storeServiceCode") String storeServiceCode);

    /**
     * 获取商户的印象标签
     *
     * @param storeCode 商户编码
     * @return 针对该商户的印象标签统计列表
     */
    @GetMapping("/api/merchant/evaluate/kpi/store/impression")
    Response<List<MerchantEvaluateKpi>> merchantEvaluateKpiWithStore(@RequestParam(value = "storeCode") String storeCode);

    /**
     * 设置评价印象标签数量
     *
     * @param storeServiceCode 商户服务项目编码
     * @param type             com.rocogz.merchant.constant.Constant.General#MERCHANTEVALUATEKPI_ADD,
     *                         com.rocogz.merchant.constant.Constant.General#MERCHANTEVALUATEKPI_CANCEL,
     *                         com.rocogz.merchant.constant.Constant.General#MERCHANTEVALUATEKPI_DELETE,
     *                         *             com.rocogz.merchant.constant.Constant.General#MERCHANTEVALUATEKPI_HIDE,
     *                         *             com.rocogz.merchant.constant.Constant.General#MERCHANTEVALUATEKPI_SHOW
     * @param impressinos      印象标签数组
     * @param perfect          是否精选
     * @return
     */
    @GetMapping("/api/merchant/evaluate/kpi/storeservice/kpioperateamount")
    Response merchantEvaluateKpiOperateAmount(@RequestParam(value = "storeServiceCode") String storeServiceCode, @RequestParam(value = "type") String type, @RequestParam(value = "impressinos") String[] impressinos, @RequestParam(value = "perfect", required = false) Boolean perfect);

    /*********************************************   liangyongtong 评价结果保存 end   ********************************************************************/

    /*********************************************  liangyongtong 车主商户端商户相关 Start   ****************************************************************/
    /**
     * 查询商户列表数据（含基本表数据，停业信息，标签）【每次最多1000个】
     *
     * @param codes  商户编码列表
     * @param status 目标查询状态
     * @return
     */
    @GetMapping("/api/merchant/wx/store/list/bycodes")
    Response<List<MerchantStore>> getMerchantStoreListByCodes(@RequestParam(value = "codes") String[] codes, @RequestParam(value = "status", required = false) String status);

    /**
     * 查询油列表数据
     *
     * @param req 商户编码列表
     * @return
     */
    @PostMapping("/api/merchant/wx/store/oillist/bycodes")
    Response<List<MerchantStore>> getMerchantStoreOilListByCodes(@RequestBody ReqStore req);

    /**
     * 查询商户列表数据（主要针对会员端商户列表）
     *
     * @param areaCode          专区编码
     * @param keyword           关键字
     * @param provinceCode      省编码
     * @param cityCode          市编码
     * @param districtCode      区编码
     * @param streetCode        街道编码
     * @param industryCode      行业编码
     * @param serviceType       服务类型
     * @param storeTypes        商户类型
     * @param orderType         排序类型
     * @param lat               纬度
     * @param lng               经度
     * @param areaServiceCode   专区服务项目编码
     * @param includeStoreCodes 包含的商户编码列表
     * @param excludeStoreCodes 不包含的商户编码列表
     * @param limit             每页数量
     * @param page              页码
     * @return
     */
    @GetMapping("/api/merchant/wx/store/list")
    PageTable<MerchantStore> getMerchantStoreCarList(@RequestParam(value = "areaCode", required = false) String areaCode,
                                                     @RequestParam(value = "keyword", required = false) String keyword,
                                                     @RequestParam(value = "provinceCode", required = false) String provinceCode,
                                                     @RequestParam(value = "cityCode", required = false) String cityCode,
                                                     @RequestParam(value = "districtCode", required = false) String districtCode,
                                                     @RequestParam(value = "streetCode", required = false) String streetCode,
                                                     @RequestParam(value = "industryCode", required = false) String industryCode,
                                                     @RequestParam(value = "serviceType", required = false) String serviceType,
                                                     @RequestParam(value = "storeTypes", required = false) String[] storeTypes,
                                                     @RequestParam(value = "orderType", required = false) String orderType,
                                                     @RequestParam(value = "lat", required = false, defaultValue = "0") double lat,
                                                     @RequestParam(value = "lng", required = false, defaultValue = "0") double lng,
                                                     @RequestParam(value = "areaServiceCode", required = false) String areaServiceCode,
                                                     @RequestParam(value = "includeStoreCodes", required = false) String[] includeStoreCodes,
                                                     @RequestParam(value = "excludeStoreCodes", required = false) String[] excludeStoreCodes,
                                                     @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                     @RequestParam(value = "page", defaultValue = "1") int page
    );

    /**
     * 查询商户列表数据（主要针对会员端地图模式商户列表）
     *
     * @param areaCode          专区编码
     * @param keyword           关键字
     * @param provinceCode      省编码
     * @param cityCode          市编码
     * @param districtCode      区编码
     * @param streetCode        街道编码
     * @param industryCode      行业编码
     * @param serviceType       服务类型
     * @param storeTypes        商户类型
     * @param lat               纬度
     * @param lng               经度
     * @param areaServiceCode   专区服务项目编码
     * @param includeStoreCodes 包含的商户编码列表
     * @param excludeStoreCodes 不包含的商户编码列表
     * @return
     */
    @GetMapping("/api/merchant/wx/store/nearlist")
    Response<List<MerchantStore>> getMerchantNearStoreCarList(@RequestParam(value = "areaCode", required = false) String areaCode,
                                                              @RequestParam(value = "keyword", required = false) String keyword,
                                                              @RequestParam(value = "provinceCode", required = false) String provinceCode,
                                                              @RequestParam(value = "cityCode", required = false) String cityCode,
                                                              @RequestParam(value = "districtCode", required = false) String districtCode,
                                                              @RequestParam(value = "streetCode", required = false) String streetCode,
                                                              @RequestParam(value = "industryCode", required = false) String industryCode,
                                                              @RequestParam(value = "serviceType", required = false) String serviceType,
                                                              @RequestParam(value = "storeTypes", required = false) String[] storeTypes,
                                                              @RequestParam(value = "lat", required = false, defaultValue = "0") double lat,
                                                              @RequestParam(value = "lng", required = false, defaultValue = "0") double lng,
                                                              @RequestParam(value = "areaServiceCode", required = false) String areaServiceCode,
                                                              @RequestParam(value = "includeStoreCodes", required = false) String[] includeStoreCodes,
                                                              @RequestParam(value = "excludeStoreCodes", required = false) String[] excludeStoreCodes
    );

    /**
     * 查询专区下各街道的上架商户数
     *
     * @param areaServiceCode   专区服务项目编码
     * @param includeStoreCodes 包含的商户编码列表
     * @param excludeStoreCodes 不包含的商户编码列表
     * @param areaCode          专区编码
     * @return
     */
    @GetMapping("/api/merchant/wx/store/areaStoreCount")
    Response<List<FilterAreaCountDto>> getAreaStoreCount(@RequestParam(value = "areaServiceCode", required = false) String areaServiceCode,
                                                         @RequestParam(value = "includeStoreCodes", required = false) String[] includeStoreCodes,
                                                         @RequestParam(value = "excludeStoreCodes", required = false) String[] excludeStoreCodes,
                                                         @RequestParam(value = "areaCode") String areaCode);

    /**
     * 查询用户券的可用商户数量
     *
     * @param areaServiceCode   专区服务项目编码
     * @param includeStoreCodes 包含的商户编码列表
     * @param excludeStoreCodes 不包含的商户编码列表
     * @param areaCode          专区编码
     * @return 可用商户数
     */
    @Deprecated
    @GetMapping("/api/merchant/wx/store/usableStoreCount")
    Response<Integer> getUsableStoreCount(@RequestParam(value = "areaServiceCode") String areaServiceCode,
                                          @RequestParam(value = "includeStoreCodes", required = false) String[] includeStoreCodes,
                                          @RequestParam(value = "excludeStoreCodes", required = false) String[] excludeStoreCodes,
                                          @RequestParam(value = "areaCode") String areaCode);


    /**
     * 通过门店服务项目编号，查询用户券的可用商户数量
     *
     * @param serviceProjectCode 门店服务项目编号
     * @return 可用商户数
     */
    @GetMapping("/api/merchant/wx/store/getAvailableStoreCountByServiceProjectCode")
    Response<Integer> getUsableStoreCountByServiceCode(@RequestParam("serviceProjectCode") String serviceProjectCode,
                                                       @RequestParam(value = "includeStoreCodes", required = false) String[] includeStoreCodes,
                                                       @RequestParam(value = "excludeStoreCodes", required = false) String[] excludeStoreCodes,
                                                       @RequestParam(value = "areaCode") String areaCode);

    /**
     * 查询商户下某专区服务项目列表信息
     *
     * @param storeCode       商户编码
     * @param areaServiceCode 专区服务项目编码
     * @param status          服务状态
     * @return 商户服务项目列表
     */
    @GetMapping("/api/merchant/storeservice/store/servicesbyareaservicecode")
    Response<List<MerchantStoreService>> merchantStoreServiceByStoreCodeAndAreaServiceCode(@RequestParam(value = "storeCode") String storeCode,
                                                                                           @RequestParam(value = "areaServiceCode", required = false) String areaServiceCode,
                                                                                           @RequestParam(value = "status", required = false) String status);

    /**
     * 通过专区服务项目编码获取对应的评价指标数据
     *
     * @param areaServiceCode 专区服务项目编码
     * @return 只含两个指标维度数据的专区服务项目对象
     */
    @GetMapping("/api/merchant/wx/areaservice/kpi")
    Response<MerchantAreaService> merchantAreaServiceEvaluativeDimension(@RequestParam(value = "areaServiceCode") String areaServiceCode);

    /*********************************************   yinshihao MerchantAreaServiceImpressionLabel start   ********************************************************************/
    /**
     * 新增或更新商户服务标签
     *
     * @param label
     * @return
     */
    @PostMapping("/api/merchant/service/impression/label/saveOrUpdate")
    Response merchantAreaServiceImpressionLabelSaveOrUpdate(@RequestBody MerchantAreaServiceImpressionLabel label);

    /**
     * 查询商户服务项目标签列表
     *
     * @param keyword 标签名称关键字
     * @param status  状态
     * @param limit   每页长度
     * @param page    当前页
     * @return
     */
    @GetMapping("/api/merchant/service/impression/label/queryPage")
    PageTable<MerchantAreaServiceImpressionLabel> merchantAreaServiceImpressionLabelPageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                                                              @RequestParam(value = "status", required = false) String status,
                                                                                              @RequestParam(value = "limit", required = false, defaultValue = "20") int limit,
                                                                                              @RequestParam(value = "page", required = false, defaultValue = "1") int page);

    /**
     * 变更标签的状态
     *
     * @param id          标签id
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/service/impression/label/operateStatus")
    Response merchantAreaServiceImpressionLabelOperateStatus(@RequestParam(value = "id") Integer id, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 删除标签
     *
     * @param id 标签id
     * @return
     */
    @GetMapping("/api/merchant/service/impression/label/deleteById")
    Response deleteMerchantAreaServiceImpressionLabeById(@RequestParam("id") Integer id);
    /*********************************************   yinshihao MerchantAreaServiceImpressionLabel end   ********************************************************************/

    /*********************************************   yinshihao MerchantGoods start   ********************************************************************/

    /**
     * 更新保存商品
     *
     * @param goods
     * @return
     */
    @PostMapping("/api/merchant/goods/saveMerchantGoods")
    Response<String> saveMerchantGoods(@RequestBody MerchantGoods goods);

    /**
     * 商品列表数据查询
     *
     * @param reqDto
     * @return
     */
    @PostMapping("/api/merchant/goods/queryPage")
    public PageTable<MerchantGoods> merchantGoodsPageTable(@RequestBody GoodsPageTableReqDto reqDto);

    /**
     * 操作商品状态
     *
     * @param code       商品编码
     * @param status     目标商品状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/goods/operateStatus")
    Response merchantGoodsStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "updateUser") String updateUser);

    /**
     * 审批回调更改状态（上架审批后回调）
     *
     * @param pass
     * @param code
     * @param updateUser
     * @return
     */
    @GetMapping("/api/merchant/goods/goodsApproveCallBlack")
    Response goodsApproveCallBlack(@RequestParam(value = "pass") String pass, @RequestParam(value = "code") String code, @RequestParam(value = "updateUser") String updateUser);

    /**
     * 根据商品编码删除商品
     *
     * @param code 商品编码
     * @return
     */
    @GetMapping("/api/merchant/goods/deleteGoods")
    Response merchantGoodsDeleteByCode(@RequestParam(value = "code") String code);

    /**
     * 根据商品编码获取商品详情
     *
     * @param code 商品编码
     * @return
     */
    @GetMapping("/api/merchant/goods/goodsDetail")
    Response<MerchantGoods> merchantGoodsDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/goods/batch/status")
    Response merchantGoodsBatchOperateStatus(@RequestParam(value = "codes") String[] codes, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 根据商品分类编码获取商品列表(基本信息)
     *
     * @param goodsClassificationCode 商品分类编码
     * @return
     */
    @GetMapping("/api/merchant/goods/findGoodsListByClassificationCode")
    Response<List<MerchantGoods>> findGoodsListByClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /**
     * 商品列表数据查询(去掉兑换商品中已有的商品信息)
     *
     * @param keyword                 名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param goodsClassificationCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPageNoExchangeGoods")
    PageTable<MerchantGoods> queryPageNoExchangeGoods(@RequestParam(value = "keyword", required = false) String keyword,
                                                      @RequestParam(value = "code", required = false) String code,
                                                      @RequestParam(value = "brandCode", required = false) String brandCode,
                                                      @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                      @RequestParam(value = "saleType", required = false) String saleType,
                                                      @RequestParam(value = "goodsType", required = false) String goodsType,
                                                      @RequestParam(value = "status", required = false) String status,
                                                      @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                      @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                      @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 商品列表数据查询(若传了noGoodsCodeList,则是去掉noGoodsCodeList中的商品信息)
     *
     * @param keyword                 名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param noGoodsCodeList         不需要查询的编码列表
     * @param brandCode               品牌编码 全匹配
     * @param goodsClassificationCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param queryType               查询类型
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPageNoGoods")
    PageTable<MerchantGoods> queryPageNoGoods(@RequestParam(value = "keyword", required = false) String keyword,
                                              @RequestParam(value = "code", required = false) String code,
                                              @RequestParam(value = "noGoodsCodeList", required = false) List<String> noGoodsCodeList,
                                              @RequestParam(value = "brandCode", required = false) String brandCode,
                                              @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                              @RequestParam(value = "saleType", required = false) String saleType,
                                              @RequestParam(value = "status", required = false) String status,
                                              @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                              @RequestParam(value = "queryType", required = false) String queryType,
                                              @RequestParam(value = "limit", defaultValue = "20") int limit,
                                              @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据商品编码列表查询对应信息,（如果产品编号太多，会报错，GET请求长度有限制）
     *
     * @param codes
     * @return
     */
    @Deprecated
    @GetMapping("/api/merchant/goods/findMerchantGoodsListByCodes")
    Response<List<MerchantGoods>> findMerchantGoodsListByCodes(@RequestParam(value = "codes") List<String> codes);

    /**
     * 通过post方法获取多个平台产品信息,如果有很多平台产品编号Get方法会报错，因为Get请求url有长度限制，所以用post请求
     *
     * @param codeList
     * @return
     */
    @PostMapping("/api/merchant/goods/findMerchantGoodsListByGoodCodes")
    Response<List<MerchantGoods>> findMerchantGoodListByMerchantGoodCodes(@RequestBody List<String> codeList);

    /**
     * 商品列表数据查询(去掉兑换商品中已有的商品信息)
     *
     * @param keyword                 名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param goodsClassificationCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPageNoRocoMallGoods")
    PageTable<MerchantGoods> queryPageNoRocoMallGoods(@RequestParam(value = "keyword", required = false) String keyword,
                                                      @RequestParam(value = "code", required = false) String code,
                                                      @RequestParam(value = "brandCode", required = false) String brandCode,
                                                      @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                      @RequestParam(value = "saleType", required = false) String saleType,
                                                      @RequestParam(value = "status", required = false) String status,
                                                      @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                      @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                      @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 获取商品列表
     *
     * @param keyword
     * @param code
     * @param brandCode
     * @param supplierCode
     * @param goodsClassificationCode
     * @param status
     * @param supplierCodeList
     * @param goodsType
     * @return
     */
    @GetMapping("/api/merchant/goods/merchantGoodsList")
    Response<List<MerchantGoods>> merchantGoodsList(@RequestParam(value = "keyword", required = false) String keyword,
                                                    @RequestParam(value = "code", required = false) String code,
                                                    @RequestParam(value = "brandCode", required = false) String brandCode,
                                                    @RequestParam(value = "supplierCode", required = false) String supplierCode,
                                                    @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                    @RequestParam(value = "status", required = false) String status,
                                                    @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                    @RequestParam(value = "goodsType", required = false) String goodsType,
                                                    @RequestParam(value = "goodsTypeCode", required = false) String goodsTypeCode,
                                                    @RequestParam(value = "goodsTypeCodeList", required = false) List<String> goodsTypeCodeList,
                                                    @RequestParam(value = "goodsNature", required = false) String goodsNature,
                                                    @RequestParam(value = "sortField", required = false) String sortField,
                                                    @RequestParam(value = "sortType", required = false) String sortType,
                                                    @RequestParam(value = "mchId", required = false) String mchId);






    /**
     * 获取套餐中包含的子产品（子产品可能是供应商套餐）
     *
     * @param suiteGoodCodeList
     */
    @PostMapping("/api/merchant/suiteGood/findMealListMap")
    Response<Map<String, List<MerchantGoodsMeal>>> findMerchantGoodMealListMap(@RequestBody List<String> suiteGoodCodeList);


    /**
     * 深度获取套餐中包含的子产品（保证每个子产品都是单品）
     *
     * @param suiteGoodCodeList
     */
    @PostMapping("/api/merchant/suiteGood/findDeepMealListMap")
    Response<Map<String, List<MerchantGoodsMeal>>> findMerchantGoodDeepMealListMap(@RequestBody List<String> suiteGoodCodeList);


    /*********************************************   yinshihao MerchantGoods end   ********************************************************************/

    /*********************************************   yinshihao MerchantGoodsLog start   ********************************************************************/

    /**
     * 商品操作日期记录
     *
     * @param goodsCode 商品编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */
    @GetMapping("/api/merchant/goodsLog/queryPage")
    PageTable<MerchantGoodsLog> merchantGoodsLogPageTable(@RequestParam(value = "goodsCode") String goodsCode,
                                                          @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                          @RequestParam(value = "page", defaultValue = "1") int page);

    /*********************************************   yinshihao MerchantGoodsLog end   ********************************************************************/

    /********************************************* yifenrui 供应商  start******************************************************/

    /**
     * 供应商列表
     *
     * @param code
     * @param name
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/supplier")
    PageTable<MerchantSupplier> searchSupplier(@RequestParam(name = "code", required = false) String code,
                                               @RequestParam(name = "name", required = false) String name,
                                               @RequestParam(name = "status", required = false) String status,
                                               @RequestParam(name = "supplierCodeList", required = false) List<String> supplierCodeList,
                                               @RequestParam(name = "provinceCode", required = false) String provinceCode,
                                               @RequestParam(name = "cityCode", required = false) String cityCode,
                                               @RequestParam(name = "districtCode", required = false) String districtCode,
                                               @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                               @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 导出供应商的数据
     *
     * @param code
     * @param name
     * @param status
     * @param supplierCodeList
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    @GetMapping("/api/merchant/supplier/export")
    Response<List<MerchantSupplier>> supplierList(@RequestParam(name = "code", required = false) String code,
                                                  @RequestParam(name = "name", required = false) String name,
                                                  @RequestParam(name = "status", required = false) String status,
                                                  @RequestParam(name = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                  @RequestParam(name = "provinceCode", required = false) String provinceCode,
                                                  @RequestParam(name = "cityCode", required = false) String cityCode,
                                                  @RequestParam(name = "districtCode", required = false) String districtCode);


    /**
     * 新增和更新供应商
     *
     * @param merchantSupplier
     * @return
     */
    @PostMapping("/api/merchant/supplier/createOrUpdateMerchantSupplier")
    Response createOrUpdateMerchantSupplier(@RequestBody MerchantSupplier merchantSupplier);

    /**
     * 根据供应商编码获取供应商详情
     *
     * @param code 供应商编码
     * @return
     */
    @GetMapping("/api/merchant/supplier/supplierDetail")
    Response<MerchantSupplier> merchantMerchantSupplierDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 操作供应商状态
     *
     * @param code       供应商编码
     * @param status     目标供应商状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/supplier/operateStatus")
    Response merchantSupplierStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "updateUser") String updateUser, @RequestParam(value = "reason", required = false) String reason);

    /**
     * 供应商操作日志记录
     *
     * @param supplierCode 商户编码
     * @param limit        每页条数
     * @param page         页码
     * @return
     */
    @GetMapping("/api/merchant/supplier/ulog/queryPage")
    PageTable<MerchantSupplierUlog> merchantSupplierUlogPageTable(@RequestParam(value = "supplierCode") String supplierCode,
                                                                  @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                  @RequestParam(value = "page", defaultValue = "1") int page);
    /********************************************* yifenrui 供应商  end******************************************************/

    /********************************************* yifenrui 商品分类  start******************************************************/
    /**
     * 获取商品分类树.
     *
     * @return
     */
    @GetMapping("/api/merchant/goods/classification/getTree")
    Response<List<TreeDto<MerchantGoodsClassification>>> getMerchantGoodsClassificationTree();

    /**
     * 根据id查询商品分类.
     *
     * @param id the id
     * @return the by id
     */
    @GetMapping("/api/merchant/goods/classification/{id}")
    Response<MerchantGoodsClassification> getMerchantGoodsClassificationById(@PathVariable("id") Integer id);

    /**
     * 根据商品分类编码获取下级列表.
     *
     * @param goodsClassificationCode 服务分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/goods/classification/listByGoodsClassificationCode")
    Response<List<MerchantGoodsClassification>> listByGoodsClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    @GetMapping("/api/merchant/goods/classification/deleteByGoodsClassCode")
    Response deleteByGoodsClassCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /**
     * 分页查询商品分类列表
     *
     * @param code
     * @param name
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/goods/classification")
    PageTable<MerchantGoodsClassification> searchMerchantGoodsClassification(@RequestParam(name = "code", required = false) String code,
                                                                             @RequestParam(name = "name", required = false) String name,
                                                                             @RequestParam(name = "status", required = false) String status,
                                                                             @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                                                             @RequestParam(name = "page", defaultValue = "1") Integer page);

    @PostMapping("/api/merchant/goods/classification/saveOrUpdate")
    Response saveOrUpdateMerchantGoodsClassification(@RequestBody MerchantGoodsClassification merchantGoodsClassification);

    /**
     * 前台获取启用状态商品分类树.
     *
     * @return the prefecture tree
     */
    @GetMapping("/api/merchant/goods/classification/getOpenTree")
    Response<List<TreeDto<MerchantGoodsClassification>>> getOpenTree();

    /**
     * 前台根据商品分类编码查询其启用状态的下级列表
     *
     * @param goodsClassificationCode 商品分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/goods/classification/openListByGoodsClassificationCode")
    public Response<List<MerchantGoodsClassification>> openListByGoodsClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /********************************************* yifenrui 商品分类  end******************************************************/

    /********************************************* huhailong 商品库存  start******************************************************/
    /**
     * 库存列表
     *
     * @param goodsCode               商品编码
     * @param goodsName               商品名称
     * @param brandCode               品牌编码
     * @param supplierCode            品牌名称
     * @param goodsClassificationCode 分类编码
     * @param orderBy                 排序字段
     * @param direction               生序降序
     * @param limit                   每页多少条
     * @param page                    当前第几页
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/queryPage")
    PageTable<MerchantGoodsStock> merchantGoodsStockPageTable(
            @RequestParam(value = "goodsCode", required = false) String goodsCode,
            @RequestParam(value = "goodsName", required = false) String goodsName,
            @RequestParam(value = "brandCode", required = false) String brandCode,
            @RequestParam(value = "supplierCode", required = false) String supplierCode,
            @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
            @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
            @RequestParam(value = "orderBy", required = false, defaultValue = "b.id") String orderBy,
            @RequestParam(value = "sort", required = false, defaultValue = "DESC") Sort.Direction direction,
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page);


    /**
     * 库存列表导出
     *
     * @param goodsCode
     * @param goodsName
     * @param brandCode
     * @param supplierCode
     * @param supplierCodeList
     * @param goodsClassificationCode
     * @param orderBy
     * @param direction
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/exportMerchantGoodsStock")
    Response<List<MerchantGoodsStock>> exportMerchantGoodsStock(
            @RequestParam(value = "goodsCode", required = false) String goodsCode,
            @RequestParam(value = "goodsName", required = false) String goodsName,
            @RequestParam(value = "brandCode", required = false) String brandCode,
            @RequestParam(value = "supplierCode", required = false) String supplierCode,
            @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
            @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
            @RequestParam(value = "orderBy", required = false, defaultValue = "b.id") String orderBy,
            @RequestParam(value = "sort", required = false, defaultValue = "DESC") Sort.Direction direction);

    /**
     * 获取详细信息，调整库存时使用
     *
     * @param goodsCode
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/getFullInfoByGoodsCode")
    Response<MerchantGoodsStock> getFullInfoByGoodsCode(@RequestParam(value = "goodsCode") String goodsCode);

    /**
     * 适用于后台库存调整 增加，减少，预警调整
     *
     * @param stockAdjustRequest
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/adjustStock")
    Response adjustStock(@RequestBody GoodsStockAdminAdjustRequestDto stockAdjustRequest);

    /**
     * 库存调整日志分页
     *
     * @param goodsCode 商品编码
     * @param limit     每页多少条
     * @param page      当前第几页
     * @return
     */
    @GetMapping("/api/merchant/goodsstocklog/queryPage")
    PageTable<MerchantGoodsStockLog> merchantGoodsStockLogPageTable(
            @RequestParam(value = "goodsCode", required = false) String goodsCode,
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page);

    /********************************************* huhailong 商品分类  end******************************************************/

    /********************************************* yinshihao 兑换商品  start******************************************************/

    /**
     * 批量新增兑换商品
     *
     * @param exchangeGoodsList
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoods/batchSaveExchangeGoods")
    Response batchSaveExchangeGoods(@RequestBody List<MerchantExchangeGoods> exchangeGoodsList, @RequestParam("operationUser") String operationUser);

    /**
     * 编辑兑换商品
     *
     * @param exchangeGoods
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoods/editExchangeGoods")
    Response editExchangeGoods(@RequestBody MerchantExchangeGoods exchangeGoods, @RequestParam("map") Map map);

    /**
     * 兑换商品列表数据查询
     *
     * @param name                    名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param supplierCode            供应商编码 全匹配
     * @param goodsClassificationCode 兑换商品分类编码 全匹配
     * @param goodsStatus             商品状态
     * @param exchangeGoodsStatus     兑换商品状态
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/queryPage")
    PageTable<MerchantExchangeGoods> merchantExchangeGoodsPageTable(@RequestParam(required = false, name = "name") String name,
                                                                    @RequestParam(required = false, name = "code") String code,
                                                                    @RequestParam(required = false, name = "goodsType") String goodsType,
                                                                    @RequestParam(required = false, name = "brandCode") String brandCode,
                                                                    @RequestParam(required = false, name = "supplierCode") String supplierCode,
                                                                    @RequestParam(required = false, name = "goodsClassificationCode") String goodsClassificationCode,
                                                                    @RequestParam(required = false, name = "goodsStatus") String goodsStatus,
                                                                    @RequestParam(required = false, name = "exchangeGoodsStatus") String exchangeGoodsStatus,
                                                                    @RequestParam(required = false, name = "invented") String invented,
                                                                    @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                                    @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                    @RequestParam(defaultValue = "1", name = "page") int page);

    /**
     * 操作兑换商品状态
     *
     * @param code       兑换商品编码
     * @param status     目标兑换商品状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/operateStatus")
    Response merchantExchangeGoodsStatusOperate(@RequestParam("code") String code, @RequestParam("status") String status, @RequestParam("updateUser") String updateUser, @RequestParam("goodsType") String goodsType);

    /**
     * 根据兑换商品编码获取兑换商品详情
     *
     * @param code 兑换商品编码
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/goodsDetail")
    Response<MerchantExchangeGoods> merchantExchangeGoodsDetailByCode(@RequestParam("code") String code, @RequestParam("goodsType") String goodsType);

    /**
     * 前端根据兑换商品编码和用户信息获取兑换商品详情
     *
     * @param code 兑换商品编码
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/goodsDetailByCodeAndUser")
    Response<MerchantExchangeGoods> goodsDetailByCodeAndUser(@RequestParam("code") String code,
                                                             @RequestParam(value = "identityCode") List<String> identityCode,
                                                             @RequestParam(value = "phone") String phone,
                                                             @RequestParam("goodsType") String goodsType);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/batch/status")
    Response merchantExchangeGoodsBatchOperateStatus(@RequestParam("codes") String[] codes, @RequestParam("status") String status, @RequestParam("operateUser") String operateUser, @RequestParam("goodsType") String goodsType);

    /**
     * 设置排序值
     *
     * @param code
     * @param seq
     * @param updateUser
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoods/setSeq")
    Response setSeq(@RequestParam("code") String code, @RequestParam("seq") Integer seq, @RequestParam("updateUser") String updateUser, @RequestParam("goodsType") String goodsType);

    /**
     * 查询所有兑换商品列表
     *
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/merchantExchangeGoodsList")
    Response<List<MerchantExchangeGoods>> merchantExchangeGoodsList(@RequestParam("goodsType") String goodsType);

    /**
     * 前台查询兑换商品列表
     *
     * @param openAgentPrice
     * @param keyword
     * @param sortType
     * @param goodsClassificationCode
     * @param brandCodeList
     * @param minPrice
     * @param maxPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/findExchangeGoodsList")
    PageTable<MerchantExchangeGoods> findExchangeGoodsList(@RequestParam("openAgentPrice") String openAgentPrice,
                                                           @RequestParam(value = "keyword", required = false) String keyword,
                                                           @RequestParam(value = "sortType") String sortType,
                                                           @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                           @RequestParam(value = "brandCodeList", required = false) List<String> brandCodeList,
                                                           @RequestParam(value = "minPrice", required = false) String minPrice,
                                                           @RequestParam(value = "maxPrice", required = false) String maxPrice,
                                                           @RequestParam(value = "identityCode") List<String> identityCode,
                                                           @RequestParam(value = "phone") String phone,
                                                           @RequestParam(value = "goodsType") String goodsType,
                                                           @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据兑换商品状态查询总数
     *
     * @param status 兑换商品状态,若不传则代表查询所有状态的商品
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/getTotalExchangeGoods")
    Response<Integer> getTotalExchangeGoods(@RequestParam(required = false, value = "status") String status, @RequestParam(value = "goodsType") String goodsType);

    /**
     * 前端获取随机8件上架的兑换商品
     *
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/findRandomLimitEight")
    Response<List<MerchantExchangeGoods>> findRandomLimitEight(@RequestParam(value = "goodsType") String goodsType);

    /**
     * 前端根据兑换商品编码和用户信息获取兑换商品最低价格
     *
     * @param code 兑换商品编码
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/getGoodsMinAppointPrice")
    Response<BigDecimal> getGoodsMinAppointPrice(@RequestParam("code") String code,
                                                 @RequestParam(value = "identityCode") List<String> identityCode,
                                                 @RequestParam(value = "phone") String phone,
                                                 @RequestParam(value = "goodsType") String goodsType);

    /**
     * 首页根据排序值获取10个兑换商品
     *
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/getTenExchangeGoodsBySort")
    Response<List<MerchantExchangeGoods>> getTenExchangeGoodsBySort();
    /********************************************* yinshihao 兑换商品  end******************************************************/

    /********************************************* yinshihao 兑换商品操作日志  start******************************************************/

    /**
     * 兑换商品操作日期记录
     *
     * @param goodsCode 商品编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */

    @GetMapping("/api/merchant/exchangeGoodsLog/queryPage")
    PageTable<MerchantExchangeGoodsLog> merchantExchangeGoodsLogPageTable(@RequestParam("goodsCode") String goodsCode,
                                                                          @RequestParam("goodsType") String goodsType,
                                                                          @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                          @RequestParam(defaultValue = "1", name = "page") int page);

    /********************************************* yinshihao 兑换商品操作日志  end******************************************************/

    /********************************************* yinshihao 兑换商品特价  start******************************************************/

    /**
     * 导入
     *
     * @param merchantExchangeGoodsSpecialPriceList
     * @param updateUser
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoodsSpecialPrice/importAppointPrice")
    Response importAppointPrice(@RequestBody List<MerchantExchangeGoodsSpecialPrice> merchantExchangeGoodsSpecialPriceList, @RequestParam("updateUser") String updateUser, @RequestParam("goodsType") String goodsType);

    /**
     * 根据手机号查询该用户是否是代理人
     *
     * @param phone
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoodsSpecialPrice/getUserIsAgent")
    Response getUserIsAgent(@RequestParam(value = "phone") String phone, @RequestParam(value = "goodsType") String goodsType);

    /********************************************* yinshihao 兑换商品特价  end******************************************************/

    /********************************************* huhl 数据权限管理  start******************************************************/
    @GetMapping("/api/merchant/supplier/supplierList")
    Response<List<MerchantSupplier>> merchantSupplierList();

    /********************************************* huhl 数据权限管理  end******************************************************/

    /******************************************************huhl 订单库存操作 start******************************************************************/
    /**
     * 订单库存占用，非购物车形式订单；一个订单就一个商品
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockOccupied")
    Response orderStockOccupied(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 订单库存扣减，非购物车形式订单；
     * 使用订单号维度, 获取库存占用记录,根据占用数进行库存：占用减少，销售增加。
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockReduce")
    Response orderStockOut(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 订单库存还原，非购物车形式订单；
     * 使用订单号维度, 获取库存占用记录,根据占用记录决定还原占用库存/已出库库存，影响库存。
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockCancel")
    Response orderStockCancel(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 订单虚拟商品出库占用卡密，非购物车形式订单。
     * 使用订单号维度，占用卡券后没有还原操作
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderVCardSend")
    Response orderVCardSend(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 根据订单号获取卡密，只传递订单号就行
     *
     * @param orderNo
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/getVCardByOrderNo")
    Response<List<OrderVCardResponseItem>> getVCardByOrderNo(@RequestParam("orderNo") String orderNo);

    /**
     * 展示
     *
     * @param query
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/queryPage")
    PageTable<MerchantGoodsVCardStock> merchantGoodsVCardStockPageTable(@RequestBody GoodsVcardStockPageRequestDto query);

    /**
     * 导入
     *
     * @param vCardStocks
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/importBatchVCard")
    Response<Integer> importBatchVCard(@RequestBody List<MerchantGoodsVCardStock> vCardStocks);

    /**
     * huhl 添加，得到用户供应商权限中的所有虚拟商品编码，为了导入虚拟卡时进行校验
     *
     * @return
     */
    @PostMapping("/api/merchant/goods/getSupplierInventedGoodsCodeList")
    Response<List<String>> getSupplierInventedGoodsCodeList(@RequestBody List<String> supplierCodeList);

    /**
     * @param requestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/setVCardToVoid")
    Response setVCardToVoid(@RequestBody VCardToVoidRequestDTO requestDTO);

    /**
     * 更新无效库存任务
     *
     * @return
     */
    @GetMapping("/api/merchant/goodsvcardstock/updateVCardExpireTask")
    Response updateVCardExpireTask();

    /*******************************************************huhl 订单库存操作 end**************************************************/

    /*******************************************************yifenrui 商户投保礼 start**************************************************/

    /**
     * 后台投保礼-商品列表
     *
     * @param code
     * @param giftType
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/goodsList")
    PageTable<MerchantInsuranceGift> getMerchantInsuranceGiftByStoreCodeAndTypePageTable(@RequestParam(name = "code") String code, @RequestParam(name = "giftType") String giftType,
                                                                                         @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                                         @RequestParam(value = "page", defaultValue = "1") int page);

    @GetMapping("/api/merchant/insurancegift/getCombPackagePageTable")
    PageTable<MerchantInsuranceGift> getCombPackagePageTable(@RequestParam(name = "code") String code, @RequestParam(name = "giftType") String giftType,
                                                             @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                             @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 后台投保礼-更改状态和排序
     *
     * @param merchantInsuranceGift
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/statusOrSort")
    Response switchMerchantInsuranceGiftStatusOrSort(@RequestBody MerchantInsuranceGift merchantInsuranceGift);


    /**
     * 组合套餐修改
     *
     * @param merchantInsuranceGift
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/switchComPackageStatusOrSort")
    Response switchComPackageStatusOrSort(@RequestBody MerchantInsuranceGift merchantInsuranceGift);


    /**
     * 后台投保礼-通过id删除
     *
     * @param merchantInsuranceGift
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/removeById")
    Response removeById(@RequestBody MerchantInsuranceGift merchantInsuranceGift);

    /**
     * 后台投保礼-获取商户关联的投保礼code
     *
     * @param merchantInsuranceGift
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/getGoodCodes")
    Response getGoodCodes(@RequestBody MerchantInsuranceGift merchantInsuranceGift);

    @PostMapping("/api/merchant/insurancegift/getCombCodes")
    Response getCombCodes(@RequestBody MerchantInsuranceGiftCombRelate merchantInsuranceGiftCombRelate);

    /**
     * 后台新增投保礼
     *
     * @param merchantInsuranceGift
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/createGift")
    Response createGift(@RequestBody List<MerchantInsuranceGift> merchantInsuranceGift);


    @PostMapping("/api/merchant/account/createPermission")
    Response createPermission(@RequestBody List<MerchantStoreAccountPermission> merchantStoreAccountPermission);


    @PostMapping("/api/merchant/insurancegift/createPackageGift")
    Response createPackageGift(@RequestBody List<MerchantInsuranceGiftCombRelate> merchantInsuranceGiftCombRelate);

    /**
     * 商户聚合端接口-选择投保礼
     *
     * @param storeCode
     * @param keyword
     * @param giftType
     * @param minMarketPrice
     * @param maxMarketPrice
     * @param minCostPrice
     * @param maxCostPrice
     * @param marketPriceASC
     * @param marketPriceDESC
     * @param costPriceASC
     * @param costPriceDESC
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/queryGiftList")
    Response<List<MerchantInsuranceGift>> queryGiftList(@RequestParam(value = "storeCode", required = false) String storeCode, @RequestParam(value = "keyword", required = false) String keyword, @RequestParam(value = "giftType") String giftType,
                                                        @RequestParam(value = "remainPrice") BigDecimal remainPrice, @RequestParam(value = "minMarketPrice", required = false) String minMarketPrice, @RequestParam(value = "maxMarketPrice", required = false) String maxMarketPrice,
                                                        @RequestParam(value = "minCostPrice", required = false) String minCostPrice, @RequestParam(value = "maxCostPrice", required = false) String maxCostPrice, @RequestParam(value = "marketPriceASC", required = false) String marketPriceASC,
                                                        @RequestParam(value = "marketPriceDESC", required = false) String marketPriceDESC, @RequestParam(value = "costPriceASC", required = false) String costPriceASC,
                                                        @RequestParam(value = "costPriceDESC", required = false) String costPriceDESC);

    /**
     * 选择投保礼
     *
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/queryGiftPage")
    PageTable<MerchantInsuranceGift> queryGiftPage(@RequestBody ReqParamGift req);

    /**
     * 商户聚合端接口-推荐商品
     *
     * @param storeCode
     * @param remainPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/queryRecommendGiftList")
    PageTable<MerchantInsuranceGift> queryRecommendGiftList(@RequestParam(value = "storeCode", required = false) String storeCode, @RequestParam(value = "remainPrice") BigDecimal remainPrice,
                                                            @RequestParam(value = "costCoefficent") String costCoefficent, @RequestParam(value = "inflationCoefficent") String inflationCoefficent,
                                                            @RequestParam(value = "remainFloatCoefficent") String remainFloatCoefficent, @RequestParam(value = "remainPriceCoefficent") String remainPriceCoefficent,
                                                            @RequestParam(value = "limit", defaultValue = "20") int limit, @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据商户编号，礼品编号list获取礼品列表
     *
     * @param codes
     * @param storeCode
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/findMerchantGiftListByCodes")
    Response<List<MerchantInsuranceGift>> findMerchantGiftListByCodes(@RequestParam(value = "codes") List<String> codes, @RequestParam(value = "storeCode", required = false) String storeCode);


    /**
     * 根据商品code+商户code查询投保礼价格
     *
     * @param goodsCode
     * @param storeCode
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/getMerchantGiftDetailByGoodsCodeAndStoreCode")
    Response<MerchantInsuranceGift> getMerchantGiftDetailByGoodsCodeAndStoreCode(@RequestParam(value = "goodsCode") String goodsCode, @RequestParam(value = "storeCode", required = false) String storeCode);

    /**
     * 组合套餐-项目列表
     *
     * @param code
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/getCombRelatePackageGiftByStoreCodeAndTypePageTable")
    Response<List<MerchantInsuranceGiftCombRelate>> getCombRelatePackageGiftByStoreCodeAndTypePageTable(@RequestParam(name = "code") String code);


    /**
     * 设置全部投保礼列表
     *
     * @param code
     * @param code
     * @param name
     * @param type
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/totalgift/merchantMerchantInsuranceTotalGiftPageTable")
    PageTable<MerchantInsuranceTotalGift> merchantMerchantInsuranceTotalGiftPageTable(
            @RequestParam(value = "code", required = false) String code,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "type", required = false) String type,
            @RequestParam(value = "typeStatus", required = false) String typeStatus,
            @RequestParam(value = "status", required = false) String status,
            @RequestParam(value = "sourceType", required = false) String sourceType,
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 礼品类型查询code列表
     *
     * @param merchantInsuranceTotalGift
     * @return
     */
    @PostMapping("/api/merchant/totalgift/getTotalGiftGoodCodes")
    Response getTotalGiftGoodCodes(@RequestBody MerchantInsuranceTotalGift merchantInsuranceTotalGift);

    /**
     * 后台新增全部投保礼
     *
     * @param merchantInsuranceTotalGift
     * @return
     */
    @PostMapping("/api/merchant/totalgift/createTotalGift")
    Response createTotalGift(@RequestBody List<MerchantInsuranceTotalGift> merchantInsuranceTotalGift);


    /**
     * 后台全部投保礼-更改状态和排序
     *
     * @param merchantInsuranceTotalGift
     * @return
     */
    @PostMapping("/api/merchant/totalgift/statusOrSort")
    Response switchMerchantInsuranceTotalGiftStatusOrSort(@RequestBody MerchantInsuranceTotalGift merchantInsuranceTotalGift);


    /**
     * 根据礼品编码获取指定角色列表
     *
     * @param giftCode 礼品编码
     * @return
     */
    @GetMapping("/api/merchant/totalgift/giftRoleList")
    Response<List<MerchantInsuranceTotalGiftRoleRelate>> giftRoleList(@RequestParam("giftCode") String giftCode);


    /**
     * 获取通用投保礼列表
     *
     * @param status
     * @param code
     * @param excludedCode
     * @return
     */
    @GetMapping("/api/merchant/totalgift/searchOilCashCouponForTotalGift")
    Response<List<MerchantInsuranceTotalGift>> searchOilCashCouponForTotalGift(@RequestParam(value = "status", defaultValue = "UP_LIST") String status,
                                                                               @RequestParam(value = "code", required = false) String code,
                                                                               @RequestParam(value = "excludedCode", required = false) String[] excludedCode);

    /**
     * 后台全部投保礼-编辑投保礼
     *
     * @param merchantInsuranceTotalGift
     * @param map
     * @return
     */
    @PostMapping("/api/merchant/totalgift/editMerchantInsuranceTotalGift")
    Response editMerchantInsuranceTotalGift(@RequestBody MerchantInsuranceTotalGift merchantInsuranceTotalGift, @RequestParam("map") Map map);

    /**
     * 后台全部投保礼-全部投保礼日志
     *
     * @param giftCode
     * @param limit
     * @param page
     * @return
     */

    @GetMapping("/api/merchant/totalgift/merchantTotalGiftLogPageTable")
    PageTable<MerchantInsuranceTotalGiftLog> merchantTotalGiftLogPageTable(@RequestParam("giftCode") String giftCode,
                                                                           @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                           @RequestParam(defaultValue = "1", name = "page") int page);


    /**
     * 后台全部投保礼-批量
     *
     * @param codes
     * @param status
     * @param operateUser
     * @return
     */
    @GetMapping("/api/merchant/totalgift/merchantTotalGiftBatchOperateStatus")
    Response merchantTotalGiftBatchOperateStatus(@RequestParam("codes") String[] codes, @RequestParam("status") String status, @RequestParam("operateUser") String operateUser);

    /**
     * 通用投保礼更改排序检测重复
     *
     * @param type
     * @param sort
     * @return
     */
    @GetMapping("/api/merchant/totalgift/updateTotalGiftSortCheck")
    Response<List<MerchantInsuranceTotalGift>> updateTotalGiftSortCheck(@RequestParam(value = "id", required = false) Integer id,
                                                                        @RequestParam(value = "type", required = false) String type,
                                                                        @RequestParam(value = "sort", required = false) Integer sort,
                                                                        @RequestParam(value = "sourceType", required = false) String sourceType);


    /**
     * 商户投保礼更改排序检测重复-组合套餐，项目
     *
     * @param relateType
     * @param sort
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/updateGiftSortCheck")
    Response<List<MerchantInsuranceGift>> updateGiftSortCheck(@RequestParam(value = "id", required = false) Integer id,
                                                              @RequestParam(value = "storeCode", required = false) String storeCode,
                                                              @RequestParam(value = "relateType", required = false) String relateType, @RequestParam(value = "sort", required = false) Integer sort);

    /**
     * 首页板块推荐--  根据投保礼商品编码列表查询对应信息  尹世豪加
     *
     * @param codes
     * @return
     */
    @GetMapping("/api/merchant/totalgift/findTotalGiftListByCodes")
    Response<List<MerchantInsuranceTotalGift>> findTotalGiftListByCodes(@RequestParam(value = "codes") List<String> codes, @RequestParam(value = "status", required = false) String status);


    /**
     * 通用投保礼弹窗
     *
     * @param keyword
     * @param code
     * @param noGiftsCodeList
     * @param status
     * @param queryType
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/totalgift/queryPageNoTotalGift")
    PageTable<MerchantInsuranceTotalGift> queryPageNoTotalGift(@RequestParam(value = "keyword", required = false) String keyword,
                                                               @RequestParam(value = "code", required = false) String code,
                                                               @RequestParam(value = "noGiftsCodeList", required = false) List<String> noGiftsCodeList,
                                                               @RequestParam(value = "status", required = false) String status,
                                                               @RequestParam(value = "sourceType", required = false) String sourceType,
                                                               @RequestParam(value = "queryType", required = false) String queryType,
                                                               @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                               @RequestParam(value = "page", defaultValue = "1") int page);
    /*******************************************************yifenrui 商户投保礼 end**************************************************/

    /*********************************************************huhailong 购物车形式订单库存操作***************************************/

    /**
     * 订单库存占用，类似购物车形式。因先按是单商品购物写的库存管理，后面需求调整有需要类似购物车形式的，单商品库存管理保留。
     * 一次占用多个商品库存，参数goods是必填
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockOccupied")
    Response orderBatchStockOccupied(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 订单库存发货扣减，类似购物车形式。因先按是单商品购物写的库存管理，后面需求调整有需要类似购物车形式的，单商品库存管理保留。
     * 使用订单号维度 整体进行商品的库存扣减。并不使用goods参数。
     *
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockReduce")
    Response orderBatchStockReduce(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 订单库存还原，类似购物车形式。因先按是单商品购物写的库存管理，后面需求调整有需要类似购物车形式的，单商品库存管理保留。
     * 实现里面 使用到了 cancelGoodList，看着是支持部分商品取消，但后来咨询同同，说后面又不需要部分取消了。
     * 如果不需要部分取消只传递订单号，如果需要部分取消传递cancelGoodList
     *
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockCancel")
    Response orderBatchStockCancel(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 订单虚拟卡密发货，类似购物车形式。因先按是单商品购物写的库存管理，后面需求调整有需要类似购物车形式的，单商品库存管理保留。
     * 使用订单号维度，获取此订单占用记录的所有商品，过滤出没有取消库存的虚拟商品，占用库存。要成功都成功，卡密库存不足则不能发货
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchVCardSend")
    Response orderBatchVCardSend(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 查询商品列表，含库存
     *
     * @param paramGoods
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/queryListWithStock")
    Response<List<MerchantGoodsStock>> queryListWithStock(@RequestBody ReqParamGoods paramGoods);
    /*********************************************************huhailong 购物车形式订单库存操作 end***************************************/

    // =========  start of  商户身份   ===========

    /**
     * Save or update merchant identity response.
     *
     * @param merchantIdentity the merchant identity
     * @return the response
     */
    @PostMapping("/api/merchant/merchant-identity")
    Response saveOrUpdateMerchantIdentity(@RequestBody MerchantStoreAccountIdentity merchantIdentity);

    /**
     * List merchant identity response.
     *
     * @param storeAccountCode the storeAccountCode
     * @return the response
     */
    @GetMapping("/api/merchant/merchant-identity/list")
    Response<List<MerchantStoreAccountIdentity>> listMerchantStoreIdentity(@RequestParam(value = "storeAccountCode", required = false) String storeAccountCode,
                                                                           @RequestParam(value = "identityTypeCode", required = false) String identityTypeCode);
    // =========  end of  商户身份   ===========


    /*********************************************************huhailong 购物车形式订单库存操作 begin***************************************/

    /**
     * 业务端 订单库存重复占用，场景订单占用库存，取消后，重新占用库存.
     * 原订单需要都取消库存后，再调用这个接口
     * 会删除流水记录，重新占用库存
     *
     * @param orderStockRequestDTO 多个商品的库存占用
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockRepeatOccupied")
    Response orderBatchStockRepeatOccupied(@RequestBody OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 通过商户编码查询可用库存
     *
     * @param codes 商品编码列表
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/merchantGoodsSellableStock")
    Response<List<MerchantGoodsStock>> merchantGoodsSellableStock(@RequestBody List<String> codes);
    /*********************************************************huhailong 购物车形式订单库存操作 end***************************************/

    /********************************************* yinshihao ROCO商城商品  start******************************************************/

    /**
     * 批量新增ROCO商城商品
     *
     * @param rocoMallGoodsList
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoods/batchSaveRocoMallGoods")
    Response batchSaveRocoMallGoods(@RequestBody List<MerchantRocoMallGoods> rocoMallGoodsList, @RequestParam("operationUser") String operationUser);

    /**
     * 编辑ROCO商城商品
     *
     * @param rocoMallGoods
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoods/editRocoMallGoods")
    Response editRocoMallGoods(@RequestBody MerchantRocoMallGoods rocoMallGoods, @RequestParam("map") Map map);

    /**
     * ROCO商城商品列表数据查询
     *
     * @param name                    名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param supplierCode            供应商编码 全匹配
     * @param goodsClassificationCode ROCO商城商品分类编码 全匹配
     * @param goodsStatus             商品状态
     * @param rocoMallGoodsStatus     ROCO商城商品状态
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/queryPage")
    PageTable<MerchantRocoMallGoods> merchantRocoMallGoodsPageTable(@RequestParam(required = false, name = "name") String name,
                                                                    @RequestParam(required = false, name = "code") String code,
                                                                    @RequestParam(required = false, name = "brandCode") String brandCode,
                                                                    @RequestParam(required = false, name = "supplierCode") String supplierCode,
                                                                    @RequestParam(required = false, name = "goodsClassificationCode") String goodsClassificationCode,
                                                                    @RequestParam(required = false, name = "goodsStatus") String goodsStatus,
                                                                    @RequestParam(required = false, name = "rocoMallGoodsStatus") String rocoMallGoodsStatus,
                                                                    @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                                    @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                    @RequestParam(defaultValue = "1", name = "page") int page);

    /**
     * 操作ROCO商城商品状态
     *
     * @param code       ROCO商城商品编码
     * @param status     目标ROCO商城商品状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/operateStatus")
    Response merchantRocoMallGoodsStatusOperate(@RequestParam("code") String code, @RequestParam("status") String status, @RequestParam("updateUser") String updateUser);

    /**
     * 根据ROCO商城商品编码获取ROCO商城商品详情
     *
     * @param code ROCO商城商品编码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/goodsDetail")
    Response<MerchantRocoMallGoods> merchantRocoMallGoodsDetailByCode(@RequestParam("code") String code);

    /**
     * 前端根据ROCO商城商品编码和用户信息获取ROCO商城商品详情
     *
     * @param code ROCO商城商品编码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/goodsDetailByCodeAndUser")
    Response<MerchantRocoMallGoods> goodsDetailByCodeAndUser(@RequestParam("code") String code,
                                                             @RequestParam(value = "identityCode") List<String> identityCode,
                                                             @RequestParam(value = "phone") String phone);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/batch/status")
    Response merchantRocoMallGoodsBatchOperateStatus(@RequestParam("codes") String[] codes, @RequestParam("status") String status, @RequestParam("operateUser") String operateUser);

    /**
     * 设置排序值
     *
     * @param code
     * @param seq
     * @param updateUser
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoods/setSeq")
    Response setSeq(@RequestParam("code") String code, @RequestParam("seq") Integer seq, @RequestParam("updateUser") String updateUser);

    /**
     * 查询所有ROCO商城商品列表
     *
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/merchantRocoMallGoodsList")
    Response<List<MerchantRocoMallGoods>> merchantRocoMallGoodsList();

    /**
     * 前台查询ROCO商城商品列表
     *
     * @param openAgentPrice
     * @param keyword
     * @param sortType
     * @param goodsClassificationCode
     * @param brandCodeList
     * @param minPrice
     * @param maxPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/findRocoMallGoodsList")
    PageTable<MerchantRocoMallGoods> findRocoMallGoodsList(@RequestParam("openAgentPrice") String openAgentPrice,
                                                           @RequestParam(value = "keyword", required = false) String keyword,
                                                           @RequestParam(value = "sortType") String sortType,
                                                           @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                           @RequestParam(value = "brandCodeList", required = false) List<String> brandCodeList,
                                                           @RequestParam(value = "minPrice", required = false) String minPrice,
                                                           @RequestParam(value = "maxPrice", required = false) String maxPrice,
                                                           @RequestParam(value = "identityCode") List<String> identityCode,
                                                           @RequestParam(value = "phone") String phone,
                                                           @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据ROCO商城商品状态查询总数
     *
     * @param status ROCO商城商品状态,若不传则代表查询所有状态的商品
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/getTotalRocoMallGoods")
    Response<Integer> getTotalRocoMallGoods(@RequestParam(required = false, value = "status") String status);

    /**
     * 前端获取随机8件上架的ROCO商城商品
     *
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/findRandomLimitEight")
    Response<List<MerchantRocoMallGoods>> findRandomLimitEight();

    /**
     * 前端根据ROCO商城商品编码和用户信息获取ROCO商城商品最低价格
     *
     * @param code ROCO商城商品编码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/getGoodsMinAppointPrice")
    Response<BigDecimal> getGoodsMinAppointPrice(@RequestParam("code") String code,
                                                 @RequestParam(value = "identityCode") List<String> identityCode,
                                                 @RequestParam(value = "phone") String phone);

    /**
     * 前台匿名查询ROCO商城商品列表
     *
     * @param keyword
     * @param sortType
     * @param goodsClassificationCode
     * @param brandCodeList
     * @param minPrice
     * @param maxPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/noAccessFindRocoMallGoodsList")
    PageTable<MerchantRocoMallGoods> noAccessFindRocoMallGoodsList(@RequestParam(value = "keyword", required = false) String keyword,
                                                                   @RequestParam(value = "sortType") String sortType,
                                                                   @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                                   @RequestParam(value = "brandCodeList", required = false) List<String> brandCodeList,
                                                                   @RequestParam(value = "minPrice", required = false) String minPrice,
                                                                   @RequestParam(value = "maxPrice", required = false) String maxPrice,
                                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /********************************************* yinshihao ROCO商城商品  end******************************************************/

    /********************************************* yinshihao ROCO商城商品操作日志  start******************************************************/

    /**
     * ROCO商城商品操作日期记录
     *
     * @param goodsCode 商品编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */

    @GetMapping("/api/merchant/rocoMallGoodsLog/queryPage")
    PageTable<MerchantRocoMallGoodsLog> merchantRocoMallGoodsLogPageTable(@RequestParam("goodsCode") String goodsCode,
                                                                          @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                          @RequestParam(defaultValue = "1", name = "page") int page);

    /********************************************* yinshihao ROCO商城商品操作日志  end******************************************************/

    /********************************************* yinshihao ROCO商城商品特价  start******************************************************/

    /**
     * 导入
     *
     * @param merchantRocoMallGoodsSpecialPriceList
     * @param updateUser
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoodsSpecialPrice/importAppointPrice")
    Response importAppointPrice(@RequestBody List<MerchantRocoMallGoodsSpecialPrice> merchantRocoMallGoodsSpecialPriceList, @RequestParam("updateUser") String updateUser);

    /**
     * 根据手机号查询该用户是否是代理人
     *
     * @param phone
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoodsSpecialPrice/getUserIsAgent")
    Response getUserIsAgent(@RequestParam(value = "phone") String phone);

    /********************************************* yinshihao ROCO商城商品特价  end******************************************************/


    /********************************************* yifenrui 代理人一键购买  start******************************************************/

    /**
     * 一键购买商品
     *
     * @param keyword
     * @param goodsClassificationCode
     * @param minSettlePrice
     * @param maxSettlePrice
     * @param minMarketPrice
     * @param maxMarketPrice
     * @param settlePriceASC
     * @param settlePriceDESC
     * @param marketPriceASC
     * @param marketPriceDESC
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/queryOneClickGoodsList")
    PageTable<MerchantInsuranceGift> queryOneClickGoodsList(@RequestParam(value = "keyword", required = false) String keyword,
                                                            @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                            @RequestParam(value = "minSettlePrice", required = false) String minSettlePrice,
                                                            @RequestParam(value = "maxSettlePrice", required = false) String maxSettlePrice,
                                                            @RequestParam(value = "minMarketPrice", required = false) String minMarketPrice,
                                                            @RequestParam(value = "maxMarketPrice", required = false) String maxMarketPrice,
                                                            @RequestParam(value = "settlePriceASC", required = false) String settlePriceASC,
                                                            @RequestParam(value = "settlePriceDESC", required = false) String settlePriceDESC,
                                                            @RequestParam(value = "marketPriceASC", required = false) String marketPriceASC,
                                                            @RequestParam(value = "marketPriceDESC", required = false) String marketPriceDESC,
                                                            @RequestParam(value = "discountASC", required = false) String discountASC,
                                                            @RequestParam(value = "discountDESC", required = false) String discountDESC,
                                                            @RequestParam(value = "limit", defaultValue = "20") int limit, @RequestParam(value = "page", defaultValue = "1") int page);


    /**
     * 车主端-获取商品1级分类
     *
     * @return
     */
    @GetMapping("/api/merchant/goods/classification/getFirstGoodsClassification")
    Response<List<MerchantGoodsClassification>> getFirstGoodsClassification();


    /**
     * 车主端-查看一键购买商品详情
     *
     * @param code
     * @return
     */
    @GetMapping("/api/merchant/totalgift/merchantInsuranceTotalGiftDetailByCode")
    Response<MerchantInsuranceTotalGift> merchantInsuranceTotalGiftDetailByCode(@RequestParam(value = "code") String code);
    /********************************************* yifenrui 代理人一键购买  end******************************************************/


    /********************************************* yinshihao 代理商  start******************************************************/

    /**
     * 代理商列表
     *
     * @param code
     * @param name
     * @param status
     * @param businessLicenseName
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/agent")
    PageTable<MerchantAgent> searchAgent(@RequestParam(value = "code", required = false) String code,
                                         @RequestParam(value = "name", required = false) String name,
                                         @RequestParam(value = "businessLicenseName", required = false) String businessLicenseName,
                                         @RequestParam(value = "abbreviation", required = false) String abbreviation,
                                         @RequestParam(value = "provinceCode", required = false) String provinceCode,
                                         @RequestParam(value = "cityCode", required = false) String cityCode,
                                         @RequestParam(value = "districtCode", required = false) String districtCode,
                                         @RequestParam(value = "status", required = false) String status,
                                         @RequestParam(value = "agentCodePermissionList", required = false) List<String> agentCodePermissionList,
                                         @RequestParam(value = "sortBy", required = false) String sortBy,
                                         @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                         @RequestParam(value = "page", defaultValue = "1") Integer page);

    /**
     * 新增和更新代理商
     *
     * @param merchantAgent
     * @return
     */
    @PostMapping("/api/merchant/agent/createOrUpdateMerchantAgent")
    Response createOrUpdateMerchantAgent(@RequestBody MerchantAgent merchantAgent);

    /**
     * 根据编码获取代理商详情
     *
     * @param code 代理商编码
     * @return
     */
    @GetMapping("/api/merchant/agent/agentDetail")
    Response<MerchantAgent> merchantAgentDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 更改代理商状态
     *
     * @param code
     * @param status
     * @param updateUser
     * @return
     */
    @GetMapping("/api/merchant/agent/operateStatus")
    Response merchantAgentStatusOperate(
            @RequestParam(value = "code") String code,
            @RequestParam(value = "status") String status,
            @RequestParam(value = "updateUser") String updateUser);

    /**
     * 获取代理商列表
     *
     * @param name
     * @param businessLicenseName
     * @param code
     * @param status
     */
    @GetMapping("/api/merchant/agent/merchantAgentList")
    Response<List<MerchantAgent>> merchantAgentList(@RequestParam(name = "code", required = false) String code,
                                                    @RequestParam(name = "name", required = false) String name,
                                                    @RequestParam(name = "businessLicenseName", required = false) String businessLicenseName,
                                                    @RequestParam(name = "status", required = false) String status);

    /**
     * 获取代理商列表
     *
     * @param code
     * @param name
     * @param businessLicenseName
     * @param status
     */
    @GetMapping("/api/merchant/agent/merchantAgentListWithTree")
    public Response<List<MerchantAgent>> merchantAgentListWithTree(@RequestParam(name = "code", required = false) String code,
                                                                   @RequestParam(name = "name", required = false) String name,
                                                                   @RequestParam(name = "businessLicenseName", required = false) String businessLicenseName,
                                                                   @RequestParam(name = "status", required = false) String status);

    /**
     * 根据编码列表获取代理商详情列表
     *
     * @param codes 代理商编码列表
     * @return
     */
    @GetMapping("/api/merchant/agent/findAgentDetailListByCodes")
    Response<List<MerchantAgent>> findAgentDetailListByCodes(@RequestParam("codes") List<String> codes);

    /**
     * 获取供应商对应的额度转换比例
     *
     * @param code 供应商编码
     * @return
     */
    @GetMapping("/api/merchant/agent/findAgentQuotaConversionRatio")
    Response<BigDecimal> findAgentQuotaConversionRatio(@RequestParam("code") String code);

    /**
     * 获取代理商列表(导出用)
     *
     * @param code
     * @param name
     * @param businessLicenseName
     * @param status
     */
    @GetMapping("/api/merchant/agent/merchantAgentListForExport")
    Response<List<MerchantAgent>> merchantAgentListForExport(@RequestParam(name = "code", required = false) String code,
                                                             @RequestParam(name = "name", required = false) String name,
                                                             @RequestParam(name = "businessLicenseName", required = false) String businessLicenseName,
                                                             @RequestParam(name = "abbreviation", required = false) String abbreviation,
                                                             @RequestParam(name = "provinceCode", required = false) String provinceCode,
                                                             @RequestParam(name = "cityCode", required = false) String cityCode,
                                                             @RequestParam(name = "districtCode", required = false) String districtCode,
                                                             @RequestParam(name = "status", required = false) String status,
                                                             @RequestParam(value = "agentCodePermissionList", required = false) List<String> agentCodePermissionList);
    /********************************************* yinshihao 代理商   end******************************************************/

    /********************************************* yinshihao 合作客户  start******************************************************/
    /**
     * 合作客户列表
     *
     * @param agentCode
     * @param code
     * @param abbreviation
     * @param customerType
     * @param industryCodeList
     * @param sceneCodeList
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/cooperationCustomer")
    PageTable<MerchantCooperationCustomer> searchCooperationCustomer(@RequestParam(value = "agentCode", required = false) String agentCode,
                                                                     @RequestParam(value = "code", required = false) String code,
                                                                     @RequestParam(value = "name", required = false) String name,
                                                                     @RequestParam(value = "abbreviation", required = false) String abbreviation,
                                                                     @RequestParam(value = "customerType", required = false) String customerType,
                                                                     @RequestParam(value = "industryCodeList", required = false) List<String> industryCodeList,
                                                                     @RequestParam(value = "sceneCodeList", required = false) List<String> sceneCodeList,
                                                                     @RequestParam(value = "sortCodeList", required = false) List<String> sortCodeList,
                                                                     @RequestParam(value = "customerCodeList", required = false) List<String> customerCodeList,
                                                                     @RequestParam(value = "excludeCodeList", required = false) List<String> excludeCodeList,
                                                                     @RequestParam(value = "status", required = false) String status,
                                                                     @RequestParam(value = "businessBasis", required = false) String businessBasis,
                                                                     @RequestParam(value = "customerCategory", required = false) String customerCategory,
                                                                     @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                                                     @RequestParam(value = "page", defaultValue = "1") Integer page);

    /**
     * 新增和更新合作客户
     *
     * @param merchantCooperationCustomer
     * @return
     */
    @PostMapping("/api/merchant/cooperationCustomer/createOrUpdateMerchantCooperationCustomer")
    Response createOrUpdateMerchantCooperationCustomer(@RequestBody MerchantCooperationCustomer merchantCooperationCustomer);

    /**
     * 根据编码获取合作客户详情
     *
     * @param code 合作客户编码
     * @return
     */
    @GetMapping("/api/merchant/cooperationCustomer/cooperationCustomerDetail")
    Response<MerchantCooperationCustomer> merchantCooperationCustomerDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 更改合作客户状态
     *
     * @param code
     * @param status
     * @param updateUser
     * @return
     */
    @GetMapping("/api/merchant/cooperationCustomer/operateStatus")
    Response merchantCooperationCustomerStatusOperate(
            @RequestParam(value = "code") String code,
            @RequestParam(value = "status") String status,
            @RequestParam(value = "updateUser") String updateUser);

    /**
     * 获取合作客户列表
     *
     * @param agentCode
     * @param code
     * @param abbreviation
     * @param customerType
     * @param industryCodeList
     * @param sceneCodeList
     * @param status
     * @return
     */
    @GetMapping("/api/merchant/cooperationCustomer/merchantCooperationCustomerList")
    Response<List<MerchantCooperationCustomer>> merchantCooperationCustomerList(@RequestParam(value = "agentCode", required = false) String agentCode,
                                                                                @RequestParam(value = "code", required = false) String code,
                                                                                @RequestParam(value = "abbreviation", required = false) String abbreviation,
                                                                                @RequestParam(value = "customerType", required = false) String customerType,
                                                                                @RequestParam(value = "industryCodeList", required = false) List<String> industryCodeList,
                                                                                @RequestParam(value = "sceneCodeList", required = false) List<String> sceneCodeList,
                                                                                @RequestParam(value = "status", required = false) String status,
                                                                                @RequestParam(value = "customerCategory", required = false) String customerCategory);

    /**
     * 合作客户树
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/cooperationCustomer/treeList")
    Response<List<CategoryTreeDto>> customerTree(@RequestBody CooperationCustomerReq req);

    /**
     * 合作客户树(20210223修改, 新加层级关系)
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/cooperationCustomer/treeList2")
    Response<List<CategoryTreeDto>> treeList2(@RequestBody CooperationCustomerReq req);

    /**
     * 平台直营客户树
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/cooperationCustomer/newTreeList")
    Response<List<CategoryTreeDto>> newTreeList(@RequestBody CooperationCustomerReq req);
    /**
     * 根据编码列表获取合作客户详情列表
     *
     * @param codes 合作客户编码列表
     * @return
     */
    @GetMapping("/api/merchant/cooperationCustomer/findCustomerDetailListByCodes")
    Response<List<MerchantCooperationCustomer>> findCustomerListDetailByCodes(@RequestParam("codes") List<String> codes);

    /**
     * 根据所属代理商编码列表获取合作客户详情列表
     *
     * @param agentCodes 所属代理商编码列表
     * @return
     */
    @GetMapping("/api/merchant/cooperationCustomer/findCustomerListDetailByAgentCodes")
    Response<List<MerchantCooperationCustomer>> findCustomerListDetailByAgentCodes(@RequestParam("agentCodes") List<String> agentCodes);

    /**
     * 获取合作客户对应的额度转换比例
     *
     * @param code 合作客户编码
     * @return
     */
    @GetMapping("/api/merchant/cooperationCustomer/findCustomerQuotaConversionRatio")
    Response<BigDecimal> findCustomerQuotaConversionRatio(@RequestParam("code") String code);
    /********************************************* yinshihao 合作客户   end******************************************************/

    /********************************************* djt 代理商产品  start******************************************************/


    /**
     * 新增或者修改代理商产品
     *
     * @param saveReq
     * @return
     */
    @PostMapping("/api/merchant/agent/goods/saveOrUpdate")
    Response<String> saveOrUpdateAgentGoods(@RequestBody MerchantAgentGoodsSaveReq saveReq);


    /**
     * 批量添加商品
     *
     * @param batchSaveReq
     * @return
     */
    @PostMapping("/api/merchant/agent/goods/batch/save")
    Response<String> batchSaveAgentGoods(@RequestBody MerchantAgentGoodsBatchSaveReq batchSaveReq);


    /**
     * 更新代理商产品状态
     *
     * @param id     代理商产品id
     * @param status 代理商产品状态
     * @return
     */
    @GetMapping("/api/merchant/agent/goods/updateStatus")
    Response<String> updateStatusAgentGoods(@RequestParam("id") int id,
                                            @RequestParam("status") String status);


    /**
     * 批量更新代理商产品状态
     *
     * @param ids    代理商产品id
     * @param status 代理商产品状态
     * @return
     */
    @GetMapping("/api/merchant/agent/goods/batchUpdateStatus")
    Response<String> batchUpdateStatusAgentGoods(@RequestParam("ids") List<Integer> ids,
                                                 @RequestParam("status") String status);


    /**
     * 分页查询代理商产品
     *
     * @param code                代理商产品编号
     * @param name                代理商产品名称
     * @param status              代理商产品状态
     * @param agentCode           代理商编号
     * @param merchantGoodsName   平台产品名称
     * @param merchantGoodsCode   平台产品编号
     * @param merchantGoodsStatus 平台产品状态
     * @param goodsClassification 产品分类
     * @param goodsType           产品类型
     * @param limit               页大小
     * @param page                当前页
     * @return
     */
    @GetMapping("/api/merchant/agent/goods/page")
    PageTable<MerchantAgentGoodsListResp> pageAgentGoods(@RequestParam(value = "code", required = false) String code,
                                                         @RequestParam(value = "name", required = false) String name,
                                                         @RequestParam(value = "status", required = false) String status,
                                                         @RequestParam(value = "agentCode", required = false) String agentCode,
                                                         @RequestParam(value = "merchantGoodsName", required = false) String merchantGoodsName,
                                                         @RequestParam(value = "merchantGoodsCode", required = false) String merchantGoodsCode,
                                                         @RequestParam(value = "merchantGoodsStatus", required = false) String merchantGoodsStatus,
                                                         @RequestParam(value = "goodsClassification", required = false) String goodsClassification,
                                                         @RequestParam(value = "filterGoodsCodes", required = false) String filterGoodsCodes,
                                                         @RequestParam(value = "goodsType", required = false) String goodsType,
                                                         @RequestParam(value = "purchaseWay", required = false) String purchaseWay,
                                                         @RequestParam(value = "productTypeCode", required = false) String productTypeCode,
                                                         @RequestParam(value = "deductionTime", required = false) String deductionTime,
                                                         @RequestParam(value = "whetherNeedStock", required = false) String whetherNeedStock,
                                                         @RequestParam(value = "limit", defaultValue = "10") int limit,
                                                         @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 代理商产品弹窗-
     *
     * @param code
     * @param name
     * @param status
     * @param agentCode
     * @param merchantGoodsName
     * @param merchantGoodsCode
     * @param merchantGoodsStatus
     * @param goodsClassification
     * @param filterGoodsCodes
     * @param goodsType
     * @param purchaseWay
     * @param productTypeCode
     * @param agentList           代理商数据权限
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/agent/goods/pageForPopup")
    PageTable<MerchantAgentGoodsListResp> pageForPopup(@RequestParam(value = "code", required = false) String code,
                                                       @RequestParam(value = "name", required = false) String name,
                                                       @RequestParam(value = "status", required = false) String status,
                                                       @RequestParam(value = "agentCode", required = false) String agentCode,
                                                       @RequestParam(value = "merchantGoodsName", required = false) String merchantGoodsName,
                                                       @RequestParam(value = "merchantGoodsCode", required = false) String merchantGoodsCode,
                                                       @RequestParam(value = "merchantGoodsStatus", required = false) String merchantGoodsStatus,
                                                       @RequestParam(value = "goodsClassification", required = false) String goodsClassification,
                                                       @RequestParam(value = "filterGoodsCodes", required = false) String filterGoodsCodes,
                                                       @RequestParam(value = "goodsType", required = false) String goodsType,
                                                       @RequestParam(value = "purchaseWay", required = false) String purchaseWay,
                                                       @RequestParam(value = "productTypeCode", required = false) String productTypeCode,
                                                       @RequestParam(value = "agentList", required = false) List<String> agentList,
                                                       @RequestParam(value = "deductionTime", required = false) String deductionTime,
                                                       @RequestParam(value = "limit", defaultValue = "10") int limit,
                                                       @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 分页查询 B端代理商 搜索合作客户产品
     *
     * @param customerCode 合作客户产品编号
     * @param goodsType    产品类型
     * @param status       产品状态
     * @param limit        页大小
     * @param page         当前页
     * @return
     */
    @GetMapping("/api/merchant/agent/goods/bAgentSearch")
    PageTable<MerchantAgentGoodsListResp> bAgentSearchAgentGoods(@SpringQueryMap BAgentSearchGoodsReq searchReq);


    @GetMapping("/api/merchant/agent/goods/unpaged")
    Response<List<MerchantAgentGoodsListResp>> unpagedAgentGoods(@RequestParam(value = "code", required = false) String code,
                                                                 @RequestParam(value = "name", required = false) String name,
                                                                 @RequestParam(value = "status", required = false) String status,
                                                                 @RequestParam(value = "agentCode", required = false) String agentCode,
                                                                 @RequestParam(value = "merchantGoodsName", required = false) String merchantGoodsName,
                                                                 @RequestParam(value = "merchantGoodsCode", required = false) String merchantGoodsCode,
                                                                 @RequestParam(value = "merchantGoodsStatus", required = false) String merchantGoodsStatus,
                                                                 @RequestParam(value = "goodsClassification", required = false) String goodsClassification,
                                                                 @RequestParam(value = "goodsType", required = false) String goodsType,
                                                                 @RequestParam(value = "purchaseWay", required = false) String purchaseWay,
                                                                 @RequestParam(value = "productTypeCode", required = false) String productTypeCode,
                                                                 @RequestParam(value = "deductionTime", required = false) String deductionTime,
                                                                 @RequestParam(value = "codeList", required = false) List<String> codeList);


    /**
     * 删除商品
     *
     * @param id id
     * @return
     */
    @GetMapping("/api/merchant/agent/goods/delete/{id}")
    Response<String> deleteAgentGoods(@PathVariable("id") Integer id);


    @GetMapping("/api/merchant/agent/goods/detail/{id}")
    Response<MerchantAgentGoodsListResp> detailAgentGoods(@PathVariable("id") Integer id);


    @GetMapping("/api/merchant/agent/goods/detailIncludeMerchantGoods/{code}")
    Response<MerchantAgentGoodsDetailExtResp> detailIncludeMerchantGoods(@PathVariable("code") String code);


    /**
     * 根据代理商编号查下代理商产品基本信息
     *
     * @param agentCode 代理商产品编号
     * @param status    代理商产品状态
     * @return
     */
    @GetMapping("/api/merchant/agent/goods/allByAgentCode")
    Response<List<MerchantAgentGoodsListResp>> getAllAgentGoodsByAgentCode(@RequestParam("agentCode") String agentCode, @RequestParam(value = "status", required = false) String status);

    /**
     * 根据代理商产品编号 查下代理商产品基本信息
     *
     * @param agentGoodCodeList 代理商产品编号列表
     */
    @GetMapping("/api/merchant/agent/goods/findByAgentGoodCodes")
    Response<List<MerchantAgentGoodsListResp>> findAgentGoodListByAgentGoodCodes(@RequestParam("agentGoodCodeList") List<String> agentGoodCodeList);

    /**
     * 根据代理商产品编号 查下代理商产品基本信息
     *
     * @param agentGoodCodeList 代理商产品编号列表
     */
    @GetMapping("/api/merchant/agent/goods/pageBase")
    PageTable<BaseGoodsResp> pageBaseAgentGoods(@SpringQueryMap BaseGoodsReq req);

    /********************************************* djt 代理商产品  end******************************************************/


    /********************************************* djt 合作客户产品  start******************************************************/


    /**
     * 新增或者修改合作客户产品产品
     *
     * @param saveReq
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/saveOrUpdate")
    Response<String> saveOrUpdateCustomerGoods(@RequestBody MerchantCustomerGoodsSaveReq saveReq);


    /**
     * 批量添加商品
     *
     * @param batchSaveReq
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/batch/save")
    Response<String> batchSaveCustomerGoods(@RequestBody MerchantCustomerGoodsBatchSaveReq batchSaveReq);


    /**
     * 更新合作客户产品状态
     *
     * @param id     产品id
     * @param status 产品状态
     * @return
     */
    @GetMapping("/api/merchant/customer/goods/updateStatus")
    Response<String> updateStatusCustomerGoods(@RequestParam("id") int id,
                                               @RequestParam("status") String status);


    /**
     * 批量更新合作客户产品状态
     *
     * @param ids    产品id
     * @param status 代理商产品状态
     * @return
     */
    @GetMapping("/api/merchant/customer/goods/batchUpdateStatus")
    Response<String> batchUpdateStatusCustomerGoods(@RequestParam("ids") List<Integer> ids,
                                                    @RequestParam("status") String status);


    /**
     * 分页查询合作客户产品
     *
     * @param code                合作客户产品编号
     * @param name                代合作客户产品名称
     * @param status              合作客户产品状态
     * @param agentCode           代理商编号
     * @param merchantGoodsName   平台产品名称
     * @param merchantGoodsCode   平台产品编号
     * @param agentGoodsStatus    代理商产品状态
     * @param goodsClassification 产品分类
     * @param goodsType           产品类型
     * @param limit               页大小
     * @param page                当前页
     * @return
     */
    @GetMapping("/api/merchant/customer/goods/page")
    PageTable<MerchantCustomerGoodsListResp> pageCustomerGoods(@RequestParam(value = "code", required = false) String code,
                                                               @RequestParam(value = "name", required = false) String name,
                                                               @RequestParam(value = "status", required = false) String status,
                                                               @RequestParam(value = "agentCode", required = false) String agentCode,
                                                               @RequestParam(value = "agentGoodsName", required = false) String agentGoodsName,
                                                               @RequestParam(value = "agentGoodsCode", required = false) String agentGoodsCode,
                                                               @RequestParam(value = "merchantGoodsName", required = false) String merchantGoodsName,
                                                               @RequestParam(value = "merchantGoodsCode", required = false) String merchantGoodsCode,
                                                               @RequestParam(value = "agentGoodsStatus", required = false) String agentGoodsStatus,
                                                               @RequestParam(value = "merchantGoodStatus", required = false) String merchantGoodStatus,
                                                               @RequestParam(value = "goodsClassification", required = false) String goodsClassification,
                                                               @RequestParam(value = "goodsType", required = false) String goodsType,
                                                               @RequestParam(value = "purchaseWay", required = false) String purchaseWay,
                                                               @RequestParam(value = "goodCategory", required = false) String goodCategory,
                                                               @RequestParam(value = "customerCode", required = false) String customerCode,
                                                               @RequestParam(value = "whetherNeedStock", required = false) String whetherNeedStock,
                                                               @RequestParam(value = "excludeCodes", required = false) List<String> excludeCodes,
                                                               @RequestParam(value = "limit", defaultValue = "10") int limit,
                                                               @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 分页查询 B端代理商 搜索合作客户产品
     *
     * @param customerCode 合作客户产品编号
     * @param goodsType    产品类型
     * @param status       产品状态
     * @param limit        页大小
     * @param page         当前页
     * @return
     */
    @GetMapping("/api/merchant/customer/goods/bAgentSearch")
    PageTable<MerchantCustomerGoodsListResp> bAgentSearchCustomerGoods(@SpringQueryMap BAgentSearchGoodsReq searchReq);


    @GetMapping("/api/merchant/customer/goods/unpaged")
    Response<List<MerchantCustomerGoodsListResp>> unpagedCustomerGoods(@RequestParam(value = "code", required = false) String code,
                                                                       @RequestParam(value = "name", required = false) String name,
                                                                       @RequestParam(value = "status", required = false) String status,
                                                                       @RequestParam(value = "agentCode", required = false) String agentCode,
                                                                       @RequestParam(value = "agentGoodsName", required = false) String agentGoodsName,
                                                                       @RequestParam(value = "agentGoodsCode", required = false) String agentGoodsCode,
                                                                       @RequestParam(value = "merchantGoodsName", required = false) String merchantGoodsName,
                                                                       @RequestParam(value = "merchantGoodsCode", required = false) String agent,
                                                                       @RequestParam(value = "agentGoodsStatus", required = false) String agentGoodsStatus,
                                                                       @RequestParam(value = "merchantGoodStatus", required = false) String merchantGoodStatus,
                                                                       @RequestParam(value = "goodsClassification", required = false) String goodsClassification,
                                                                       @RequestParam(value = "goodsType", required = false) String goodsType,
                                                                       @RequestParam(value = "purchaseWay", required = false) String purchaseWay,
                                                                       @RequestParam(value = "goodCategory", required = false) String goodCategory,
                                                                       @RequestParam(value = "customerCode", required = false) String customerCode
    );


    /**
     * 删除商品
     *
     * @param id id
     * @return
     */
    @GetMapping("/api/merchant/customer/goods/delete/{id}")
    Response<String> deleteCustomerGoods(@PathVariable("id") Integer id);


    @GetMapping("/api/merchant/customer/goods/detail/{id}")
    Response<MerchantCustomerGoodsListResp> detailCustomerGoods(@PathVariable("id") Integer id);


    @GetMapping("/api/merchant/customer/goods/detailIncludeAgentGoods/{id}")
    Response<MerchantCustomerGoodsDetailExtResp> detailCustomerGoodsIncludeAgentGoods(@PathVariable("id") Integer id);

    /**
     * 查询合作客户产品
     *
     * @param searchReq
     * @return
     */
    @GetMapping("/api/merchant/customer/goods/admin/page")
    PageTable<MerchantCustomerGoodsListResp> searchCustomerGoods(@SpringQueryMap MerchantCustomerGoodsSearchReq searchReq);


    /**
     * 根据合作客户编号查找合作客户产品
     *
     * @param customerCode 合作客户编号
     * @param status       合作客户产品状态
     * @return 合作客户产品列表
     */
    @GetMapping("/api/merchant/customer/goods/allByCustomerCode")
    Response<List<MerchantCustomerGoodsListResp>> getAllProductByCustomerCode(@RequestParam("customerCode") String customerCode, @RequestParam(value = "status", required = false) String status);

    /**
     * 根据合作客户产品编号 查找合作客户产品
     *
     * @param customerGoodCodeList 合作客户产品编号列表
     */
    @GetMapping("/api/merchant/customer/goods/findByCustomerGoodCodes")
    Response<List<MerchantCustomerGoodsListResp>> findCustomerGoodListByCustomerGoodCodes(@RequestParam("customerGoodCodeList") List<String> customerGoodCodeList);


    @GetMapping("/api/merchant/customer/goods/pageBase")
    PageTable<BaseGoodsResp> pageBaseCustomerGoods(@SpringQueryMap BaseGoodsReq baseGoodsReq);

    /********************************************* djt 合作客户产品  end******************************************************/

    /*********************************************  luoyc 档位管理 start ****************************************************************/
    @GetMapping("/api/merchant/gears/listValid")
    Response<List<MerchantComboGears>> listValid();

    @GetMapping("/api/merchant/gears/listCodes")
    Response<List<String>> listCodes();

    @PostMapping("/api/merchant/gears/queryPage")
    PageTable<MerchantComboGears> pageTable(@RequestBody MerchantComboGears merchantComboGears);

    @PostMapping("/api/merchant/gears/saveOrUpdate")
    Response saveOrUpdate(@RequestBody MerchantComboGears merchantComboGears);

    @GetMapping("/api/merchant/gears/gainGears/{code}")
    Response<MerchantComboGears> gainGears(@PathVariable(value = "code") String code);

    @GetMapping("/api/merchant/merchantCombo/queryPageByGearsCode")
    PageTable<MerchantCombo> queryPageByGearsCode(@RequestParam(value = "code") String code,
                                                  @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                                  @RequestParam(value = "page", defaultValue = "1") Integer page);

    @GetMapping("/api/merchant/gears/listComboByGears")
    PageTable<MerchantComboGearsDTO> listComboByGears(@RequestParam("cost") BigDecimal cost,
                                                      @RequestParam("storeCode") String storeCode,
                                                      @RequestParam("coefficient") BigDecimal coefficient,
                                                      @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                                      @RequestParam(value = "page", defaultValue = "1") Integer page);
    /*********************************************  luoyc 档位管理 end ****************************************************************/


    /*********************************************  yifenrui 套餐管理 start ****************************************************************/

    @GetMapping("/api/merchant/merchantCombo/merchantComboQueryPage")
    PageTable<MerchantCombo> merchantComboQueryPage(@RequestParam(value = "code", required = false) String code,
                                                    @RequestParam(value = "name", required = false) String name,
                                                    @RequestParam(value = "relateCode", required = false) String relateCode,
                                                    @RequestParam(value = "type", required = false) String type,
                                                    @RequestParam(value = "status", required = false) String status,
                                                    @RequestParam(value = "priceSort", required = false) String priceSort,
                                                    @RequestParam(value = "sorts", required = false) String sorts,
                                                    @RequestParam(value = "source", required = false) String source,
                                                    @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                                    @RequestParam(value = "page", defaultValue = "1") Integer page);


    @PostMapping("/api/merchant/merchantCombo/statusOrSort")
    Response switchMerchantComboStatusOrSort(@RequestBody MerchantCombo merchantCombo);

    /**
     * 更新套餐状态
     *
     * @param merchantCombo {code, relateCode, status, updateUser}
     * @return
     */
    @PostMapping("api/merchant/merchantCombo/operateStatus")
    Response switchMerchantComboStatus(@RequestBody MerchantCombo merchantCombo);

    /**
     * 新增和更新
     *
     * @param merchantCombo
     * @return
     */
    @PostMapping("/api/merchant/merchantCombo/createOrUpdateMerchantCombo")
    Response createOrUpdateMerchantCombo(@RequestBody MerchantCombo merchantCombo);


    @GetMapping("/api/merchant/merchantCombo/getMerchantComboByCode")
    Response<MerchantCombo> getMerchantComboByCode(@RequestParam(value = "code") String code);


    @GetMapping("/api/merchant/merchantCombo/queryListMerchantCombo")
    PageTable<MerchantCombo> queryListMerchantCombo(@RequestParam(value = "status", required = false) String status, @RequestParam("type") String type,
                                                    @RequestParam("storeCode") String storeCode,
                                                    @RequestParam(value = "source", required = false) String source,
                                                    @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                                    @RequestParam(value = "page", defaultValue = "1") Integer page);


    @GetMapping("/api/merchant/merchantCombo/queryListMerchantComboDetail")
    PageTable<MerchantComboDetail> queryListMerchantComboDetail(@RequestParam("comboCode") String comboCode,
                                                                @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                                                @RequestParam(value = "page", defaultValue = "1") Integer page);


    @GetMapping("/api/merchant/merchantCombo/merchantMerchantComboLogPageTable")
    PageTable<MerchantComboLog> merchantMerchantComboLogPageTable(@RequestParam("code") String code,
                                                                  @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                  @RequestParam(defaultValue = "1", name = "page") int page);


    @GetMapping("/api/merchant/merchantCombo/exportMerchantCombo")
    Response<List<MerchantCombo>> exportMerchantCombo(@RequestParam(value = "code", required = false) String code,
                                                      @RequestParam(value = "name", required = false) String name,
                                                      @RequestParam(value = "relateCode", required = false) String relateCode,
                                                      @RequestParam(value = "type", required = false) String type,
                                                      @RequestParam(value = "status", required = false) String status,
                                                      @RequestParam(value = "source", required = false) String source);


    @GetMapping("/api/merchant/merchantCombo/getMerchantComboByRelateCodeAndName")
    Response<MerchantCombo> getMerchantComboByRelateCodeAndName(@RequestParam(value = "code", required = false) String code, @RequestParam(value = "relateCode") String relateCode, @RequestParam(value = "name") String name);
    /*********************************************  yifenrui 套餐管理 end ****************************************************************/


    /*********************************************  liangyongtong 油站管理 end ****************************************************************/
    /**
     * 更新保存商户
     *
     * @param store
     * @return
     */
    @PostMapping("/api/merchant/store/oil")
    Response<String> saveMerchantStoreOil(@RequestBody MerchantStore store);

    /**
     * 油站详情
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/store/oil/detail")
    Response<MerchantStore> getOilDetail(@RequestBody ReqStore req);

    /**
     * 油站基本信息：包括油类型列表
     */
    @GetMapping("/api/merchant/store/oil/getOilBasicInfo")
    Response<MerchantStore> getOilBasicInfo(@RequestParam("storeCode") String storeCode);

    /**
     * 分页查询油站
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/store/oil/pagetable")
    PageTable<MerchantStore> merchantStoreOilPageTable(@RequestBody ReqStore req);

    /**
     * 油站列表
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/store/oil/oilList")
    Response<List<MerchantStore>> merchantStoreOilList(@RequestBody ReqStore req);

    /**
     * 更新用户状态
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/store/oil/updateStatus")
    Response updateOilStatus(@RequestBody ReqStore req);

    /**
     * 分页搜索平安到站加油 油站列表（平安好车主）
     */
    @GetMapping("/api/merchant/store/oil/searchOilCStation")
    PageTable<MerchantStore> searchOilCStationPage(@RequestParam(defaultValue = "20", value = "limit") int limit,
                                                   @RequestParam(defaultValue = "1", value = "page") int page);

    /**
     * 查询推送给平安的 全部油站列表（平安好车主）
     *
     * @param statusRange：                 UP_LIST：推送上架的（默认）; DOWN_LIST：推送下架的;  UP_DOWN: 推送 上架 + 下架 的油站
     * @param oilBrand:查询指定品牌的油站,如果不指定，则查询 ZGSY（中石油）和 ZYBP（中油BP）
     */
    @GetMapping("/api/merchant/store/oil/findOilCStationList")
    Response<List<MerchantStore>> findOilCStationList(@RequestParam(value = "statusRange", required = false, defaultValue = Constant.DictData.MERCHANT_STORE_STATUS_UP_LIST) String statusRange,
                                                      @RequestParam(value = "oilBrand", required = false) String oilBrand);

    /*********************************************  liangyongtong 油站管理 end ****************************************************************/

    /*********************************************  ranxiangfu 产品类型 start ****************************************************************/

    /**
     * Gets product type tree.
     *
     * @param checkedCode   选中的书节点Code
     * @param disabledCode  禁用的书节点Code
     * @param disabledChild 是否禁用子节点
     * @return the product type tree
     */
    @GetMapping("/api/merchant/merchant-product-type/getTree")
    Response<List<TreeDto<MerchantProductType>>> getProductTypeTree(@RequestParam(value = "checkedCode", required = false) String checkedCode,
                                                                    @RequestParam(value = "disabledCode", required = false) String disabledCode,
                                                                    @RequestParam(value = "disabledChild", required = false) Boolean disabledChild);

    /**
     * List child product type by code response.
     *
     * @param code the code
     * @return the response
     */
    @GetMapping("/api/merchant/merchant-product-type/child")
    Response<List<MerchantProductType>> listChildProductTypeByCode(@RequestParam("code") String code);

    /**
     * Gets product type by id.
     *
     * @param id the id
     * @return the product type by id
     */
    @GetMapping("/api/merchant/merchant-product-type/{id}")
    Response<MerchantProductType> getProductTypeById(@PathVariable("id") Integer id);

    /**
     * Gets product type by code.
     *
     * @param code the code
     * @return the product type by code
     */
    @GetMapping("/api/merchant/merchant-product-type/getByCode")
    Response<MerchantProductType> getProductTypeByCode(@RequestParam("code") String code);

    /**
     * Gets product type by code.
     *
     * @param codeList the code list
     * @return the product type by code
     */
    @GetMapping("/api/merchant/merchant-product-type/listByCodeList")
    Response<List<MerchantProductType>> getProductTypeByCodeList(@RequestParam("codeList") List<String> codeList);

    /**
     * Save or update product type response.
     *
     * @param productType the product type
     * @return the response
     */
    @PostMapping("/api/merchant/merchant-product-type/saveOrUpdate")
    Response saveOrUpdateProductType(@RequestBody MerchantProductType productType);

    /**
     * Delete product type by code response.
     *
     * @param code the code
     * @return the response
     */
    @DeleteMapping("/api/merchant/merchant-product-type/deleteByCode")
    Response deleteProductTypeByCode(@RequestParam("code") String code);

    /*********************************************  ranxiangfu 产品类型 end ****************************************************************/

    /*********************************************  供应链发放订单相关 start ****************************************************************/

    /**
     * 更新鼎聚套餐订单信息.
     * <p>
     * 1.更新主订单表的发放成功张数，+1就行
     * 2.保存第三方券编号到套餐明细表
     *
     * @param dingJuPackageOrderUpdateDto dto
     * @return Response
     */
    @PostMapping("/api/merchant/scm/order/information/updateScmDingJuPackageOrder")
    Response updateScmDingJuPackageOrder(@RequestBody ScmDingJuPackageOrderUpdateDto dingJuPackageOrderUpdateDto);

    /**
     * 更新单品订单信息
     *
     * @param updateDTO
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/updateScmSingleOrderDetail")
    Response updateScmSingleOrder(@RequestBody ScmOrderDetailUpdateDTO updateDTO);

    /**
     * 更新鼎聚单条的代驾券订单
     *
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/updateScmDingJuDrivingOrder")
    Response updateScmDingJuDrivingOrder(@RequestBody @Validated ScmDingJuDrivingOrderUpdateParamDto dto);

    /*
     * 通过orderItemCode 仅返回MerchantScmOrderDetail信息
     * @param req {orderItemCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/getMerchantScmOrderDetail")
    Response<MerchantScmOrderDetail> getMerchantScmOrderDetail(@RequestBody ReqScm req);

    /**
     * 通过用户券编号号获取 仅返回MerchantScmOrderDetail，如果传入了mobile,则更新发放用户的realMobile=传入的mobile
     *
     * @param req {userCouponCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/getMerchantScmOrderDetailByUserCouponCode")
    Response<MerchantScmOrderDetail> getMerchantScmOrderDetailByUserCouponCode(@RequestBody ReqScm req);

    /**
     * 通过orderItemCode获取上游订单 返回包括：发放信息scmGrantInfo，下游订单信息orderInformation,发放用户信息scmGrantTargetUser;  并更新对应的真实手机号、已领取状态、 领取验证时间
     *
     * @param req {orderItemCode, mobile}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/getMerchantScmOrderDetailByOrderItemCode")
    Response<MerchantScmOrderDetail> getMerchantScmOrderDetailByOrderItemCode(@RequestBody ReqScm req);

    /**
     * 获取上游订单，包括：发放信息，下游订单，发放产品信息
     */
    @GetMapping("/api/merchant/scm/order/information/getScmOrderItemWithAllByOrderItemCode")
    Response<MerchantScmOrderDetail> getScmOrderItemWithAllByOrderItemCode(@RequestParam("orderItemCode") String orderItemCode);


    /**
     * 根据用户券号获取第三方业务编号
     *
     * @param req {userCouponCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/getThirdBusinessCodeByUserCouponCode")
    Response<String> getThirdBusinessCodeByUserCouponCode(@RequestBody ReqScm req);

    /**
     * 获取主订单基础信息（单表查询）
     *
     * @param req {orderCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/getBaseOrderInformmationByOrderCode")
    Response<MerchantScmOrderInformation> getBaseOrderInformmationByOrderCode(@RequestBody ReqScm req);

    /**
     * 通过下游订单编号 获取下游订单信息Map(包括 MerchantScmOrderDetail)
     * @param orderCodeList 下游订单编号列表
     */
    @PostMapping("/api/merchant/scm/order/information/findByOrderCodesIn")
    Response<Map<String, MerchantScmOrderInformation>> findScmOrderMapByOrderCodesIn(@RequestBody List<String> orderCodeList);

    /**
     * 更新主订单中额度领取结果
     *
     * @param req {orderCode, receiveQuotaStatus}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/updateRecevieQuotaStatus")
    Response<Boolean> updateRecevieQuotaStatus(@RequestBody ReqScm req);

    /*
     * 根据用户券编号获取明细订单
     * @param 用户券编号
     * @return
     */
    @GetMapping("/api/merchant/scm/order/information/getOrderDetailByUserCouponNo")
    Response<MerchantScmOrderDetail> getOrderDetailByUserCouponNo(@RequestParam("userCouponNo") String userCouponNo);

    /**
     * 上游订单查询接口.
     *
     * @param queryDto 查询参数Dto
     * @return
     */
    @PostMapping("/api/merchant/scm/order/detail/upOrderPageQuery")
    PageTable<UpOrderQueryResultDto> upOrderPageQuery(@RequestBody UpOrderQueryDto queryDto);

    /**
     * 上游订单详情查询接口.
     *
     * @param itemOrderCode 明细订单编号
     * @return
     */
    @GetMapping("/api/merchant/scm/order/detail/upOrderDetailWithComboList")
    Response<UpOrderDetailWithComboListDto> upOrderDetailWithComboList(@RequestParam("itemOrderCode") String itemOrderCode);

    /**
     * 返回明细订单对应的备付金支付金额
     *
     * @param req {orderItemCodes}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/detail/getOrderItemPayPriceByCodes")
    Response<Map<String, ScmEquityValidateDto>> getOrderItemPayPriceByCodes(@RequestBody ReqOrder req);


    /**
     * 更新明细订单中额度领取结果
     *
     * @param req {orderItemCode, receiveQuotaStatus}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/detail/updateCoverRecevieStatus")
    Response<Boolean> updateCoverRecevieStatus(@RequestBody ReqScm req);

    /**
     * 备付金账户订单分页列表
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/order/detail/scmCoverAccountOrderDtoPageTable")
    PageTable<ScmCoverAccountOrderDto> scmCoverAccountOrderDtoPageTable(@RequestBody ReqOrder req);

    /**
     * 下游订单服务商备付金交易流水
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/scmAgentTradePageTable")
    PageTable<ScmCoverAccountOrderDto> scmAgentTradePageTable(@RequestBody ReqOrder req);


    /**
     * 下游订单合作客户备付金交易流水
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/scmCustomerTradePageTable")
    PageTable<ScmCoverAccountOrderDto> scmCustomerTradePageTable(@RequestBody ReqOrder req);

    /**
     * 后台管理查询下游订单交易记录
     *
     * @param req
     * @return
     */
    @GetMapping("/api/merchant/scm/order/information/adminScmTradeLogPage")
    PageTable<AdminDownOrderPayLogResp> adminScmDownOrderPayLog(@SpringQueryMap AdminDownOrderPayLogReq req);

    /**
     * 根据上游订单编号查询询下游订单
     *
     * @param orderItemCode 上游订单编号
     * @return
     */
    @GetMapping("/api/merchant/scm/order/information/getByOrderItemCode")
    Response<MerchantScmOrderInformation> getDownOrderByOrderItemCode(@RequestParam("orderItemCode") String orderItemCode);

    /**
     * 根据orderItemCode更新壳牌油站信息
     *
     * @param shellOilDto
     */
    @PostMapping("/api/merchant/scm/order/information/updateShellOilStation")
    Response<UpdateShellOilStationResultDto> updateShellOilStation(@RequestBody UpdateShellOilStationInfoDto shellOilDto);


    /**
     * 备付金账户订单列表
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/order/detail/scmCoverAccountOrderDtoList")
    List<ScmCoverAccountOrderDto> scmCoverAccountOrderDto(@RequestBody ReqOrder req);

    /**
     * 获取上游订单单表信息
     *
     * @param req {orderItemCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/detail/getBaseOrderDetailByOrderItemCode")
    Response<MerchantScmOrderDetail> getBaseOrderDetailByOrderItemCode(@RequestBody ReqOrderRefund req);

    /**
     * 根据上游订单明细编号更新上游订单
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/order/detail/updateOrderDetailByItemCode")
    Response updateOrderDetailByItemCode(@RequestBody MerchantScmOrderDetail req);

    /**
     * 触发延时调用上游的上游订单进行发放
     *
     * @return
     */
    @PostMapping("/api/merchant/scm/order/detail/triggerDelayOrderIssue")
    Response triggerDelayOrderIssue();

    /**
     * 获取上游订单明细包括发放信息 MerchantScmInformation
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/order/detail/getOrderDetailWithGrantInfo")
    Response<MerchantScmOrderDetail> getOrderDetailWithGrantInfo(@RequestParam("orderItemCode") String orderItemCode);

    /**
     * 根据业务单号查询上游明细订单
     *
     * @param businessCode
     * @return
     */
    @GetMapping("/api/merchant/scm/order/detail/getByBusinessCode")
    Response<List<MerchantScmOrderDetail>> getUpOrderListByBusinessCode(@RequestParam("businessCode") String businessCode);



    /**
     * 通过多个上游订单号 获取上游订单 基本信息
     */
    @PostMapping("/api/merchant/scm/order/detail/findScmOrderDetailListByItemCodesIn")
    Response<List<MerchantScmOrderDetail>> findScmOrderDetailListByOrderItemCodesIn(@RequestBody List<String> orderItemCodes);


    /**
     *  通过清单业务单号 获取上游订单，包含MerchantScmInformation
     * @param businessCodeList
     * @return Map<businessCode, List<MerchantScmOrderDetail>>
     */
    @PostMapping("/api/merchant/scm/order/detail/findByBusinessCodesIn")
    Response<Map<String, List<MerchantScmOrderDetail>>> findUpOrderListMapByBusinessCodesIn(@RequestBody List<String> businessCodeList);

    /**
     * 通过下游订单编号 获取上游订单基本信息Map
     *
     * @param orderCodeList 下游订单编号列表
     */
    @PostMapping("/api/merchant/scm/order/detail/findByOrderCodesIn")
    Response<Map<String, List<MerchantScmOrderDetail>>> findUpOrderMapByOrderCodesIn(@RequestBody List<String> orderCodeList);


    /**
     * 调用上游 发放滴滴的用户券
     */
    @PostMapping("/api/merchant/scm/order/detail/grantDidiCoupon")
    Response triggerUpStreamGrantDidiCoupon(@RequestBody GrantDidiUpStreamCouponDto grantDidiCouponDto);

    /**
     * 根据上游订单明细编号 开始处理
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/order/detail/startProcessOrderDetailByItemCode")
    Response<MerchantChannelProduct> startProcessOrderDetailByItemCode(@RequestParam("orderItemCode") String orderItemCode);

    /**
     * 根据供应链上游订单编号 获取 通道产品扣款主体参数信息
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/order/detail/getChannelProductDeductSubjectParam")
    Response<DeductSubjectParamRespDto> getChannelProductDeductSubjectParam(@RequestParam("orderItemCode") String orderItemCode);

    /**
     * 更新上游订单过期余额
     *
     * @return
     */
    @PostMapping("/api/merchant/scm/order/detail/updateExpireAmount")
    Response updateScmOrderDetailExpireAmount(@RequestParam("expireAmount") BigDecimal expireAmount,
                                              @RequestParam("orderItemCode") String orderItemCode);

    /**
     * 更新上游订单过期处理状态
     *
     * @param expiredHandleStatus
     * @param orderItemCodeList
     */
    @GetMapping("/api/merchant/scm/order/detail/updateExpireHandleStatus")
    Response updateScmOrderDetailExpireHandleStatus(@RequestParam("expiredHandleStatus") String expiredHandleStatus,
                                                    @RequestParam("orderItemCodeList") List<String> orderItemCodeList);



    /**
     * 更新上游订单的 使用状态（电卡产品更新使用状态）
     */
    @PostMapping("/api/merchant/scm/order/detail/updateUseStatus")
    Response updateScmOrderDetailUseStatus(@RequestBody UpdateUseStatusDto updateDto);


    /**
     * 更新上游订单为已补发
     *
     * @param orderItemCode    需要补发的上游订单号
     * @param reissuedAmount   补发金额
     * @param reissuedOrdeCode 创建的补发订单号
     */
    @GetMapping("/api/merchant/scm/order/detail/updateRessued")
    Response updateScmOrderDetailRessued(@RequestParam("orderItemCode") String orderItemCode,
                                         @RequestParam("reissuedAmount") BigDecimal reissuedAmount,
                                         @RequestParam("reissuedOrdeCode") String reissuedOrdeCode);


    /*********************************************  供应链发放订单相关 end ****************************************************************/


    /*********************************************  供应链发放目标用户信息相关 end ****************************************************************/

    /**
     * 根据订单编号查询目标信息.
     *
     * @param orderCode 订单编号
     * @return 目标信息实体
     */
    @GetMapping("/api/merchant/scm/target/user/getByOrderCode")
    Response<MerchantScmTargetUser> getMerchantScmTargetUserByOrderCode(@RequestParam("orderCOde") String orderCode);

    /*********************************************  供应链发放目标用户信息相关 end ****************************************************************/


    /*********************************************  liangyongtong 发放订单 start ****************************************************************/
    /**
     * 供应链产品下单
     *
     * @param information
     * @return
     */
    @PostMapping("/api/merchant/scm/information/sendScmInfomation")
    Response sendScmInfomation(@RequestBody ScmSendDto information);
    /*********************************************  liangyongtong 发放订单 end ****************************************************************/

    /**
     * 用户券发放成功，更新用户券号到订单
     *
     * @param reqScm {orderItemCode, userCouponCode, isSuite}
     * @return
     */
    @PostMapping("/api/merchant/scm/information/updateUserCouponCodeToOrder")
    Response updateUserCouponCodeToOrder(@RequestBody ReqScm reqScm);


    /**
     * 定时任务： 调用roco车服 尝试发放用户券（对于发放失败的产品订单）
     */
    @GetMapping("/api/merchant/scm/information/scheduleRetryGrantUserCoupons")
    Response scheduleRetryGrantScmUserCoupons();

    @GetMapping("/api/merchant/scm/information/scheduleAdjustGrantedUserCoupon")
    Response scheduleAdjustGrantedUserCoupon();

    /**
     * 请求上游失败重试
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/information/reOrder")
    Response reOrder();

    /**
     * 更新发放信息里面的发放性质
     *
     * @param reqScm {applyNo, grantNature}
     * @return
     */
    @PostMapping("/api/merchant/scm/information/updateScmInfomationGrantNature")
    Response<ReportAdjustScmOrderMsgDto> updateScmInfomationGrantNature(@RequestBody ReqScm reqScm);


    /**
     * 申请单修改发放性质后,根据申请单号 手工查询需要矫正下游订单
     */
    @GetMapping("/api/merchant/scm/information/manualGetAdjustScmOrder")
    Response<ReportAdjustScmOrderMsgDto> manualGetPushReportAdjustScmOrders(@RequestParam("applyNo") String applyNo);

    /**
     * 更新订单支付结果
     *
     * @param account 支付结果
     * @return
     */
    @PostMapping("/api/merchant/scm/information/updateScmPay")
    Response updateScmPay(@RequestBody ReqScmAccount account);

    /**
     * 更新备付金支付结果
     *
     * @param account 支付结果
     * @return
     */
    @PostMapping("/api/merchant/scm/information/updateScmCoverPay")
    Response updateScmCoverPay(@RequestBody ReqScmAccount account);

    /**
     * 更新服务商备付金支付结果
     *
     * @param account 支付结果
     * @return
     */
    @PostMapping("/api/merchant/scm/information/updateScmAgentPay")
    Response updateScmAgentPay(@RequestBody ReqScmAccount account);

    /**
     * 更新下游订单合作客户备付金支付结果
     *
     * @param account 支付结果
     * @return
     */
    @PostMapping("/api/merchant/scm/information/updateScmCustomerPay")
    Response updateScmCustomerPay(@RequestBody ReqScmAccount account);

    /**
     * 获取下游订单数量
     *
     * @param req {createUser}
     * @return
     */
    @PostMapping("/api/merchant/scm/information/getOrderCount")
    Response<Integer> getOrderCount(@RequestBody ReqOrder req);

    /**
     * 通过订单编码或者业务编码获取发放基础信息 （单表查询）
     *
     * @param orderCode
     * @param businessCode
     * @return
     */
    @GetMapping("/api/merchant/scm/information/getBaseScmInformation")
    Response<MerchantScmInformation> getBaseScmInformation(@RequestParam(value = "orderCode", required = false) String orderCode,
                                                           @RequestParam(value = "businessCode", required = false) String businessCode);

    /**
     * 通过订单编码获取发放基础信息 （单表查询）
     *
     * @param orderCode
     * @return
     */
    @GetMapping("/api/merchant/scm/information/getScmInformationByOrderCode")
    Response<MerchantScmInformation> getScmInfoByOrderCode(@RequestParam(value = "orderCode") String orderCode);

    /**
     * 根据一批 明细订单编号 查询对应的清单编号列表
     *
     * @param orderItemCodes 明细订单编号列表
     * @return
     */
    @PostMapping("/api/merchant/scm/information/listBusinessCodesByScmOrderItemCodes")
    Response<List<String>> listBusinessCodesByScmOrderItemCodes(@RequestBody List<String> orderItemCodes);


    /**
     * 根据申请单号查询发放信息
     *
     * @param applyNo 申请单号
     */
    @GetMapping("/api/merchant/scm/information/findScmInformationListByApplyNo")
    Response<List<MerchantScmInformation>> findScmInformationListByApplyNo(@RequestParam(value = "applyNo") String applyNo);


    /**
     * 分销订单延期
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/information/dateDefer")
    Response scmOrderDateDefer(@RequestBody ScmDateDeferReq req);

    /**
     * 更新发放信息里面的发放性质
     *
     * @param businessCode 下单业务号
     * @param grantNature  发放性质
     * @return
     */
    @GetMapping("/api/merchant/scm/information/updateScmInfomationGrantNatureByBusinessCode")
    Response updateScmInfomationGrantNatureByBusinessCode(@RequestParam("businessCode") String businessCode, @RequestParam("grantNature") String grantNature);

    /**
     * 分销系统下游订单admin 列表
     *
     * @param searchParamDto the search param dto
     * @return page table
     */
    @PostMapping("/api/merchant/scm/order/information/scmDownOrderSearch")
    PageTable<ScmAdminDownOrderSearchResponseDto> scmDownOrderSearch(@RequestBody ScmAdminDownOrderSearchParamDto searchParamDto);

    /**
     * 分销系统下游订单详情
     *
     * @param orderCode 订单编号
     * @return
     */
    @GetMapping("/api/merchant/scm/order/information/getScmDownOrderDetailByOrderCode")
    Response<MerchantScmOrderInformation> getScmDownOrderDetailByOrderCode(@RequestParam("orderCode") String orderCode);

    /**
     * 更新明细订单、套餐明细订单对应的核销状态
     *
     * @param writeOffDto 更新条件
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/updateWriteOffStatus")
    Response<WriteOffResultDto> updateWriteOffStatus(@RequestBody WriteOffDto writeOffDto);


    /**
     * 更新 滴滴券 套餐明细中的用户券已核销,当使用有效过期后，查询滴滴券使用状态为已使用时更新
     * @param writeOffDto
     */
    @PostMapping("/api/merchant/scm/order/information/updateDidiWriteOffWhenExpired")
    Response updateDidiWriteOffStatusWhenExpired(@RequestBody ExpireDidiCouponResultDto writeOffDto);
    

    /*********** liangyongtong 电子账户历史订单数据处理 start **********/
    /**
     * 临时数据列表
     *
     * @param type 所有数据列表，为 pay；领取列表 为 recevie
     * @return
     */
    @GetMapping("/api/merchant/scm/orderintmp0417/list")
    Response<List<OrderInTmp0417>> orderInTmp0417List(@RequestParam(value = "type", required = false) String type);

    /**
     * 扣减
     *
     * @param account
     * @return
     */
    @PostMapping("/api/merchant/scm/orderintmp0417/pay")
    Response payResultHandle(@RequestBody ReqScmAccount account);

    /**
     * 领取
     *
     * @param account
     * @return
     */
    @PostMapping("/api/merchant/scm/orderintmp0417/recevie")
    Response recevieResultHandle(@RequestBody ReqScmAccount account);

    /*********** liangyongtong 电子账户历史订单数据处理 end **********/

    /*********** liangyongtong taskcontroller start **********/
    /**
     * 处理未跑完的更新第三方业务编码到权益中心
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/information/task/reUpdateThirdBusinessCodeToEquity")
    Response reUpdateThirdBusinessCodeToEquity();

    /**
     * @param equityDto
     * @return
     */
    @PostMapping("/api/merchant/scm/information/task/updateThirdBusinessCodeToEquity")
    Response updateThirdBusinessCodeToEquity(@RequestBody PowerNoToEquityDto equityDto);

    /**
     * 把明细订单编号对应的第三方业务编号刷新到消息中
     *
     * @param req {orderItemCode, isSuite}
     * @return
     */
    @Deprecated
    @PostMapping("/api/merchant/scm/information/task/updateThirdBusinessCodeToEquityByOrderItemCode")
    Response updateThirdBusinessCodeToEquityByOrderItemCode(@RequestBody ReqScm req);

    /**
     * 第三方业务编号更新到权益服务并且增加销量
     */
    @PostMapping("/api/merchant/scm/information/task/updateEquityThirdBusinessCodeAndIncreaseStockQuantity")
    Response updateEquityThirdBusinessCodeAndIncreaseStockQuantity(@RequestBody UpdateThirdBizCodeAndIncrSaleQtyDto req);

    /**
     * 支付失败订单尝试重复支付
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/information/task/orderRetryPay")
    Response orderRetryPay();

    /**
     * 备付金支付失败订单尝试重复支付
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/information/task/coverRetryPay")
    Response coverRetryPay();

    /**
     * 服务商备付金支付失败订单尝试重新支付
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/information/task/agentRetryPay")
    Response agentRetryPay();


    /**
     * 合作客户备付金支付失败订单尝试重新支付
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/information/task/customerRetryPay")
    Response customerRetryPay();


    /**
     * 定时执行：（1)到了生效日后 设置使用有效期状态为有效 (2) 领取有效期过了失效日后，设置领取有效期状态为 已过期
     */
    @GetMapping("/api/merchant/scm/information/task/scheduleUpdateValidityStatus")
    Response scheduleUpdateUpOrderValidityStatus();


    /**
     * 定时执行：上游订单 使用有效期过了失效日后，设置使用有效期状态为 已过期
     */
    @GetMapping("/api/merchant/scm/information/task/scheduleExpireUpOrders")
    Response<ScheduleUpdateValidityResultDto> scheduleExpireUseValidityOfUpOrders(@RequestParam(value = "fetchSize",defaultValue = "100") Integer fetchSize);


    /**
     * 定时执行：套餐明细订单 使用有效期过了失效日后，设置使用有效期状态为 已过期
     */
    @GetMapping("/api/merchant/scm/information/task/scheduleExpireComboOrderDetails")
    Response<ExpiredComboDetailOrderValidityResultDto> scheduleExpireUseValidityOfComboOrderDetails(@RequestParam(value = "fetchSize",defaultValue = "100") Integer fetchSize);


    /**
     * 定时执行：重试 "库存占用失败" 或 "增加库存销量失败" 的 供应链库存信息
     */
    @GetMapping("/api/merchant/scm/information/task/scheduleRetryFailedScmOrderStock")
    Response<List<Integer>> scheduleRetryFailedScmOrderStock(@RequestParam(value = "fetchSize", defaultValue = "100") Integer fetchSize, @RequestParam(value = "maxId", required = false) Integer maxId);


    /**
     * 定时 查找需要更新 使用状态的 油卡（包括直充，非直充），积分上游订单
     */
    @GetMapping("/api/merchant/scm/information/task/scheduleFindToUseOilCardOrderItemList")
    Response<List<MerchantScmOrderDetail>> scheduleFindToUseOilCardOrderItemList(@RequestParam(required = false, name = "maxUpOrderId") Integer maxUpOrderId,
                                                                                 @RequestParam(defaultValue = "50", name = "batchSize") Integer batchSize);


    /**
     * 根据余额 批量更新油卡上游订单的 使用状态
     *
     * @param oilCardBalanceResultList
     */
    @PostMapping("/api/merchant/scm/information/task/scheduleBatchUpdateOilCardUseStatus")
    Response scheduleBatchUpdateOilCardUseStatus(@RequestBody List<OutOrderQueryResult> oilCardBalanceResultList);


    /**
     * 定时查找需要更新 使用状态,余额的 油卡积分上游订单
     */
    @GetMapping("/api/merchant/scm/information/task/scheduleFetchOilCardOrderItemAmtList")
    Response<List<MerchantScmOrderDetailFetchAmount>> scheduleFetchOilCardOrderItemAmtList(@RequestParam(required = false, name = "maxUpOrderId") Integer maxUpOrderId,
                                                                                           @RequestParam(defaultValue = "100", name = "batchSize") Integer batchSize);


    /**
     * 根据余额 批量更新油卡上游订单的 使用状态，过期余额
     *
     * @param oilCardBalanceResultList
     */
    @PostMapping("//api/merchant/scm/information/task/scheduleBatchUpdateOilCardUseStatusAndBalance")
    Response scheduleBatchUpdateOilCardUseStatusAndBalance(@RequestBody List<OutOrderQueryResult> oilCardBalanceResultList);


    /**
     * 根据订单号查询平台产品
     *
     * @param orderCode 订单编号
     * @return
     */
    @GetMapping("/api/merchant/scm/product/information/getMerchantGoodsByOrderCode")
    Response<MerchantGoods> getMerchantGoodsByOrderCode(@RequestParam("orderCode") String orderCode);

    /**
     * 根据下游订单编号获取供应链产品信息
     */
    @GetMapping("/api/merchant/scm/product/information/getScmProductByOrderCode")
    Response<MerchantScmProductInformation> getScmProductInfoByOrderCode(@RequestParam("orderCode") String orderCode);


    /*********** liangyongtong taskcontroller end **********/

    /*********** yinshihao scmOrderLog start **********/
    /**
     * 保存订单日志
     *
     * @param scmOrderLog
     * @return
     */
    @PostMapping("/api/merchant/scm/order/log/saveScmOrderLog")
    Response saveScmOrderLog(@RequestBody MerchantScmOrderLog scmOrderLog);

    /**
     * 获取订单日志列表.
     *
     * @param orderCode 订单编号
     * @return
     */
    @GetMapping("/api/merchant/scm/order/log/getOrderLog")
    PageTable<MerchantScmOrderLog> getOrderLog(@RequestParam(value = "orderCode", required = false) String orderCode,
                                               @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                               @RequestParam(value = "page", defaultValue = "1") Integer page);
    /*********** yinshihao scmOrderLog end **********/

    /*********** yinshihao scmOrderRemoteLog start **********/
    /**
     * 保存订单日志
     *
     * @param scmOrderRemoteLog
     * @return
     */
    @PostMapping("/api/merchant/scm/order/remoteLog/saveScmOrderRemoteLog")
    Response saveScmOrderRemoteLog(@RequestBody MerchantScmOrderRemoteLog scmOrderRemoteLog);

    /**
     * 获取订单日志列表.
     *
     * @param orderCode 订单编号
     * @return
     */
    @GetMapping("/api/merchant/scm/order/remoteLog/getOrderRemoteLog")
    PageTable<MerchantScmOrderRemoteLog> getOrderRemoteLog(@RequestParam(value = "orderCode", required = false) String orderCode,
                                                           @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                                           @RequestParam(value = "page", defaultValue = "1") Integer page);

    /**
     * 获取下游订单日志列表.
     *
     * @param orderCode 订单编号
     * @return
     */
    @GetMapping("/api/merchant/scm/order/remoteLog/getDownOrderRemoteLog")
    PageTable<MerchantScmOrderRemoteLog> getDownOrderRemoteLog(@RequestParam(value = "orderCode", required = false) String orderCode,
                                                               @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                                               @RequestParam(value = "page", defaultValue = "1") Integer page);
    /*********** yinshihao scmOrderRemoteLog end **********/


    /**
     * 得到下游订单的总记录数
     *
     * @param searchParamDto 查询请求
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/getDownOrderTotalCount")
    Response<Integer> getDownOrderTotalCount(@RequestBody ScmAdminDownOrderSearchParamDto searchParamDto);

    /**
     * 下游订单退款
     *
     * @param req {orderCode, refundPrice}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/downOrderRefund")
    Response downOrderRefund(@RequestBody ReqOrderRefund req);

    /**
     * 更新下游订单服务商备付金退款信息
     *
     * @param req {orderCode, refundPrice}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/updateAgentRefundInfo")
    Response updateAgentRefundInfo(@RequestBody ReqOrderRefund req);

    /**
     * 更新下游订单合作客户备付金退款信息
     *
     * @param req {orderCode, refundPrice}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/updateCustomerRefundInfo")
    Response updateCustomerRefundInfo(@RequestBody ReqOrderRefund req);

    /**
     * 上游订单退款
     *
     * @param req {orderItemCode, refundPrice, tradeFlowCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/upOrderRefund")
    Response upOrderRefund(@RequestBody ReqOrderRefund req);

    /**
     * 获取退款信息
     *
     * @param req {orderCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/refundInfoByOrderCode")
    Response<ScmOrderPayDto> refundInfoByOrderCode(@RequestBody ReqOrderRefund req);


    /**
     * 通过下游订单号获取信息用来校验是否能撤回（撤回下游订单之前）
     */
    @GetMapping("/api/merchant/scm/order/information/getValidateInfoForRecallByOrderCode/{scmOrderCode}")
    Response<RecallInfoDto> getValidateInfoBeforeRecallByScmOrderCode(@PathVariable("scmOrderCode") String scmOrderCode);

    /**
     * 通过清单编号获取信息用来校验是否能撤回（撤回下游订单之前）
     */
    @GetMapping("/api/merchant/scm/order/information/getValidateInfoForRecallByBizCode/{businessCode}")
    Response<RecallInfoDto> getValidateInfoBeforeRecallByBizCode(@PathVariable("businessCode") String businessCode);

    /**
     * 通过旧的过期上游订单号获取信息用来校验是否能撤回（撤回新补发订单之前）
     */
    @GetMapping("/api/merchant/scm/order/information/getValidateInfoForRecallByExpiredUpOrderCode/{expiredUpOrderCode}")
    Response<RecallInfoDto> getValidateInfoBeforeRecallByExpiredUpOrderCode(@PathVariable("expiredUpOrderCode") String expiredUpOrderCode);



    /**
     * 撤回下游订单
     *
     * @param req {orderCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/recallDownOrder")
    Response<RecallInfoDto> recallDownOrder(@RequestBody ReqOrderRefund req);

    /**
     * 过期补发的订单客户不满意，客户要撤回重新补发
     * 撤回过期补发
     */
    @PostMapping("/api/merchant/scm/order/information/recallReissueOrder")
    Response<RecallInfoDto> recallReissueOrder(@RequestBody RecallReissueParamDto req);

    /**
     * 通过清单编号 撤回下游订单
     */
    @GetMapping("/api/merchant/scm/order/information/recallDownOrderByBusinessCode/{businessCode}")
    Response<RecallInfoDto> recallDownOrderByBusinessCode(@PathVariable("businessCode") String businessCode);


    /**
     * 获取电卡下游订单：充值金额,包括该下游订单中所有电卡类型上游订单充值金额 （因为：可能是平台自定义套餐产品）
     * @param scmOrderCode 下游订单号
     */
    @GetMapping("/api/merchant/scm/order/information/getElectricRechargeAmt/{scmOrderCode}")
    Response<ElectricScmOrderAmtDto> getElectricRechargeAmt(@PathVariable("scmOrderCode") String scmOrderCode);

    /**
     * 检查是不是所有的明细订单（上游订单）都领取完成了
     *
     * @param req {orderCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/checkOrderDetailAllReceive")
    Response<MerchantScmOrderInformation> checkOrderDetailAllReceive(@RequestBody ReqScm req);

    /**
     * 下游订单重试发起
     *
     * @param retry {orderCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/scmManualRetryDownOrder")
    Response scmManualRetryDownOrder(@RequestBody ReqScmManualRetry retry);

    /**
     * 上游订单重试发起
     *
     * @param retry {orderItemCode}
     * @return
     */
    @PostMapping("/api/merchant/scm/order/information/scmManualRetryUpOrder")
    Response scmManualRetryUpOrder(@RequestBody ReqScmManualRetry retry);


    /**
     * 更新下游订单服务商备付金领取状态
     *
     * @param orderCode          下游订单编号
     * @param agentReceiveStatus 下游订单服务商备付金领取状态
     * @return
     */
    @GetMapping("/api/merchant/scm/order/information/updateOrderAgentReceiveStatus")
    Response<Boolean> updateOrderAgentReceiveStatus(@RequestParam("orderCode") String orderCode,
                                                    @RequestParam("agentReceiveStatus") String agentReceiveStatus);


    /**
     * 根据上游订单号获取供应商套餐明细
     *
     * @param orderItemCode 上游订单编号
     * @return
     */
    @GetMapping("/api/merchant/scm/order/combo/getByOrderItemCode")
    Response<List<MerchantScmOrderComboDetail>> getComboDetailByOrderItemCode(@RequestParam("orderItemCode") String orderItemCode);

    /**
     * 根据供应商明细编号comboOrderItemCode更新供应商明细
     *
     * @param detail
     * @return
     */
    @PostMapping("/api/merchant/scm/order/combo/updateByComboOrderItemCode")
    Response<List<MerchantScmOrderComboDetail>> updateByComboOrderItemCode(@RequestBody MerchantScmOrderComboDetail detail);

    /**
     * 根据供应商明细编号comboOrderItemCode批量更新供应商明细
     *
     * @param details
     * @return
     */
    @PostMapping("/api/merchant/scm/order/combo/updateComboOrderListByItemCode")
    Response<List<MerchantScmOrderComboDetail>> updateComboOrderListByItemCode(@RequestBody List<MerchantScmOrderComboDetail> details);


    /**
     * 通过roco用户券编号查询 供应商明细订单号
     */
    @PostMapping("/api/merchant/scm/order/combo/findToMapByRocoUserCouponCodes")
    Response<Map<String, MerchantScmOrderComboDetail>> findComboOrderMapByRocoCouponCodes(@RequestBody List<String> rocoUserCouponCodes);


    /**
     * 得到代理商 Name和code 主要是数据权限用
     *
     * @return
     */
    @GetMapping("/api/merchant/agent/getMerchantAgentNameAndCodeList")
    Response<List<MerchantAgent>> getMerchantAgentNameAndCodeList();


    /**
     * 得到合作客户的 Name和code 主要是数据权限用
     *
     * @return
     */
    @GetMapping("/api/merchant/cooperationCustomer/getMerchantCoCustomerNameAndCodeList")
    Response<List<MerchantCooperationCustomer>> getMerchantCoCustomerNameAndCodeList();


    /******************************************积分兑换商品 *********************************************************/
    /**
     * 积分兑换商品-后台列表
     *
     * @param miniAppid
     * @param code
     * @param name
     * @param agentGoodsCode
     * @param productTypeCode
     * @param status
     * @param agentGoodsStatus
     * @param miniAppidList
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoodsPoints/queryPage")
    PageTable<MerchantExchangeGoodsPoints> merchantExchangeGoodsPointPageTable(@RequestParam(value = "miniAppid", required = false) String miniAppid,
                                                                               @RequestParam(value = "code", required = false) String code,
                                                                               @RequestParam(value = "name", required = false) String name,
                                                                               @RequestParam(value = "agentGoodsCode", required = false) String agentGoodsCode,
                                                                               @RequestParam(value = "productTypeCode", required = false) String productTypeCode,
                                                                               @RequestParam(value = "status", required = false) String status,
                                                                               @RequestParam(value = "agentGoodsStatus", required = false) String agentGoodsStatus,
                                                                               @RequestParam(value = "miniAppidList", required = false) List<String> miniAppidList,
                                                                               @RequestParam(value = "agentList", required = false) List<String> agentList,
                                                                               @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                               @RequestParam(value = "page", defaultValue = "1") int page);


    /**
     * admin端的分页查询，不动上面的merchantExchangeGoodsPointPageTable，然后调整为对象
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoodsPoints/admin/queryPage")
    PageTable<MerchantExchangeGoodsPoints> merchantExchangeGoodsPointPageTable(@RequestBody ExchangeGoodsPointAdminPageReq req);

    /**
     * 积分兑换商品-详情
     *
     * @param code
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoodsPoints/code")
    Response<MerchantExchangeGoodsPoints> getMerchantExchangeGoodsPointsDetailByCode(@RequestParam(value = "code") String code);


    /**
     * 前端-查询积兑换商品
     *
     * @param keyword
     * @param sortType
     * @param goodsClassificationCode
     * @param brandCodeList
     * @param minPrice
     * @param maxPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoodsPoints/findExchangeGoodsPointsList")
    PageTable<MerchantExchangeGoodsPoints> findExchangeGoodsPointsList(
            @RequestParam(value = "keyword", required = false) String keyword,
            @RequestParam(value = "sortType") String sortType,
            @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
            @RequestParam(value = "brandCodeList", required = false) List<String> brandCodeList,
            @RequestParam(value = "minPrice", required = false) String minPrice,
            @RequestParam(value = "maxPrice", required = false) String maxPrice,
            @RequestParam(value = "type", required = false) String type,
            @RequestParam(value = "miniAppid", required = false) String miniAppid,
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page);


    /**
     * 更新状态，排序
     *
     * @param merchantExchangeGoodsPoints
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoodsPoints/statusOrSort")
    Response switchPointsGoodsStatusOrSort(@RequestBody MerchantExchangeGoodsPoints merchantExchangeGoodsPoints);


    /**
     * 批量上下架
     *
     * @param codes
     * @param status
     * @param operateUser
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoodsPoints/batch/status")
    Response merchantGoodsPointsBatchOperateStatus(@RequestParam("codes") String[] codes, @RequestParam("status") String status, @RequestParam("operateUser") String operateUser);

    /**
     * 新建积分兑换产品
     *
     * @param merchantExchangeGoodsPoints
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoodsPoints/createPointsGoods")
    Response createPointsGoods(@RequestBody MerchantExchangeGoodsPoints merchantExchangeGoodsPoints);


    @GetMapping("/api/merchant/exchangeGoodsPoints/selectMaxSort")
    Response selectMaxSort();

    /**
     * 根据积分兑换产品编码列表查询对应积分兑换产品信息
     *
     * @param codeList
     * @param status
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoodsPoints/findByCodeList")
    Response<List<MerchantExchangeGoodsPoints>> findByCodeList(@RequestParam(value = "codeList", required = false) List<String> codeList,
                                                               @RequestParam(value = "status", required = false) String status);

    /**
     * 根据积分兑换产品编码列表查询对应积分兑换产品信息(包括平台产品相关信息)
     *
     * @param codeList
     * @param status
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoodsPoints/findAllInfoByCodeList")
    Response<List<MerchantExchangeGoodsPoints>> findAllInfoByCodeList(@RequestParam(value = "codeList", required = false) List<String> codeList,
                                                                      @RequestParam(value = "status", required = false) String status);
    /******************************************积分兑换商品 end*********************************************************/


    /**
     * 列表详情，主要是在是套餐的情况下，点击查看详情
     *
     * @param requestDto
     * @return
     */
    @PostMapping("/api/bAgent/facade/goods/bAgentProductDetail")
    Response<BAgentProductResponseDto> bAgentProductDetail(@RequestBody BAgentProductDetailRequestDto requestDto);


    /**
     * 得到最后的孩子节点
     *
     * @return
     */
    @GetMapping("/api/merchant/merchant-product-type/lastChild")
    Response<List<MerchantProductType>> merchantProductTypeLastChild();

    /**
     * @return
     */
    @GetMapping("/api/merchant/dataPermission/getDPCategoryTree")
    Response<List<DPCategoryTreeDto>> getDPCategoryTree();


    /****************************************** 备付金重新处理 start*********************************************************/
    /**
     * 操作数据的列表
     *
     * @param type
     * @return
     */
    @GetMapping("/api/merchant/scm/coverdata/list/{type}")
    Response<List<MerchantScmCoverData>> getCoverDataList(@PathVariable(value = "type") String type);

    /**
     * 获取待处理的合作客户备付金
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/coverdata/list/getCustomerReloadData")
    Response<List<MerchantScmCoverData>> getCustomerReloadData();

    /**
     * 更新操作数据状态
     *
     * @param data
     * @return
     */
    @PostMapping("/api/merchant/scm/coverdata/updateCoverStatus")
    Response updateCoverStatus(@RequestBody ReqCoverData data);

    /**
     * 更新扣减流水号
     *
     * @param data
     * @return
     */
    @PostMapping("/api/merchant/scm/coverdata/udpateDeductionsFlowCode")
    Response udpateDeductionsFlowCode(@RequestBody ReqCoverData data);

    /**
     * 更新退款流水号
     *
     * @param data
     * @return
     */
    @PostMapping("/api/merchant/scm/coverdata/udpateRefundedFlowCode")
    Response udpateRefundedFlowCode(@RequestBody ReqCoverData data);

    /**
     * 更新服务备付金退款信息
     * 1、同步数据处理结果
     * 2、修改下游订单服务商备付金退款状态、时间、流水
     * 3、保存下游订单退款记录
     *
     * @param data
     * @return
     */
    @PostMapping("/api/merchant/scm/coverdata/updateAgentRefundInfo")
    Response updateAgentRefundInfo(@RequestBody ReqCoverData data);


    /**
     * 更新下游订单服务商支付信息
     * 1、同步数据处理结果
     * 2、修改下游订单服务商备付金支付状态、时间、次数、流水
     * 3、保存下游订单支付记录
     *
     * @return
     */
    @PostMapping("/api/merchant/scm/coverdata/updateAgentPayInfo")
    Response updateAgentPayInfo(@RequestBody ReqCoverData data);

    /**
     * @param data
     * @return
     */
    @PostMapping("/api/merchant/scm/coverdata/customerPayCover")
    Response customerPayCover(@RequestBody ReqCoverData data);

    /**
     * @param data
     * @return
     */
    @PostMapping("/api/merchant/scm/coverdata/customerRefundCover")
    Response customerRefundCover(@RequestBody ReqCoverData data);

    /**
     * （1）修复历史上游订单的 使用有效期
     * （2）修改历史供应商套餐明细的 使用有效期
     */
    @GetMapping("/api/merchant/scm/coverdata/fixHistoryUpOrderUseValidity")
    Response fixHistoryUpOrderUseValidity();

    /**
     * 通过中间临时表方式 更新 上游订单的使用有效期
     */
    @GetMapping("/api/merchant/scm/coverdata/fixHistoryScmOrderDetailUseValidity")
    Response fixHistoryScmOrderDetaisUseValidityByTmpTable();

    /**
     * 初始化下游订单合作客户备付金重新扣减/退款数据
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/coverdata/initCustomerPayReloadData")
    Response<List<MerchantScmCoverData>> initCustomerPayReloadData(@RequestBody CustomerPayReloadDTO req);

    /**
     * 更新下游订单合作客户扣减/退款流水号
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/coverdata/updateCustomerFlow")
    Response updateScmOrderCustomerFlow(@RequestBody List<ReqCoverData> req);

    /**
     * 检查指定批次的下游订单合作客户备付金重新扣减/退款是否全部处理成功
     *
     * @param batchNo
     * @return
     */
    @GetMapping("/api/merchant/scm/coverdata/checkCustomerPayReloadResult")
    Response checkCustomerPayReloadResult(@RequestParam("batchNo") String batchNo);


    /**
     * 修正 客户产品 和 客户信息
     */
    @PostMapping("/api/merchant/scm/coverdata/correctCustomerAndProduct")
    Response correctCustomerAndProductInfo(@RequestBody CorrectScmOrderDto correctOrderDto);


    /**
     * 等享福那边修正结算单信息后，根据返回的结算批次号把 下游订单的结算信息设置成未结算
     */
    @PostMapping("/api/merchant/scm/coverdata/correctScmOrderSettleInfo")
    Response correctScmOrderSettleInfo(@RequestBody List<String> settleBatchCodeList);


    /****************************************** 备付金重新处理 end*********************************************************/


    /****************************************** 结算scm下游订单 start*********************************************************/

    /**
     * 收款单结算
     *
     * @return 如果返回成功，调用方才需要更新收款单状态,否则返回错误提示消息
     */
    @PostMapping("/api/merchant/scm/order/settle/settleOrder")
    Response<String> settleScmOrder(@RequestBody ScmOrderSettleParamDto settleParamDto);


    /**
     * 分页搜索 收款单中 已结算下游订单列表
     *
     * @param searchParam
     */
    @GetMapping("/api/merchant/scm/order/settle/searchSettledOrder")
    PageTable<ScmSearchSettleOrderRespDto> searchSettledOrderPage(@SpringQueryMap ScmSearchSettleOrderParamDto searchParam);

    /**
     * 订单结算信息已经成功同步推送到 结算系统中,并且结算系统已经成功处理了消息，则更新syncToSettle=true
     */
    @GetMapping("/api/merchant/scm/order/settle/updateNotifiedToSettle")
    Response updateNotifiedToSettle(@RequestParam("batchCode") String batchCode);


    /**
     * 如果结算系统消费结算结果消息失败或没有收到消息，则可以调用此方法再次发送消息以同步结算结果
     */
    @GetMapping("/api/merchant/scm/order/settle/retrySyncSettleResult")
    Response retrySyncSettleResult(@RequestParam("batchCode") String batchCode);


    /**
     * 搜索需要推送到报表系统中 下游订单
     */
    @GetMapping("/api/merchant/scm/order/report/search")
    PageTable<MerchantScmOrderInformation> searchPushReportScmOrderPage(@SpringQueryMap SearchReportScmOrderParamDto searchParam);

    /**
     * 报表模块：搜索汇总报表查看发放清单
     */
    @GetMapping("/api/merchant/scm/order/report/searchGrantBillPage")
    PageTable<SearchReportGrantBillListRespDto> searchReportGrantBillPage(@SpringQueryMap SearchReportGrantBillListParamDto searchParam);

    /**
     * 获取最小的发放日期,即系统上线后 第一个下游订单的发放日期
     *
     * @return yyyy-MM-dd
     */
    @GetMapping("/api/merchant/scm/order/report/getMinDateWin")
    Response<String> getPushReportScmOrderMinDateWindow();


/****************************************** 结算scm下游订单 end*********************************************************/

    /**
     * 为了不影响其他，数据权限单独查询下，采用了POST提交
     *
     * @param codes 合作客户编码列表
     * @return
     */
    @PostMapping("/api/merchant/cooperationCustomer/findCustomerDPListByCodes")
    Response<List<MerchantCooperationCustomer>> findCustomerDPListByCodes(@RequestBody List<String> codes);

    /**
     * 根据父节点列表获取合作客户列表
     * @param pCodes 父级合作客户编码列表
     * @return
     */
    @PostMapping("/api/merchant/cooperationCustomer/findCustomerListByPCodes")
    Response<List<MerchantCooperationCustomer>> findCustomerListByPCodes(@RequestBody List<String> pCodes);


    /**
     * huhl
     * 代理商简单树，数据权限管理时用
     *
     * @return
     */
    @GetMapping("/api/merchant/dataPermission/getDPSimpleAgentTree")
    Response<List<DPSimpleAgentTreeDto>> getDPSimpleAgentTree();


    /**
     * 分页查询合作客户产品基本信息,关联了merchant_issuing_customer_goods
     * <p>
     * 是老接口PageBase的新写法 huhl
     * <p>
     * 已知场景：
     * 1.兑换码权益产品选择，弹窗
     * 2.单客户发券产品选择，弹窗
     */
    @GetMapping("/api/merchant/customer/goods/pageBaseRelationIssuingBody")
    PageTable<BaseGoodsResp> pageBaseRelationIssuingBody(@SpringQueryMap BaseGoodsReq baseGoodsReq);


    /**
     * 根据发放主体编号，查询发放主体配置的商品不分页
     * 2021-11-10 调整需求，发放主体的产品先在发放主体配置，之后才能查询
     * 已知场景：
     * 1.发券模版中商品
     * 2.批量发放中检查商品信息
     *
     * @param issuingBodyCode        发放主体编码
     * @param status                 合作产品状态
     * @param issuingBodyGoodsStatus 发放主体产品状态
     * @return 合作客户产品列表
     */
    @GetMapping("/api/merchant/customer/goods/findAllCustomerGoodsByIssuingReq")
    Response<List<MerchantCustomerGoodsListResp>> findAllCustomerGoodsByIssuingReq(@RequestParam(value = "issuingBodyCode") String issuingBodyCode,
                                                                                   @RequestParam(value = "customerCode") String customerCode,
                                                                                   @RequestParam(value = "status", required = false) String status,
                                                                                   @RequestParam(value = "issuingBodyGoodsStatus", required = false) String issuingBodyGoodsStatus);


    /**
     * 根据发放主体编号，查询发放主体配置的商品不分页 ,关联了merchant_issuing_customer_goods
     * <p>
     * 是老方法 search 的另一个写法
     * <p>
     * 如果是主体的权益产品查询-发放主体专用-列表接口 需要加上参数eQueryType
     * <p>
     * 2021-11-10 调整需求，发放主体的产品先在发放主体配置，之后才能查询
     * 已知场景：
     * 1.主体的权益产品查询-系统专用-列表接口
     * 2.主体的权益产品查询-发放主体专用-列表接口
     *
     * @return 合作客户产品列表
     */
    @PostMapping("/api/merchant/customer/goods/admin/searchCustomerGoodsRelationIssuingBody")
    Response<List<MerchantCustomerGoodsListResp>> searchCustomerGoodsRelationIssuingBody(@RequestBody MerchantCustomerGoodsSearchReq req);


    /**
     * 根据发放主体编号，查询发放主体配置的商品分页 ,关联了merchant_issuing_customer_goods
     * <p>
     * 是老方法 search 的另一个写法
     * <p>
     * 如果是主体的权益产品查询-发放主体专用-列表接口 需要加上参数eQueryType
     * <p>
     * 2021-11-10 调整需求，发放主体的产品先在发放主体配置，之后才能查询
     * 已知场景：
     * 1.主体的权益产品查询-系统专用-列表接口
     * 2.主体的权益产品查询-发放主体专用-列表接口
     *
     * @return 合作客户产品列表
     */
    @PostMapping("/api/merchant/customer/goods/admin/pageALLRelationIssuingBody")
    PageTable<MerchantCustomerGoodsListResp> pageALLRelationIssuingBody(@RequestBody MerchantCustomerGoodsSearchReq req);


    /**
     * hhl添加，使用场景
     * 在发放主体编辑，选择合作客户产品使用
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/pageCustomerGoodsSelect")
    PageTable<CustomerGoodsSelectResp> pageCustomerGoodsSelect(@RequestBody CustomerGoodsSelectReq req);


    /**
     * 删除发放主体产品
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/deleteIssuingBodyCustomerGoods")
    Response deleteIssuingBodyCustomerGoods(@RequestBody IssuingBodyCustomerGoodsDeleteReq req);


    /**
     * 保存发放主体产品
     *
     * @param list
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/saveIssuingBodyCustomerGoods")
    Response saveIssuingBodyCustomerGoods(@RequestBody @Validated IssuingBodyCustomerGoodsSaveReq req);


    /****************************************** 产品使用有效期 start*********************************************************/

    /**
     * 保存发放主体使用规则
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/validityRule/saveIssuingBodyRule")
    Response saveIssuingBodyValidityRule(@RequestBody IssuingBodyValidityRuleSaveReq req);


    /**
     * 保存产品使用规则
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/validityRule/saveProductRule")
    Response saveProductValidityRule(@RequestBody ProductValidityRuleSaveReq req);


    /**
     * 保存产品使用规则
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/validityRule/edit")
    Response editValidityRule(@RequestBody ValidityRuleBaseSaveReq req);

    /**
     * 根据id获取规则
     *
     * @param id
     * @return
     */
    @GetMapping("/api/merchant/validityRule/getById/{id}")
    Response<MerchantGoodsValidityRule> getValidityRuleById(@PathVariable("id") Integer id);

    /**
     * 根据id获取规则
     *
     * @param issuingBodyCode
     * @return
     */
    @GetMapping("/api/merchant/validityRule/getByIssuingBodyCode/{code}")
    Response<MerchantGoodsValidityRule> getValidityRuleByIssuingBodyCode(@PathVariable("code") String issuingBodyCode);

    /**
     * 修改产品规则状态
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/validityRule/changeStatus")
    Response changeValidityRuleStatus(@RequestBody ChangeStatusReq req);

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @GetMapping("/api/merchant/validityRule/deleteById/{id}")
    Response deleteValidityRuleById(@PathVariable("id") Integer id);

    /**
     * 分页查询
     *
     * @param req
     * @return
     */
    @GetMapping("/api/merchant/validityRule/pageProductRule")
    PageTable<ProductValidityRuleResp> pageValidityRule(@SpringQueryMap ProductRuleSearchReq req);


    /**
     * 获取合作客户产品规则(如果合作客户产品指定了规则那么取指定的,否则取发放主体的规则)
     *
     * @param issuingBodyCode
     * @param customerProductCode
     * @return
     */
    @GetMapping("/api/merchant/validityRule/getActiveProductRule")
    Response<MerchantGoodsValidityRule> getActiveProductRule(@RequestParam("issuingBodyCode") String issuingBodyCode, @RequestParam("customerProductCode") String customerProductCode);

    @PostMapping("/api/merchant/validityRule/findActiveProductRuleList")
    Response<Map<String, MerchantGoodsValidityRule>> findActiveProductRuleList(@RequestBody ProductValidityRuleReqDto reqDto);

    /**
     * 获获取发放主体规则列表
     *
     * @param issuingBodyCode
     * @return
     */
    @GetMapping("/api/merchant/validityRule/getProductRuleByIssuingBodyCode")
    Response<List<MerchantGoodsValidityRule>> getProductRuleByIssuingBodyCode(@RequestParam("issuingBodyCode") String issuingBodyCode);

    /**
     * 分页查询日志
     *
     * @param req
     * @return
     */
    @GetMapping("/api/merchant/log/page")
    PageTable<MerchantChangeLog> pageLogSearch(@SpringQueryMap LogSearchReq req);


    /****************************************** 产品使用有效期 end*********************************************************/


    /****************************************** 通道产品 huangdeyi Start   ***********************************************/

    /**
     * 根据条件分页查询第三方平台
     */
    @GetMapping("/api/merchant/third/platform/list")
    Response<PageTable<MerchantThirdPlatform>> listThirdPlatform(@RequestParam(name = "platformCode", required = false) String platformCode,
                                                                 @RequestParam(name = "platformName", required = false) String platformName,
                                                                 @RequestParam(name = "status", required = false) String status,
                                                                 @RequestParam(name = "page", defaultValue = "1") Integer page,
                                                                 @RequestParam(name = "limit", defaultValue = "10") Integer limit);

    /**
     * 保存或新增第三方平台
     *
     * @return
     */
    @PostMapping("/api/merchant/third/platform/addOrEdit")
    Response addOrEditThirdPlatform(@RequestBody MerchantThirdPlatform platform);

    /**
     * 更新第三方平台启用/停用状态
     *
     * @param platform
     * @return
     */
    @PostMapping("/api/merchant/third/platform/changeStatus")
    Response changeThirdPlatformStatus(@RequestBody MerchantThirdPlatform platform);

    /**
     * 根据条件分页查询扣款主体
     */
    @GetMapping("/api/merchant/deductSubject/list")
    Response<PageTable<MerchantDeductSubject>> listDeductSubject(@RequestParam(name = "code", required = false) String code,
                                                                 @RequestParam(name = "name", required = false) String name,
                                                                 @RequestParam(name = "platformCode", required = false) String platformCode,
                                                                 @RequestParam(name = "status", required = false) String status,
                                                                 @RequestParam(name = "page", defaultValue = "1") Integer page,
                                                                 @RequestParam(name = "limit", defaultValue = "10") Integer limit);

    /**
     * 根据编码列表查询扣款主体
     */
    @GetMapping("/api/merchant/deductSubject/listByCodeList")
    Response<List<MerchantDeductSubject>> listDeductSubjectByCodeList(@RequestParam("codeList") List<String> codeList);

    /**
     * 保存或新增扣款主体
     *
     * @param deductSubjectReqDto
     * @return
     */
    @PostMapping("/api/merchant/deductSubject/addOrEdit")
    Response addOrEditDeductSubject(@RequestBody DeductSubjectReqDto deductSubjectReqDto);

    /**
     * 更新扣款主体启用/停用状态
     *
     * @param deductSubject
     * @return
     */
    @PostMapping("/api/merchant/deductSubject/changeStatus")
    Response changeDeductSubjectStatus(@RequestBody MerchantDeductSubject deductSubject);

    /**
     * 根据扣款主体编号分页查询其对应的扣款主体参数
     */
    @GetMapping("/api/merchant/deductSubject/params/list")
    Response<PageTable<MerchantDeductSubjectParams>> listDeductSubjectParams(@RequestParam(name = "deductSubjectCode", required = true) String deductSubjectCode,
                                                                             @RequestParam(name = "page", defaultValue = "1") Integer page,
                                                                             @RequestParam(name = "limit", defaultValue = "10") Integer limit);

    /**
     * 根据扣款主体编号查询其所有的扣款主体参数
     *
     * @param deductSubjectCode the deduct subject code
     * @return the response
     */
    @GetMapping("/api/merchant/deductSubject/params/getParamsMapByDeductSubjectCode")
    Response<Map<String, String>> listByDeductSubjectCode(@RequestParam(name = "deductSubjectCode") String deductSubjectCode);


    /**
     * 根据扣款主体编号查询其所有的扣款主体参数
     * @param deductSubjectCodeList 扣款主体列表
     * @return 返回扣款主体的配置的扣款参数信息
     */
    @PostMapping("/api/merchant/deductSubject/params/getDeductParamMapBySubjectCodesIn")
    Response<Map<String, Map<String, String>>> listDeductParamToMapBySubjectCodes(@RequestBody List<String> deductSubjectCodeList);

    /**
     * 根据扣款主体编号查询其所有的扣款主体参数
     * @param orderItemCode 上游
     * @return 返回扣款主体的配置的扣款参数信息
     */
    @GetMapping("/api/merchant/deductSubject/params/getDeductParamMapByScmOrderItemCode")
    Response<Map<String, String>> getDeductParamMapByScmOrderItemCode(@RequestParam(name = "orderItemCode") String orderItemCode);

    /**
     * 根据条件分页查询通道产品
     */
    @GetMapping("/api/merchant/channel/product/list")
    Response<PageTable<MerchantChannelProduct>> listChannelProduct(@RequestParam(name = "code", required = false) String code,
                                                                   @RequestParam(name = "name", required = false) String name,
                                                                   @RequestParam(name = "productCategory", required = false) String productCategory,
                                                                   @RequestParam(name = "thirdProductCode", required = false) String thirdProductCode,
                                                                   @RequestParam(name = "thirdPlatformCode", required = false) String thirdPlatformCode,
                                                                   @RequestParam(name = "deductSubjectCode", required = false) String deductSubjectCode,
                                                                   @RequestParam(name = "status", required = false) String status,
                                                                   @RequestParam(name = "page", defaultValue = "1") Integer page,
                                                                   @RequestParam(name = "limit", defaultValue = "10") Integer limit);

    /**
     * 保存或新增通道产品
     *
     * @return
     */
    @PostMapping("/api/merchant/channel/product/addOrEdit")
    Response addOrEditChannelProduct(@RequestBody ChannelProductReqDto channelProductReqDto);

    /**
     * 更新通道产品启用/停用状态
     *
     * @param channelProduct
     * @return
     */
    @PostMapping("/api/merchant/channel/product/changeStatus")
    Response changeChannelProductStatus(@RequestBody MerchantChannelProduct channelProduct);

    /**
     * 根据code删除通道产品
     *
     * @param code
     * @return
     */
    @PostMapping("/api/merchant/channel/product/delete/{code}")
    Response deleteChannelProduct(@PathVariable("code") String code);

    /**
     * 获取通道产品所有信息(包含扣款主体参数配置)
     *
     * @param code
     * @return
     */
    @GetMapping("/api/merchant/channel/product/getAllInfoByCode")
    Response<MerchantChannelProduct> getChannelProductAllInfoByCode(@RequestParam("code") String code);

    /**
     * 获取通道产品所有信息(包含扣款主体参数配置)
     * @param channelProductCodeList 通道产品代码列表
     */
    @GetMapping("/api/merchant/channel/product/getChannelProductAllInfoToMapByCodeIn")
    Response<Map<String, MerchantChannelProduct>> getChannelProductAllInfoToMapByCodeIn(@RequestParam("channelProductCodeList") List<String> channelProductCodeList);

    /****************************************** 通道产品 huangdeyi End   ***********************************************/

    /****************************************** 平台产品的通道产品配置 ranxiangfu start   ***********************************************/

    /**
     * List channel product config by goods code response.
     *
     * @param goodsCode the goods code
     * @return the response
     */
    @GetMapping("/api/merchant/merchantGoodsChannelProductConfig/listByGoodsCode")
    Response<List<MerchantGoodsChannelProductConfig>> listChannelProductConfigByGoodsCode(
            @RequestParam("goodsCode") String goodsCode);

    /**
     * Save channel product config response.
     *
     * @param config the config
     * @return the response
     */
    @PostMapping("/api/merchant/merchantGoodsChannelProductConfig")
    Response saveChannelProductConfig(@RequestBody MerchantGoodsChannelProductConfig config);

    /**
     * Save channel product config response.
     *
     * @param config the config
     * @return the response
     */
    @PostMapping("/api/merchant/merchantGoodsChannelProductConfig/defaultSet")
    Response channelProductConfigDefaultSet(@RequestBody MerchantGoodsChannelProductConfig config);

    /**
     * Batch save channel product config response.
     *
     * @param configs the configs
     * @return the response
     */
    @PostMapping("/api/merchant/merchantGoodsChannelProductConfig/batchSave")
    Response batchSaveChannelProductConfig(@RequestBody List<MerchantGoodsChannelProductConfig> configs);

    /**
     * Delete channel product config response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/merchant/merchantGoodsChannelProductConfig/{id}")
    Response deleteChannelProductConfig(@PathVariable("id") Integer id);
    /****************************************** 平台产品的通道产品配置 ranxiangfu end   ***********************************************/
    /**
     * 得到上游订单的总记录数
     *
     * @param queryDto 查询请求
     * @return
     */
    @PostMapping("/api/merchant/scm/order/detail/getUpOrderTotalCount")
    Response<Integer> getUpOrderTotalCount(@RequestBody UpOrderQueryDto queryDto);


    /**
     * 重新尝试创建商品订单
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/information/scheduleRetryCreateGoodsOrder")
    Response scheduleRetryCreateGoodsOrder();


    /**
     * 用户券发放成功，更新用户券号到订单
     *
     * @param result
     * @return
     */
    @PostMapping("/api/merchant/scm/information/updateCreateGoodsOrderResult")
    Response updateCreateGoodsOrderResult(@RequestBody CreateGoodsOrderRes result);


    /**
     * B端，代理商有商品的 GoodsTypeCode
     *
     * @param searchReq
     * @return
     */
    @PostMapping("/api/merchant/agent/goods/bAgentGoodsFilterGoodsTypeCodeList")
    Response<List<String>> bAgentGoodsFilterGoodsTypeCodeList(@RequestBody BAgentSearchGoodsReq searchReq);

    /**
     * B端，合作客户有商品的 GoodsTypeCode
     *
     * @param searchReq
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/bAgentCustomerGoodsFilterGoodsTypeCodeList")
    Response<List<String>> bAgentCustomerGoodsFilterGoodsTypeCodeList(@RequestBody BAgentSearchGoodsReq searchReq);


    /**
     * 根据合作客户产品编号查询合作客户产品
     *
     * @param code
     * @return
     */
    @GetMapping("/api/merchant/customer/goods/getByCode/{code}")
    Response<MerchantCustomerGoods> getCustomerProductByCode(@PathVariable("code") String code);

    /**
     * 根据合作客户产品编号获取平台产品的品牌编号
     */
    @GetMapping("/api/merchant/customer/goods/getBrandCode/{customerProductCode}")
    Response<String> getBandCodeByCustomerProductCode(@PathVariable("customerProductCode") String customerProductCode);


    /**
     * 根据平台编码集合查询 套餐子项目信息，需求：B端 列表中也要返回套餐Item
     *
     * @param platformGoodsCodeList
     * @return
     */
    @PostMapping("/api/bAgent/facade/goods/getSuitItemMap")
    Response<Map<String, List<BAgentProductResponseDto>>> getSuitItemMap(@RequestBody List<String> platformGoodsCodeList);

    /******************************* 过期补发申请  yinshihao  start   ***********************************/
    /**
     * 过期补发申请列表查询接口
     *
     * @param queryDto 查询参数Dto
     * @return
     */
    @PostMapping("/api/merchant/scm/reissue/apply/reissueApplyPageQuery")
    PageTable<MerchantScmReissueApply> reissueApplyPageQuery(@RequestBody ReissueApplyQueryDto queryDto);

    /**
     * 创建过期补发申请
     *
     * @param reissueApply
     * @return
     */
    @PostMapping("/api/merchant/scm/reissue/apply/createReissueApply")
    Response<String> createReissueApply(@RequestBody MerchantScmReissueApply reissueApply);

    /**
     * 审批
     *
     * @param reissueApplyUpdateDto
     * @return
     */
    @PostMapping("/api/merchant/scm/reissue/apply/approveReissueApply")
    Response<String> approveReissueApply(@RequestBody ReissueApplyUpdateDto reissueApplyUpdateDto);

    /**
     * 根据补发申请单号获取补发申请详情(包括明细信息)
     *
     * @param applyNo
     * @return
     */
    @GetMapping("/api/merchant/scm/reissue/apply/getReissueApplyByApplyNo")
    Response<MerchantScmReissueApply> getReissueApplyByApplyNo(@RequestParam("applyNo") String applyNo);

    /**
     * 根据申请单号更新申请单信息
     *
     * @param reissueApply
     * @return
     */
    @PostMapping("/api/merchant/scm/reissue/apply/updateReissueApplyByApplyNo")
    Response<Boolean> updateReissueApplyByApplyNo(@RequestBody MerchantScmReissueApply reissueApply);


    /**
     * 根据申请单号补录附件信息
     *
     * @param addAttachmentDto
     * @return
     */
    @PostMapping("/api/merchant/scm/reissue/apply/updateReissueApplyAttachmentByApplyNo")
    Response<String> updateReissueApplyAttachmentByApplyNo(@RequestBody AddAttachmentDto addAttachmentDto);
    /**
     * 得到申请单的总记录数
     *
     * @param queryDto 查询请求
     * @return
     */
    @PostMapping("/api/merchant/scm/reissue/apply/getReissueApplyTotalCount")
    Response<Integer> getReissueApplyTotalCount(@RequestBody ReissueApplyQueryDto queryDto);
    /******************************* 过期补发申请  yinshihao  end   ***********************************/

    /******************************* 过期补发申请明细  yinshihao  start   ***********************************/
    /**
     * 根据补发申请单号获取补发申请明细列表
     *
     * @param applyNo
     * @return
     */
    @GetMapping("/api/merchant/scm/reissue/apply/detail/getReissueApplyDetailByApplyNo")
    Response<List<MerchantScmReissueApplyDetail>> getReissueApplyDetailByApplyNo(@RequestParam("applyNo") String applyNo);

    /**
     * 根据明细单编号更新申请明细单信息
     *
     * @param reissueApplyDetail
     * @return
     */
    @PostMapping("/api/merchant/scm/reissue/apply/detail/updateReissueApplyDetailByApplyDetailCode")
    Response<Boolean> updateReissueApplyDetailByApplyDetailCode(@RequestBody MerchantScmReissueApplyDetail reissueApplyDetail);

    /**
     * 过期补发申请详情列表查询接口
     *
     * @param queryDto 查询参数Dto
     * @return
     */
    @PostMapping("/api/merchant/scm/reissue/apply/detail/reissueApplyDetailPageQuery")
    PageTable<ReissueApplyDetailPageRespDto> reissueApplyDetailPageQuery(@RequestBody ReissueApplyDetailQueryDto queryDto);
    /******************************* 过期补发申请明细  yinshihao  end   ***********************************/

    /******************************* 过期补发申请操作日志  yinshihao  start   ***********************************/
    /**
     * 保存操作日志
     *
     * @param reissueApplyLog
     * @return
     */
    @PostMapping("/api/merchant/scm/reissue/apply/log/saveReissueApplyLog")
    Response<Boolean> saveReissueApplyLog(@RequestBody MerchantScmReissueApplyLog reissueApplyLog);

    /**
     * 申请操作日志记录
     *
     * @param applyNo 申请单号
     * @param limit   每页条数
     * @param page    页码
     * @return
     */
    @GetMapping("/api/merchant/scm/reissue/apply/log/reissueApplyLogPageTable")
    PageTable<MerchantScmReissueApplyLog> reissueApplyLogPageTable(@RequestParam("applyNo") String applyNo,
                                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                   @RequestParam(value = "page", defaultValue = "1") int page);
    /******************************* 过期补发申请操作日志  yinshihao  end   ***********************************/


    /**
     * 矫正 发放主体产品 中的合作客户和产品 根据发放主体
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/correctIssuingBodyCustomerGoods")
    Response correctIssuingBodyCustomerGoods(@RequestBody IssuingCustomerAndProductParamDto req);

    /**
     * 创建仓库
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/createScmWarehouse")
    Response createScmWarehouse(@RequestBody ScmWarehouseCreateReq req);

    /**
     * 编辑分销仓库
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/editScmWarehouse")
    Response editScmWarehouse(@RequestBody ScmWarehouseEditReq req);


    /**
     * 改变仓库状态
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/updateScmWarehouseStatus")
    Response updateScmWarehouseStatus(@RequestBody ScmWarehouseChangeStatusReq req);


    /**
     * 删除仓库
     *
     * @param whCode
     * @param operator
     * @return
     */
    @GetMapping("/api/merchant/scm/warehouse/deleteScmWarehouse")
    Response deleteScmWarehouse(@RequestParam("whCode") String whCode, @RequestParam("operator") String operator);


    /**
     * 得到仓库详细信息
     *
     * @return
     */
    @GetMapping("/api/merchant/scm/warehouse/getScmWhDetailByWhCode")
    Response<MerchantScmWarehouse> getScmWhDetailByWhCode(@RequestParam("whCode") String whCode);

    /**
     * 分页搜索
     *
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/pageSearchScmWh")
    PageTable<MerchantScmWarehouse> pageSearchScmWh(@RequestBody ScmWarehouseSearchReq req);

    /**
     * 查询发放主体库存
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/pageSearchScmIssuingBodyStock")
    PageTable<ScmStockExtendDto> pageSearchScmIssuingBodyStock(@RequestBody ScmStockSearchReq req);

    /**
     * 查询合作客户库存
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/pageSearchScmCustomerStock")
    PageTable<ScmStockExtendDto> pageSearchScmCustomerStock(@RequestBody ScmStockSearchReq req);

    /**
     * 查询服务商库存
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/pageSearchScmAgentStock")
    PageTable<ScmStockExtendDto> pageSearchScmAgentStock(@RequestBody ScmStockSearchReq req);

    /**
     * 查询平台商库存
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/pageSearchScmPlatformStock")
    PageTable<ScmStockExtendDto> pageSearchScmPlatformStock(@RequestBody ScmStockSearchReq req);


    /**
     * 创建和提交申请单
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/allocateApply/createAndSubmitScmStockAllocateApply")
    Response createAndScmStockAllocateApply(@RequestBody ScmGoodsStockAllocateSaveReq req);

    /**
     * 获取详情
     *
     * @param whCode      仓库编号
     * @param whGoodsCode 仓库产品编号 发放主体：合作客户产品， 服务商：服务商产品编号，合作客户：合作客户产品 ，平台仓：平台产品编号
     * @return
     */
    @GetMapping("/api/merchant/scm/warehouse/stock/getScmStockDetail")
    Response<ScmStockExtendDto> getScmStockDetail(@RequestParam("whCode") String whCode,
                                                  @RequestParam("whGoodsCode") String whGoodsCode);

    /**
     * 根据仓库编码和产品编码集合查询相应的库存信息
     *
     * @param whCode       仓库编码
     * @param whGoodsCodes 产品编码集合
     * @return
     */
    @GetMapping("/api/merchant/scm/warehouse/stock/findScmStockByWhCodeAndGoodsCodes")
    Response<List<MerchantScmStock>> findScmStockByWhCodeAndGoodsCodes(@RequestParam("whCode") String whCode,
                                                                       @RequestParam("whGoodsCodes") List<String> whGoodsCodes);

    /**
     * 分销调整库存:增加,减少，预警调整
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/adjustScmStock")
    Response adjustScmStock(@RequestBody ScmGoodsStockAdjustReq req);


    /**
     * 调拨的分页
     *
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/allocateApply/pageSearchScmStockAllocate")
    PageTable<ScmStockAllocateApplyExtendDto> pageSearchScmStockAllocate(@RequestBody ScmStockAllocateApplySearchReq req);


    /**
     * 库存流
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/flow/pageSearchScmStockFlow")
    PageTable<MerchantScmStockFlow> pageSearchScmStockFlow(@RequestBody ScmStockFlowSearchReq req);


    /**
     * 库存流水Log
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/flow/log/pageSearchScmStockFlowLog")
    PageTable<MerchantScmStockFlowLog> pageSearchScmStockFlowLog(@RequestBody ScmStockFlowLogSearchReq req);

    /**
     * 批量手动减少库存(批量出库)
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/batchManualOutScmStock")
    Response batchManualOutScmStock(@RequestBody ScmGoodsBatchManualOutInReq req);

    /**
     * 批量手动增加库存(批量入库)
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/batchManualInScmStock")
    Response batchManualInScmStock(@RequestBody ScmGoodsBatchManualOutInReq req);


    /**
     * 保存发放主体仓库
     *
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/saveIssuingBodyCustomerGoodsWh")
    Response saveIssuingBodyCustomerGoodsWh(@RequestBody BodyCustomerGoodsSaveWhReq req);

    /**
     * 查询发放主体仓库
     *
     * @param issuingBodyCode
     * @return
     */
    @GetMapping("/api/merchant/scm/warehouse/findIssuingBodyWh")
    Response<MerchantScmWarehouse> findIssuingBodyWh(@RequestParam("issuingBodyCode") String issuingBodyCode);


    /**
     * 场景：查询主体关联的仓库和库存
     *
     * @param reqList
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/searchScmRelationGroupStock")
    Response<List<ScmStockExtendDto>> searchScmRelationGroupStock(@RequestBody List<ScmStockRelationGroupSearchReq> reqList);

    /**
     * 分销库存冻结请求
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/frozenScmStock")
    Response frozenScmStock(@RequestBody ScmGoodsStockFrozenReq req);


    /**
     * 单条占用库存
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/occupySingleScmStock")
    Response occupySingleScmStock(@RequestBody ScmGoodsStockSingleOccupyReq req);

    /**
     * 单条出库
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/outSingleScmStock")
    Response outSingleScmStock(@RequestBody ScmGoodsStockSingleOutReq req);


    /**
     * 单条库存取消
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/cancelSingleScmStock")
    Response cancelSingleScmStock(@RequestBody ScmGoodsStockSingleCancelReq req);


    /**
     * 得到主体对应的合作客户产品配置的仓库Map
     *
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/findBodyCustomerGoodsWhMap")
    Response<Map<String, String>> findBodyCustomerGoodsWhMap(@RequestBody IssuingCustomerGoodsWarehouseSearchReq req);

    /**
     * 分销库存解冻请求 财哥用
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/unFrozenScmStockByList")
    Response unFrozenScmStock(@RequestBody List<ScmGoodsStockSingleUnFrozenReq> reqList);


    /**
     * 分销库存解冻请求 老的
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/unFrozenScmStock")
    Response unFrozenScmStock(@RequestBody ScmGoodsStockUnFrozenReq req);


    /**
     * 平台产品转化为Map,根据产品编号集合
     *
     * @param goodsCodeList
     * @return
     */
    @PostMapping("/api/merchant/goods/toMapMerchantGoods")
    Response<Map<String, MerchantGoods>> toMapMerchantGoods(@RequestBody List<String> goodsCodeList);

    /**
     * 单条解冻库存
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/unFrozenSingleScmStock")
    Response unFrozenSingleScmStock(@RequestBody ScmGoodsStockSingleUnFrozenReq req);

    /**
     * 找到有关联了相同平台产品的仓库编号
     *
     * @param platformGoodsCode
     * @return
     */
    @GetMapping("/api/merchant/scm/warehouse/stock/findScmStockRelPlatformGoodsWhCode")
    Response<List<String>> findScmStockRelPlatformGoodsWhCode(@RequestParam("platformGoodsCode") String platformGoodsCode);


    /**
     * 根据仓库编码查询是否有产品
     *
     * @param whCode
     * @return
     */
    @GetMapping("/api/merchant/scm/warehouse/stock/getScmStockGoodsHasStockCountByWhCode")
    Response<Integer> getScmStockGoodsHasStockCountByWhCode(@RequestParam("whCode") String whCode);


    /**
     * 保存积分兑换产品分销仓库信息
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoodsPoints/saveExchangeGoodsPointsWarehouse")
    Response saveExchangeGoodsPointsWarehouse(@RequestBody MerchantExchangeGoodsPoints req);


    /**
     * 查询服务商仓库
     *
     * @param agentCode
     * @return
     */
    @GetMapping("/api/merchant/scm/warehouse/findAgentWh")
    Response<MerchantScmWarehouse> findAgentWh(@RequestParam("agentCode") String agentCode);


    /**
     * 返回积分兑换产品中配置的仓库
     *
     * @param codeList
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoodsPoints/findExchangeGoodsPointsWhMap")
    Response<Map<String, String>> findExchangeGoodsPointsWhMap(@RequestBody List<String> codeList);


    /**
     * 分销积分兑换库存冻结请求
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/scm/warehouse/stock/frozenScmPointExchangeGoodsStock")
    Response frozenScmPointExchangeGoodsStock(@RequestBody ScmPointExchangeGoodsStockFrozenReq req);

    /**
     * 批量新增,放到一个事务中执行
     *
     * @param merchantExchangeGoodsPoints
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoodsPoints/createBatchPointsGoods")
    Response createBatchPointsGoods(@RequestBody List<MerchantExchangeGoodsPoints> merchantExchangeGoodsPoints);


    /**
     * 保存发放主体可发放产品前检查下是否库存初始化了
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/saveBeforeCheckIssuingBodyCustomerGoods")
    Response saveBeforeCheckIssuingBodyCustomerGoods(@RequestBody IssuingBodyCustomerGoodsStockCheckReq req);

    /**
     * c端加油创建分销订单
     *
     * @param req
     * @return 下游订单号
     */
    @PostMapping("/api/merchant/scm/consumer/oil/createOrder")
    Response<String> createScmConsumerOilOrder(@RequestBody ScmConsumerOilCreateOrderReq req);

    /**
     * 保存中石油加油券使用记录
     *
     * @param record
     * @return
     */
    @PostMapping("/api/merchant/scm/cnpc/record/save")
    Response saveCnpcUsedRecord(@RequestBody MerchantScmCnpcUsedRecord record);


    /**
     * 更新发放主体产品状态
     *
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/changeIssuingBodyGoodsStatus")
    Response changeIssuingBodyGoodsStatus(@RequestBody IssuingBodyCustomerGoodsChangeStatusReq req);

    /**
     * 删除兑换积分产品
     *
     * @param code
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoodsPoints/deleteExchangeGoodsPoints")
    Response deleteExchangeGoodsPoints(@RequestParam("code") String code);

    /**
     * 保存copy的请求
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoodsPoints/saveCopyExchangeGoodsPoints")
    Response<MerchantExchangeGoodsPoints> saveCopyExchangeGoodsPoints(@RequestBody MerchantExchangeGoodsPoints req);


    /**
     * 查询要添加的产品状态逆袭
     *
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoodsPoints/queryExchangeGoodsPointsAddingGoodsStatusInfo")
    Response queryExchangeGoodsPointsAddingGoodsStatusInfo(@RequestBody ExchangeGoodsPointAddingStatusReq req);


    /**-----------------------餐饮会所服务相关-start-----------------------*/
    /**
     * 根据条件查询通道产品
     * 这里不需要分页，数据不会很多的
     *
     * @param issuingBodyCode 发放主体编码
     * @param status          启用状态
     * @param usedStatus      占用状态
     */
    @GetMapping("/api/merchant/club/room/list")
    Response<List<MerchantClubRoom>> merchantClubRoomQueryList(@RequestParam(name = "issuingBodyCode") String issuingBodyCode,
                                                               @RequestParam(name = "usedStatus", required = false) String usedStatus,
                                                               @RequestParam(name = "status", required = false) String status);

    /**
     * 根据条件查询数量
     * 需要排除软删的数据
     *
     * @param status     启用状态
     * @param usedStatus 占用状态
     */
    @GetMapping("/api/merchant/club/room/count")
    Response<Integer> merchantClubRoomCount(@RequestParam(name = "issuingBodyCode") String issuingBodyCode,
                                            @RequestParam(name = "usedStatus", required = false) String usedStatus,
                                            @RequestParam(name = "status", required = false) String status);

    /**
     * 根据编码列表查询会所包房列表
     */
    @GetMapping("/api/merchant/club/room/listByCode")
    public Response<List<MerchantClubRoom>> merchantClubRoomQueryListByCode(@RequestParam(name = "codeList") List<String> codeList);

    /**
     * 获取包房详情
     *
     * @param code 包房编码
     */
    @GetMapping("/api/merchant/club/room/detail")
    Response<MerchantClubRoom> merchantClubRoomQueryDetail(@RequestParam(name = "code") String code);

    /**
     * 保存或新增
     */
    @PostMapping("/api/merchant/club/room/addOrEdit")
    Response<MerchantClubRoom> merchantClubRoomAddOrEdit(@RequestBody MerchantClubRoom merchantClubRoom,
                                                         @RequestParam(name = "operationUser", required = false) String operationUser);

    /**
     * 更新启用/停用状态
     */
    @PostMapping("/api/merchant/club/room/changeStatus")
    Response merchantClubRoomChangeStatus(@RequestBody MerchantClubRoom merchantClubRoom);

    /**
     * 更新占用/非占用状态
     */
    @PostMapping("/api/merchant/club/room/changeUsedStatus")
    Response merchantClubRoomChangeUsedStatus(@RequestBody MerchantClubRoom merchantClubRoom);

    /**
     * 删除包房
     */
    @PostMapping("/api/merchant/club/room/delete/{code}")
    Response merchantClubRoomDelete(@PathVariable("code") String code);


    /**
     * 根据条件查询通道产品
     * 这里不需要分页，数据不会很多的
     *
     * @param issuingBodyCode 发放主体编码
     * @param status          启用状态
     */
    @GetMapping("/api/merchant/club/dishes/list")
    Response<List<MerchantClubDishes>> merchantClubDishesQueryList(@RequestParam(name = "issuingBodyCode") String issuingBodyCode,
                                                                   @RequestParam(name = "status", required = false) String status);

    /**
     * 根据条件查询数量
     * 需要排除软删的数据
     *
     * @param status 启用状态
     */
    @GetMapping("/api/merchant/club/dishes/count")
    Response<Integer> merchantClubDishesCount(@RequestParam(name = "issuingBodyCode") String issuingBodyCode,
                                              @RequestParam(name = "status", required = false) String status);

    /**
     * 根据编码列表查询会所菜品列表
     */
    @GetMapping("/api/merchant/club/dishes/listByCode")
    Response<List<MerchantClubDishes>> merchantClubDishesQueryListByCode(@RequestParam(name = "codeList") List<String> codeList);

    /**
     * 获取菜品详情
     *
     * @param code 菜品编码
     */
    @GetMapping("/api/merchant/club/dishes/detail")
    Response<MerchantClubDishes> merchantClubDishesQueryDetail(@RequestParam(name = "code") String code);

    /**
     * 保存或新增
     */
    @PostMapping("/api/merchant/club/dishes/addOrEdit")
    Response<MerchantClubDishes> merchantClubDishesAddOrEdit(@RequestBody MerchantClubDishes merchantClubDishes,
                                                             @RequestParam(name = "operationUser", required = false) String operationUser);

    /**
     * 更新启用/停用状态
     */
    @PostMapping("/api/merchant/club/dishes/changeStatus")
    Response merchantClubDishesChangeStatus(@RequestBody MerchantClubDishes merchantClubDishes);

    /**
     * 删除菜品
     */
    @PostMapping("/api/merchant/club/dishes/delete/{code}")
    Response merchantClubDishesDelete(@PathVariable("code") String code);

    /**
     * 根据编码和状态查找包房
     */
    @GetMapping("/api/merchant/club/room/selectRoomByCodeAndStatus")
    Response<MerchantClubRoom> merchantClubSelectRoomByCodeAndStatus(@RequestParam("code") String code, @RequestParam("status") String status);

    /**-----------------------餐饮会所服务相关-end-----------------------*/


    /**---------------------o2o----------相关的一些支持查询-----------*/

    /**
     * 根据合作客户获取供应商
     *
     * @param customerCode
     * @return
     */
    @GetMapping("/api/merchant/supplier/findSupplierListByCustomerCode")
    Response<List<MerchantSupplier>> findSupplierListByCustomerCode(@RequestParam("customerCode") String customerCode);

    /**
     * hhl 添加只获取本表的基本信息不关联
     *
     * @param code
     */
    @GetMapping("/api/merchant/cooperationCustomer/findCustomerBaseInfoByCode")
    Response<MerchantCooperationCustomer> findCustomerBaseInfoByCode(@RequestParam("code") String code);


    /**
     * hhl 根据供应商产品编号获取平台产品基本信息不关联
     *
     * @param supplierGoodsCode
     * @return
     */
    @GetMapping("/api/merchant/goods/findMerchantGoodsBaseInfoListBySupplierGoodsCode")
    Response<List<MerchantGoods>> findMerchantGoodsBaseInfoListBySupplierGoodsCode(@RequestParam("supplierGoodsCode") String supplierGoodsCode);


    /**
     * 根据合作客户信息查询商户信息
     *
     * @param customerCode
     * @return
     */
    @GetMapping("/api/merchant/store/getMerchantStoreBaseInfoListByCustomerCode")
    Response<List<MerchantStore>> getMerchantStoreBaseInfoListByCustomerCode(@RequestParam(value = "customerCode") String customerCode);


    /**
     * 根据合作客户 和 平台产品 查询服务商产品
     *
     * @param customerCode
     * @param goodsCode
     * @return
     */
    @GetMapping("/api/merchant/customer/goods/findBaseListByCustomerCodeAndGoodsCode")
    Response<List<MerchantCustomerGoods>> findBaseListByCustomerCodeAndGoodsCode(
            @RequestParam(value = "customerCode") String customerCode,
            @RequestParam(value = "goodsCode") String goodsCode);


    /**
     * 通过发放主体编号,查询 主体配置的可发放客户产品，对应的服务项目的客户产品[包括全部状态的]（客户自营的服务项目）
     */
    @GetMapping("/api/merchant/customer/goods/findByIssueBodyCode")
    Response<List<MerchantCustomerGoods>> findCustomerGoodsByIssueBodyCode(@RequestParam(name = "issuingBodyCode") String issuingBodyCode);


    /**
     * 客户服务项目管理列表查询
     *
     * @return
     */
    @PostMapping("/api/merchant/storeservice/customerMStoreServiceQueryPage")
    PageTable<MerchantStoreService> customerMStoreServiceQueryPage(@RequestBody CustomerMerchantStoreServiceQueryReq req);

    /**
     * 使用在后台 发放主体发放项目管理菜单
     *
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/issuingBody/storeServiceGoodsPageSearch")
    PageTable<IssuingBodyStoreServiceGoodsListDto> issuingBodyStoreServiceGoodsPageSearch(@RequestBody IssuingBodyStoreServiceGoodsPageReq req);


    /**
     * 使用在后台 发放主体发放项目管理菜单 中 添加服务项目的弹窗
     *
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/issuingBody/selectStoreServiceGoodsPageSearch")
    PageTable<IssuingBodySelectStoreServiceGoodsListDto> issuingBodySelectStoreServiceGoodsPageSearch(@RequestBody IssuingBodySelectStoreServiceGoodsPageReq req);


    /**
     * 根据条件查询一条发放主体产品
     *
     * @return
     */
    @GetMapping("/api/merchant/customer/goods/findOneIssuingBodyCustomerGoods")
    Response<MerchantIssuingBodyCustomerGoods> findOneIssuingBodyCustomerGoods(@RequestParam("issuingBodyCode") String issuingBodyCode,
                                                                               @RequestParam("customerCode") String customerCode,
                                                                               @RequestParam("customerGoodsCode") String customerGoodsCode);

    /**
     * 查询主体客户产品
     *
     * @return Map<客户产品编号       ,               MerchantIssuingBodyCustomerGoods>
     */
    @GetMapping("/api/merchant/customer/goods/findIssuingBodyCustomerGoodMap")
    Response<Map<String, MerchantIssuingBodyCustomerGoods>> findIssuingBodyCustomerGoodToMap(@RequestParam("issuingBodyCode") String issuingBodyCode);

    /**---------------------o2o----------相关的一些支持查询end-----------*/

    /**
     * 代理商树，数据权限管理时用，合作客户 代理商 主体 团队 中
     *
     * @return
     */
    @GetMapping("/api/merchant/dataPermission/getDPAgentTree")
    Response<List<DPAgentTreeDto>> getDPAgentTree();


    /**
     * 合作客户树，数据权限管理时用，合作客户 代理商 主体 团队 中
     *
     * @return
     */
    @PostMapping("/api/merchant/dataPermission/getDPCustomerTree")
    Response<List<DPCustomerTreeDto>> getDPCustomerTree(@RequestBody DPCustomerQueryParamDto req);




    /**--------------------------南网充值卡批次相关 -- start--------------------------*/
    /**
     * 分页查询
     */
    @GetMapping("/api/merchant/electric/rechargeCardBatch/pageSearch")
    PageTable<MerchantElectricRechargeCardBatch> merchantElectricRechargeCardBatchPageSearch(@SpringQueryMap RechargeCardBatchListDto params);

    /**
     * 根据批次号获取批次信息
     * @param batchNo   批次号
     * @return  单个批次信息
     */
    @GetMapping("/api/merchant/electric/rechargeCardBatch/getByBatchNo")
    Response<MerchantElectricRechargeCardBatch> merchantElectricRechargeCardBatchGetByBatchNo(@RequestParam("batchNo") String batchNo);

    /**
     * 同步渠道商充值卡所属批次信息
     * @param list      批次信息
     * @return  是否更新成功
     */
    @PostMapping("/api/merchant/electric/rechargeCardBatch/syncRechargeCardBatchInfo")
    Response<Boolean> merchantElectricRechargeCardBatchSyncRechargeCardBatchInfo(@RequestBody List<MerchantElectricRechargeCardBatch> list);

    /**
     * 过期退款
     * @param dto      充值卡批次过期退款的DTO
     * @return  是否更新成功
     */
    @PostMapping("/api/merchant/electric/rechargeCardBatch/expireRefund")
    Response<Boolean> merchantElectricRechargeCardBatchExpireRefund(@RequestBody RechargeCardBatchExpireRefundDto dto);


    /**--------------------------南网充值卡批次相关 --  end --------------------------*/




    /**
     * 查询发放主体 对应的合作客户产品 库存信息
     *
     * key:合作客户产品
     * @param req
     * @return
     */
    @PostMapping("/api/merchant/customer/goods/findToMapIssuingBodyCustomerGoodsStock")
    Response<Map<String,IssuingBodyCustomerGoodsStockDto>> findToMapIssuingBodyCustomerGoodsStock(@RequestBody IssuingCustomerGoodsWarehouseSearchReq req);



}
