package com.rocogz.merchant.dto.scm.order;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import com.rocogz.merchant.entity.scm.MerchantScmOrderInformation;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 撤回下游订单中，包括的电卡上游订单
 * @author zhangmin
 */
@Setter @Getter
@NoArgsConstructor
public class RecallElectricScmOrderItem {

   /**
    * 下游订单号
    * @see MerchantScmOrderDetail#orderCode
    */
   private String scmOrderCode;

   /**
    * 上游订单号
    * @see MerchantScmOrderDetail#orderItemCode
    */
   private String scmOrderItemCode;


   private String orderItemStatus;

   /**
    * 产品类别,上游订单中的产品类型,该产品类型用来决定走不同的上游订单Handler处理器类，非常重要
    * (1) 如果是不是平台自定义套餐,productType = MerchantScmProductInformation#productType
    * (2) 如果是平台自定义套餐，则 productType = 自定义平台套餐中子产品的产品类型
    *
    * @see Constant.DictData#PRODUCT_TYPE_FIXED_ELECTRIC
    */
   private String productType;

   /**
    * 电卡订单的 使用的充值批次号
    * @see MerchantScmOrderDetail#thirdOrderCode
    */
   private String batchNo;

   /**
    * 电卡充值金额
    *  @see MerchantScmOrderDetail#detailPrice
    */
   private BigDecimal chargeAmt;

   /**
    * 南网电卡 要扣减的金额,使用平台产品采购价
    * @see MerchantScmOrderDetail#getPlatProdPurchasePrice()
    */
   private BigDecimal purchasePrice;

   /**
    * 结算扣款主体编号
    * @see MerchantScmOrderDetail#channelProductDeductSubjectCode
    */
   private String deductSubjectCode;


   /**
    * 发放时间
    * @see MerchantScmOrderInformation#grantTime
    */
   private LocalDateTime grantTime;


   public static RecallElectricScmOrderItem of(MerchantScmOrderDetail detail) {

      RecallElectricScmOrderItem item = new RecallElectricScmOrderItem();

      item.setBatchNo(detail.getThirdOrderCode());
      item.setChargeAmt(detail.getDetailPrice());
      item.setPurchasePrice(detail.getPlatProdPurchasePrice());
      item.setScmOrderCode(detail.getOrderCode());
      item.setScmOrderItemCode(detail.getOrderItemCode());
      item.setOrderItemStatus(detail.getOrderStatus());
      item.setProductType(detail.getProductType());
      item.setDeductSubjectCode(detail.getChannelProductDeductSubjectCode());
      return item;
   }

}
