package com.rocogz.merchant.client.scm.intfc;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author yinshihao
 * @Description: 广东中石油发券返回dto
 * @Package com.rocogz.dto.dingju.response.token
 * @date 2022-08-01 10:36:17
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class DingjuOilGdzsyOrderRespDto {

    /**
     * 平台订单编号 (下单是否成功以此字段是否有值为准)
     */
    @JsonProperty("trade_no")
    private String tradeNo;

    /**
     * 扣款金额
     */
    @JsonProperty("pay_amount")
    private BigDecimal payAmount;

    /**
     * 固定核销URL
     */
    @JsonProperty("useUrl")
    private String useUrl;

    /**
     * 券名称
     */
    @JsonProperty("productName")
    private String productName;

    /**
     * 券面值
     */
    @JsonProperty("faceValue")
    private BigDecimal faceValue;

    /**
     * 生效时间
     */
    @JsonProperty("couponBeginDate")
    private LocalDateTime couponBeginDate;

    /**
     * 失效时间
     */
    @JsonProperty("couponEndDate")
    private LocalDateTime couponEndDate;

    /**
     * 订单状态
     * 1=>'待处理',
     * 2=>'已发券',
     * 3=>'发券失败',
     * 5=>'已退单',
     */
    @JsonProperty("state")
    private Integer state;

    /**
     * 使用状态：0-待同步，1-待使用，2-已使用，4-已作废
     */
    @JsonProperty("useStatus")
    private Integer useStatus;
}
