package com.rocogz.merchant.client.scm.starCharge;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 星星充电-卡券信息
 */
@Data
@Accessors(chain = true)
public class StarChargeCoupon {

    /**
     * 额度值
     */
    @JsonProperty(value = "Amount")
    private BigDecimal Amount;

    /**
     * 有效开始时间
     * 格式yyyy-MM-dd  00:00:00
     */
    @JsonProperty(value = "StartTime")
    private LocalDateTime StartTime;

    /**
     * 有效结束时间
     * 格式yyyy-MM-dd  00:00:00
     */
    @JsonProperty(value = "EndTime")
    private LocalDateTime EndTime;

    /**
     * 手机号
     */
    @JsonProperty(value = "PhoneNumber")
    private String PhoneNumber;

    /**
     * 卡券code
     */
    @JsonProperty(value = "Code")
    private String Code;

    /**
     * 状态
     * 状态：0：已创建 1：已发放 2：已使用 3：已冻结 4：使用中（锁定） 5：已失效
     */
    @JsonProperty(value = "Status")
    private String Status;

}
