package com.rocogz.merchant.client.scm.starCharge;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.rocogz.merchant.client.scm.intfc.BaseConfigReqDto;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 星星充电-卡券列表查询
 */
@Data
@Accessors(chain = true)
public class StarChargeQueryCouponInfoReq extends BaseConfigReqDto {

    /**
     * 集采编号
     */
    @JsonProperty(value = "ProvideId")
    private String ProvideId;

    /**
     * 券编码，多个逗号隔开
     */
    @JsonProperty(value = "Codes")
    private String Codes;

    /**
     * 手机号
     */
    @JsonProperty(value = "PhoneNumber")
    private String PhoneNumber;

    /**
     * 状态：0：已创建 1：已发放 2：已使用 3：已冻结 4：使用中（锁定） 5：已失效
     */
    @JsonProperty(value = "Status")
    private String Status;

    /**
     * 查询页码
     */
    @JsonProperty(value = "PageNo")
    private int PageNo = 1;

    /**
     * 每页数量
     */
    @JsonProperty(value = "PageSize")
    private int PageSize = 10;

}
