package com.rocogz.merchant.dto.customer.goods;

import lombok.Data;

/**
 * <dl>
 * <dd>Description:发放主体产品对应的库存信息 </dd>
 * <dd>@date: 2023/06/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyCustomerGoodsStockDto {

    /**
     * 合作客户产品编号
     */
    private String customerGoodsCode;

    /**
     * 合作客户产品名称
     */
    private String customerGoodsName;

    /**
     * 服务商产品编号
     */
    private String agentGoodsCode;

    /**
     * 平台产品编号
     */
    private String platformGoodsCode;

    /**
     * 是否启用库存 Y/N
     */
    private String whetherNeedStock;

    /**
     * 仓库编号：
     * 作用：返回主体可发放产品上配置的仓库编号
     */
    private String whCode;

    /**
     * 可售卖库存
     */
    private Integer sellableStock;

}
