package com.rocogz.merchant.dto.datapermission;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description:合作客户权限树 </dd>
 * <dd>@date: 2023/04/05</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class DPCustomerTreeDto {

    public DPCustomerTreeDto() {
        spread=true;
        checkArr=new DtreeCheckArr();
    }

    /**
     * 可以认为就是code和数据权限中的data_type的组合
     * 三部分：code,data_type,权益中whetherCustomer发放主体性质（代理商/合作客户/OTHER）
     */
    private String id;
    /**
     * 级别
     */
    private Integer level;
    /**
     * 标题
     */
    private String title;

    /**
     * 是否展开
     */
    private Boolean spread;

    /**
     * 节点的状态状态，看是否启用，前台没启用的会变颜色
     */
    private String status;

    /**
     * 孩子
     */
    private List<DPCustomerTreeDto> children;

    /**
     * Dtree必须的 如何是
     */
    private DtreeCheckArr checkArr ;
    /**
     *  code
     */
    private String code;
    /**
     * 数据权限类型
     */
    private String dataType;

}
