package com.rocogz.merchant.dto.goodsStock;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>Description:批量库存请求</dd>
 * <dd>@date: 2020/09/07</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
public class OrderBatchStockRequestDto {
    /**
     * 1.订单编号，占用库存时传递。
     * 2.扣减库存只传递OrderNo
     * 3.取消库存只传递OrderNo
     */
    @NotEmpty
    private String orderNo;
    /**
     * 商品信息 商品编码，商品数量
     */
    private Map<String,Integer> goods;

    /**
     * 取消库存商品编码列表
     */
    private List<String> cancelGoodList;
}
