package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDate;
import java.util.List;

/**
 * 后台管理服务商备付金扣款记录查询条件
 * @author djt
 * @date 2021/9/22
 */
@Data
@Accessors(chain = true)
public class AdminDownOrderPayLogReq {

    /**
     * 服务商编号
     */
    private String deductionAgentCode;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 发放主体编号集合
     */
    private List<String> issuingBodyCodes;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 下单业务号
     */
    private String businessCode;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 服务商支付开始日期
     */
    private String agentPayStartDate;

    /**
     * 服务商支付结束日期
     */
    private String agentPayEndDate;

    /**
     * 服务商退款开始日期
     */
    private String agentRefundStartDate;

    /**
     * 服务退款结束日期
     */
    private String agentRefundEndDate;

    private int page = 1;

    private int limit=10;

}
