package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:代驾券第三方下单单条更新DTO </dd>
 * <dd>@date: 2021/03/10</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode()
@Accessors(chain = true)
public class ScmDingJuDrivingOrderUpdateParamDto {
    /**
     * 订单编号
     */
    private String orderCode;
    /**
     * 子订单编号
     */
    @NotBlank
    private String orderItemCode;
    /**
     * 子订单状态
     */
    private String orderItemStatus;

    /**
     * 结果的信息，比如调用失败的错误信息
     */
    private String resultInfo;

    /**
     * 对应鼎聚返回的：就是 pwNo (权益编号)
     */
    private String thirdBusinessCode;

    /**
     * 真是的第三方业务状态
     */
    private String thirdBusinessStatus;

    /**
     * 执行调用时间
     */
    private LocalDateTime doTime;

}
