package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 订单核销状态，更新状态
 * @author：liangyongtong
 * @since：2021/3/18
 */
@Data
@Accessors(chain = true)
public class WriteOffDto implements Serializable {

    /**
     * 子订单编码
     */
    private String orderItemCode;

    /**
     * 套餐明细订单号
     */
    private String comboOrderItemCode;

    /**
     * 第三方券号,例如鼎聚返回鼎powerNo
     */
    private String thirdBusinessCode;

    /**
     * ROCO车服用户券号,如果仅传入用户券编号，则根据上游订单发放的用户券编号来更新核销状态（C端壳牌加油使用抵扣券后核销关联的上游订单）
     */
    private String rocoUserCouponCode;


    /**
     * 是否更新上游订单的使用状态为已使用，如果是壳牌加油,核销抵扣券，则把抵扣的券的上游订单的使用状态更新为已使用
     * （1）因为目前壳牌的抵扣券 是ROCO牌的，并且只能是 抵扣券全额使用，目前的抵扣券的产品类型是：油卡（OIL_CARD_DIGITAL 或OIL_CARD_DIGITAL_YES）
     *  (2) 消费券 支付宝红包 更新为已使用
     */
    private Boolean updateOrderItemUsed;
}
