package com.rocogz.merchant.dto.scm.didi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 滴滴打车查询券请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2023-04-24 15:28:59</dd>
 * <dd>@author：zhangmin</dd>
 * </dl>
 */
@Setter
@Getter
@Accessors(chain = true)
public class DiDiRspDto {

    /**
     * roco用户券编码
     */
    private String userCouponCode;

    /**
     * 嘀嘀打车优惠券id
     */
    private String couponId;

    /**
     * 券状态
     * 1:已消费; 2:绑定; 3:冻结; 4:退还; 6:解绑; 7:待激活
     */
    private String status;


    @JsonIgnore
    public boolean isUsed() {
        return "1".equals(status);
    }
}
