package com.rocogz.merchant.dto.scm.order;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import com.rocogz.merchant.entity.scm.MerchantScmProductInformation;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 撤回下游订单中,包括的上游订单
 *
 * @author zhangmin
 */
@Setter
@Getter
@NoArgsConstructor
@Accessors(chain = true)
public class RecallScmOrderItem {

    /**
     * 上游订单编号
     */
    private String scmOrderItemCode;


    /**
     * 上游订单状态
     *
     * @see MerchantScmOrderDetail#orderStatus
     * @see Constant.DictData#SCM_ORDER_STATUS_PENDING
     */
    private String orderItemStatus;

    /**
     * 上游订单中的产品 产品性质：单品还是套餐
     *
     * @see Constant.DictData#GOODS_NATURE_ITEM
     * @see MerchantScmProductInformation#productNature
     */
    private String productNature;


    /**
     * 上游订单的对应的 第三方业务单号
     *
     * @see MerchantScmOrderDetail#thirdBusinessCode
     */
    private String thirdBusinessCode;


    /**
     * 上游订单中的产品的产品类型
     *
     * @see MerchantScmOrderDetail#productType
     */
    private String productType;

    /**
     * 上游订单的 产品的品牌
     *
     * @see MerchantScmProductInformation#brandCode
     * @see MerchantBrand#DIDI
     */
    private String brandCode;



    public static RecallScmOrderItem of(MerchantScmOrderDetail orderDetail) {
        if (orderDetail == null) {
            return null;
        }

        RecallScmOrderItem orderItem = new RecallScmOrderItem();

        orderItem.setOrderItemStatus(orderDetail.getOrderStatus())
                .setScmOrderItemCode(orderDetail.getOrderItemCode())
                .setProductNature(orderDetail.getGoodsNature())
                .setProductType(orderDetail.getProductType())
                .setThirdBusinessCode(orderDetail.getThirdBusinessCode())
                .setBrandCode(orderDetail.getBrandCode());

        return orderItem;
    }

}
