package com.rocogz.merchant.dto.scm.order;

import com.rocogz.merchant.entity.agent.goods.MerchantAgentGoods;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.merchant.entity.scm.MerchantScmInformation;
import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import com.rocogz.merchant.entity.scm.MerchantScmProductInformation;
import com.rocogz.merchant.entity.scm.MerchantScmTargetUser;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 后台发放/B端发放的实试商品, 创建实物订单消息实体
 * @author djt
 * @date 2022/2/21
 */
@Data
@Accessors(chain = true)
public class ScmGoodOrderMsgDTO {


    /**
     * 供应链订单编号
     * @see MerchantScmOrderDetail#orderCode
     */
    private String orderCode;

    /**
     * 清单编号
     * @see MerchantScmInformation#businessCode
     */
    private String businessCode;

    /**
     * 发放主体编号
     * @see MerchantScmInformation#sourceCode
     */
    private String issuingBodyCode;


    /**
     * 客户产品所属合作客户编号
     * @see MerchantScmProductInformation#customerProductBelongCustomer
     */
    private String belongCustomerCode;

    /**
     * 明细订单编号
     * @see MerchantScmOrderDetail#orderItemCode
     */
    private String orderItemCode;


    /**
     * 投放平台miniAppId
     * @see MerchantScmInformation#targetMiniAppid
     */
    private String miniAppId;

    /**
     * 平台产品
     */
    private MerchantGoods merchantGoods;

    /**
     * 服务商产品
     */
    private MerchantAgentGoods agentGoods;


    /**
     * 客户产品采购结算单价
     * @see MerchantScmProductInformation#customerPurchaseSettlePrice
     */
    private BigDecimal customerPurchaseSettlePrice;

    /**
     * 商品数量
     * @see MerchantScmOrderDetail#grantNum
     */
    private Integer num;

    /**
     * 尝试次数
     */
    private Integer retryNum;

    /**
     * 备注
     */
    private String remark;

    /**
     * 领取人手机号
     * @see MerchantScmTargetUser#grantMobile
     */
    private String targetUserMobile;

    /**
     * 创建人，即清单创建人用户名
     * @see  MerchantScmInformation#createUser
     */
    private String createUser;

}
