package com.rocogz.merchant.dto.scm.qiaopai.resp;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author 尹世豪
 * @Description: 油站信息
 * @Package com.rocoinfo.service.remote.dto.qiaopai.resp
 * @date 2022/7/28 19:18
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class QiaoPaiOilStationInfo {
    /**
     * 油站编码(必有)
     */
    private String stationCode;
    /**
     * 油站名称(必有)
     */
    private String stationName;
    /**
     * 油站地址(非必有)
     */
    private String stationAddress;
    /**
     * 省份名称(非必有)
     */
    private String provinceName;
    /**
     * 城市名称(非必有)
     */
    private String cityName;
    /**
     * 区县名称(非必有)
     */
    private String districtName;
    /**
     * 区县编码(非必有)
     */
    private String districtId;
    /**
     * 油站经度(非必有, 腾讯坐标系)
     */
    private String longitude;
    /**
     * 油站纬度(非必有, 腾讯坐标系)
     */
    private String latitude;
    /**
     * 油站状态(非必有)
     * ABLE	启用
     * DIEABLE	禁用
     * DELETE	删除
     */
    private String status;
    /**
     * 营业开始时间(00:05:00, 非必有)
     */
    private String businessStartTime;
    /**
     * 营业结束时间(23:54:59 非必有)
     */
    private String businessEndTime;
    /**
     * 油价列表(非必有)
     */
    private List<QiaoPaiOilPrice> oilPriceList;
}
