package com.rocogz.merchant.entity.areaservice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 专区服务项目关联的专区表
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantAreaServiceRelate extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 专区服务项目编码
     */
    private String areaServiceCode;

    /**
     * 专区编码
     */
    private String areaCode;

    /**
     * 专区名称
     */
    private String areaName;


}
