package com.rocogz.merchant.entity.customer.workflow.apply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.enumerate.CustomerGoodsConfigNodeTypeEnum;
import com.rocogz.merchant.enumerate.InstoreApplyActionTypeEnum;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/7/19 16:31</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("merchant_customer_goods_instore_apply_progress")
public class GoodsInstoreApplyProgress extends IdEntity {

    /**
     * 申请单编码
     */
    private String applyCode;

    /**
     * 操作名称：例如：提交申请,一级审批
     */
    private String actionName;

    /**
     * 操作类型：例如 保存草稿， 提交申请，审批，审核，作废
     *
     * @see InstoreApplyActionTypeEnum#name()
     */
    private String actionType;

    /**
     * 操作结果, 通过或不通过
     *
     * @see Constant.GoodsInstoreApplyApproveResult
     */
    private String actionResult;

    /**
     * 流程节点编号
     */
    private String nodeCode;

    /**
     * 操作批注(审批意见)
     */
    private String remark;

    /**
     * 操作人类型：申请人、操作人、撤回人
     */
    private String userType;

    /**
     * 操作人用户名
     */
    private String userName;

    /**
     * 操作人手机号
     */
    private String userMobile;

    /**
     * 操作人姓名
     */
    private String userFullName;

    /**
     * 操作时间
     */
    private LocalDateTime actionTime;

    /**
     * 该审批节点 包括的附件数量
     */
    private Integer attachNum;

    /**
     * 审批记录Id
     */
    private Integer approveRecordId;

    /**
     * 操作是否发生
     */
    private Boolean happened;

    /**
     * 审批节点类型：审核/审批/复核
     * 流程图显示用
     */
    @TableField(exist = false)
    private CustomerGoodsConfigNodeTypeEnum nodeType;

    /**
     * 当前节点审批人，主要针对未发生的节点，即happened未false的时候
     * 流程图显示用
     */
    @TableField(exist = false)
    private List<GoodsInstoreApplyRuntimeNodeApprover> approvers;

    /**
     * 构建未发生的操作人信息
     * 流程图显示用
     *
     * @return
     */
    @JsonProperty
    public String getNotHappenedOperator() {
        if (happened || nodeType == null || CollectionUtils.isEmpty(approvers)) {
            return StringUtils.EMPTY;
        }
        String approverStr = approvers.stream().map(GoodsInstoreApplyRuntimeNodeApprover::getApproverName).collect(Collectors.joining("/"));
        return nodeType.getLabel() + "人（" + approverStr + "）";
    }
}
