package com.rocogz.merchant.entity.exchangeGoodsPoints;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.agent.goods.MerchantAgentGoods;
import com.rocogz.merchant.entity.goods.MerchantGoods;

import java.math.BigDecimal;

import com.rocogz.merchant.entity.product.MerchantProductType;
import com.rocogz.merchant.entity.scmWarehouse.MerchantScmStock;
import com.rocogz.merchant.entity.scmWarehouse.MerchantScmWarehouse;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2021-05-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantExchangeGoodsPoints extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编码
     */
    private String code;

    /**
     * 代理商产品code
     */
    private String agentGoodsCode;

    /**
     * 积分商城产品名称
     */
    private String name;

    /**
     * 兑换积分（单个产品）
     */
    private BigDecimal exchangePoints;

    /**
     * 位置值
     */
    private Integer sort;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态 上架：UP_LIST，下架：DOWN_LIST
     * @see Constant.DictData#MERCHANT_STORE_STATUS_UP_LIST
     */
    private String status;

    /**
     * 平台appid
     */
    private String miniAppid;

    /**
     * 平台名称-为了排序
     */
    private String miniAppidName;

    /**
     * 代理商产品-产品类型 这个名字起的真是让人无语
     *
     * @see MerchantProductType#name
     */
    @TableField(exist = false)
    private String agentProductName;

    /**
     * 平台产品产品类别 对应到
     * @see MerchantGoods#goodsType
     */
    @TableField(exist = false)
    private String goodsType;

    /**
     * 平台产品产品类别 名称
     */
    @TableField(exist = false)
    private String goodsTypeName;

    /**
     * 代理商产品-产品面额/价值
     * @see MerchantAgentGoods#marketPrice
     */
    @TableField(exist = false)
    private BigDecimal marketPrice;

    /**
     * 代理商产品-建议积分兑换值
     */
    @TableField(exist = false)
    private BigDecimal suggestExchangePointValue;

    /**
     * 代理商产品-代理商产品名称
     */
    @TableField(exist = false)
    private String agentGoodsName;

    /**
     * 代理商产品-代理商额度扣减单价
     * @see MerchantAgentGoods#purchasePrice
     */
    @TableField(exist = false)
    private BigDecimal purchasePrice;

    /**
     * 采购结算单价
     * @see MerchantAgentGoods#purchaseSettlePrice
     */
    @TableField(exist = false)
    private BigDecimal purchaseSettlePrice;

    /**
     * 代理商产品-代理商产品状态
     */
    @TableField(exist = false)
    private String agentGoodsStatus;

    /**
     * 代理商产品-所属代理商
     */
    @TableField(exist = false)
    private String agentName;

    /**
     * 代理商编号
     */
    @TableField(exist = false)
    private String agentCode;

    @TableField(exist = false)
    private MerchantGoods MerchantGoods;

    /**
     * 分销仓库编号
     * @see MerchantScmWarehouse#code
     */
    private String whCode;

    /**
     * 分销仓库中库存的唯一标示号
     * @see MerchantScmStock#stockSno
     */
    private String stockSno;

    /**
     * 平台产品编号
     * 场景：1.在新增产品时如果平台产品启用了库存
     */
    @TableField(exist = false)
    private String platformGoodsCode;

}
