package com.rocogz.merchant.entity.industry;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;

/**
 * <p>
 *  商户行业
 * </p>
 *
 * @author yinshihao
 * @since 2020-04-02
 */
@TableName(value = "merchant_industry")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class MerchantIndustry extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 行业编号
     */
    private String code;

    /**
     * 行业名称
     */
    private String name;

    /**
     * 行业简称
     */
    private String abbreviation;

    /**
     * 行业说明
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String description;
}
