package com.rocogz.merchant.entity.scm;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 明细订单对应的交易类型关系
 * </p>
 *
 * @author yinshihao
 * @since 2021-04-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmOrderDetailTrade extends IdEntity {

    private static final long serialVersionUID = 165080799005195843L;
    /**
     * 明细订单编码
     */
    private String orderItemCode;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 交易流水号
     */
    private String tradeFlowCode;

    /**
     * 交易时间
     */
    private LocalDateTime tradeTime;


}
