package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.entity.attechment.MerchantAttechment;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 过期补发申请表
 * </p>
 *
 * @author yinshihao
 * @since 2022-03-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmReissueApply extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 申请类型(REISSUE:补发、DELAY_RECEIVE:领取有效期延期、DELAY_USE:使用有效期延期)
     */
    private String applyType;

    /**
     * 申请单审核状态(PENDING:待审批、PASS:审批通过、REFUSE:审批不通过、FAIL:处理失败、PART_FAIL:部分失败、PROCESSED:已处理)
     */
    private String status;

    /**
     * 新的下游订单编号
     */
    private String newDownOrderCode;

    /**
     * 申请时间
     */
    private LocalDateTime applyTime;

    /**
     * 申请人账号
     */
    private String applyUser;

    /**
     * 申请人手机号
     */
    private String applyUserMobile;

    /**
     * 审核人
     */
    private String examineUser;

    /**
     * 审核时间
     */
    private LocalDateTime examineTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 申请备注
     */
    private String applyRmk;

    /**
     * 审核描述
     */
    private String examineDescription;

    /**
     * 补发总金额
     */
    private BigDecimal reissueTotalAmount;

    /**
     * 延期/补发总张数
     */
    private Integer totalQuantity;

    /**
     * 过期补发申请明细列表
     */
    @TableField(exist = false)
    private List<MerchantScmReissueApplyDetail> reissueApplyDetailList;

    /**
     * 撤回操作人
     */
    private String withdrawUser;

    /**
     * 发放会员手机号
     */
    private String mobile;

    /**
     * 撤回时间
     */
    private LocalDateTime withdrawTime;

    @TableField(
            exist = false
    )
    private List<MerchantAttechment> attachmentList;


}
