package com.rocogz.merchant.entity.store;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商户结算信息
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreSettlement extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 结算方编码
     */
    private String settlementCode;

    /**
     * 结算方名称
     */
    private String settlementName;

    /**
     * 账号名称
     */
    private String accountName;

    /**
     * 银行账号
     */
    private String bankAccount;

    /**
     * 开户银行
     */
    private String depositBank;

    /**
     * 开户行
     */
    private String openingBank;


}
