package com.rocogz.merchant.request.validity;

import com.rocogz.merchant.request.log.OperationReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author djt
 * @date 2021/11/17
 */
@Data
public class ChangeStatusReq implements OperationReq {

    @NotBlank
    private String code;

    @NotBlank
    private String status;

    @NotBlank
    private String operationUserName;

    @NotNull
    private Integer operationUserId;


    @Override
    public String getOperationName() {
        return this.operationUserName;
    }

    @Override
    public Integer getOperationId() {
        return this.operationUserId;
    }
}
