/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.message.server.equity.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.rabbitmq.client.Channel;
import com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCouponRequestRecord;
import com.rocogz.syy.message.server.equity.dto.CallOilCardDto;
import com.rocogz.syy.message.server.equity.service.OilCardUserCouponService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OilCardUserCouponMqConsume {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OilCardUserCouponService oilCardUserCouponService;

    @RabbitListener(queues={"EQUITY_OIL_CARD_USER_COUPON"})
    public void grantUserCouponConsume(Message message, Channel channel) {
        try {
            String req = new String(message.getBody());
            this.logger.info("======>>>\u6cb9\u5361\u53d1\u5238\u5f00\u59cb\u6d88\u8d39:{}", (Object)req);
            EquityOilCardUserCouponRequestRecord msgEntity = (EquityOilCardUserCouponRequestRecord)JSON.parseObject((String)req, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            boolean retFlag = this.oilCardUserCouponService.grantUserCoupon(msgEntity);
            if (retFlag) {
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
                this.logger.info("======>>>\u6cb9\u5361\u53d1\u5238\u6d88\u8d39\u6210\u529f:{}", (Object)msgEntity.getOilOrderCode());
            } else {
                channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, true);
                this.logger.error("======>>>\u6cb9\u5361\u53d1\u5238\u5931\u8d25\uff0c\u6d88\u606f\u91cd\u65b0\u653e\u56de\u961f\u5217");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("======>>>\u6cb9\u5361\u53d1\u5238\u653e\u5165\u961f\u5217\u5f02\u5e38:{}", (Throwable)e);
        }
    }

    @RabbitListener(queues={"EQUITY_OIL_CARD_RESULT_CALL"})
    public void callOilCardResultConsume(Message message, Channel channel) {
        try {
            String req = new String(message.getBody());
            CallOilCardDto callOilCardDto = (CallOilCardDto)JSON.parseObject((String)req, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            this.logger.info("======>>>\u53d1\u5238\u7ed3\u679c\u901a\u77e5\u5f00\u59cb\u6d88\u8d39:{}, {}", (Object)callOilCardDto.getOrderNo(), (Object)callOilCardDto.getMobile());
            this.oilCardUserCouponService.callOilCardResultConsume(callOilCardDto);
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RabbitListener(queues={"EQUITY_OIL_CARD_EXCHANGE"})
    public void exchangeUserCoupon(Message message, Channel channel) {
        try {
            String req = new String(message.getBody());
            this.logger.info("======>>>\u4f18\u60e0\u5238\u5145\u503c\u8bf7\u6c42\u5f00\u59cb\u6d88\u8d39:{}", (Object)req);
            CallOilCardDto callOilCardDto = (CallOilCardDto)JSON.parseObject((String)req, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            boolean retFlag = this.oilCardUserCouponService.exchangeUserCoupon(callOilCardDto);
            if (retFlag) {
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            } else {
                channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("======>>>\u4f18\u60e0\u5238\u5145\u503c\u653e\u5165\u961f\u5217\u5f02\u5e38:{}", (Throwable)e);
        }
    }

    @RabbitListener(queues={"EQUITY_OIL_CARD_EXCHANGE_RESULT"})
    public void exchangeResult(Message message, Channel channel) {
        try {
            String req = new String(message.getBody());
            this.logger.info("======>>>\u5145\u503c\u7ed3\u679c\u5f00\u59cb\u6d88\u8d39:{}", (Object)req);
            EquityOilCardUserCouponRequestRecord recordEntity = (EquityOilCardUserCouponRequestRecord)JSON.parseObject((String)req, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            boolean retFlag = this.oilCardUserCouponService.exchangeResult(recordEntity);
            if (retFlag) {
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            } else {
                channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("======>>>\u5145\u503c\u7ed3\u679c\u653e\u5165\u961f\u5217\u5f02\u5e38:{}", (Throwable)e);
        }
    }
}

