/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.message.server.equity.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.rocogz.redis.RedisService;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCoupon;
import com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCouponRequestRecord;
import com.rocogz.syy.infrastructure.entity.dockingPlatform.DockingPlatform;
import com.rocogz.syy.message.server.client.IEquityClientInterfaceService;
import com.rocogz.syy.message.server.client.IInfrastructureClientInterfaceService;
import com.rocogz.syy.message.server.client.IOilCardClientService;
import com.rocogz.syy.message.server.config.equity.PlatInfoConfig;
import com.rocogz.syy.message.server.config.equity.SecretKeyConfig;
import com.rocogz.syy.message.server.equity.dto.CallOilCardDto;
import com.rocogz.syy.message.server.equity.dto.RequestOilCardDto;
import com.rocogz.syy.message.server.equity.dto.TokenRequestDto;
import com.rocogz.syy.message.server.equity.dto.TokenResponseDto;
import com.rocogz.syy.message.server.util.RSAUtil;
import com.rocogz.syy.message.server.util.SignatureUtil;
import com.rocogz.syy.rabbitmq.RabbitMqService;
import com.rocogz.util.DateUtil;
import com.rocogz.util.aes.AESUtil;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class OilCardUserCouponService {
    private static final Logger log = LoggerFactory.getLogger(OilCardUserCouponService.class);
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInfrastructureClientInterfaceService infrastructureClientInterfaceService;
    @Autowired
    private IEquityClientInterfaceService iEquityClientInterfaceService;
    @Autowired
    private IOilCardClientService iOilCardClientService;
    @Autowired
    private PlatInfoConfig platInfoConfig;
    @Autowired
    private SecretKeyConfig secretKeyConfig;
    @Autowired
    private RabbitMqService rabbitMqService;
    @Autowired
    private RedisService redisService;

    public boolean checkOrderIsExistByOrderCode(String orderCode, String type) {
        EquityOilCardUserCouponRequestRecord equityOilCardUserCouponRequestRecord = (EquityOilCardUserCouponRequestRecord)this.iEquityClientInterfaceService.checkOrderIsExistByOrderCode(orderCode, type).getData();
        return !Objects.isNull(equityOilCardUserCouponRequestRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean grantUserCoupon(EquityOilCardUserCouponRequestRecord entity) {
        String orderCode = entity.getOilOrderCode();
        if (this.redisService.tryLock(orderCode, 30L, TimeUnit.SECONDS)) {
            try {
                boolean isExist = this.checkOrderIsExistByOrderCode(entity.getOilOrderCode(), "ADD");
                if (isExist) return true;
                Response response = this.iEquityClientInterfaceService.saveOilCardRequestRecord(entity);
                if ("000000".equals(response.getCode())) {
                    EquityOilCardUserCoupon oilCardUserCoupon = (EquityOilCardUserCoupon)response.getData();
                    CallOilCardDto callOilCardDto = new CallOilCardDto();
                    callOilCardDto.setMobile(oilCardUserCoupon.getMobile());
                    callOilCardDto.setAmount(String.valueOf(oilCardUserCoupon.getOrderAmount().setScale(3)));
                    callOilCardDto.setOrderNo(oilCardUserCoupon.getOilOrderCode());
                    callOilCardDto.setUserCouponCode(oilCardUserCoupon.getCode());
                    callOilCardDto.setEffectTime(DateUtil.formatLocalDateTimeToString((LocalDateTime)oilCardUserCoupon.getEffectiveDate()));
                    callOilCardDto.setExpireTime(DateUtil.formatLocalDateTimeToString((LocalDateTime)oilCardUserCoupon.getInvalidDate()));
                    this.rabbitMqService.sendMessage("EQUITY_COMMON_EXCHANGES", "EQUITY_OIL_CARD_RESULT_CALL", JSON.toJSONString((Object)callOilCardDto));
                    return true;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                this.redisService.unLock(orderCode);
            }
        } else {
            this.logger.error("====>>>\u8ba2\u5355\u53f7\u91cd\u590d\u8bf7\u6c42\u53d1\u5238:{}", (Object)orderCode);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean callOilCardResultConsume(CallOilCardDto callOilCardDto) {
        String rmk;
        String resultStatus;
        block7: {
            resultStatus = null;
            rmk = null;
            try {
                String token = this.getToken(callOilCardDto.getOrderNo());
                this.logger.info("====>>>\u8c03\u7528\u6cb9\u5361\u7cfb\u7edf\u83b7\u53d6token\u7ed3\u679c:{}, {}", (Object)callOilCardDto.getOrderNo(), (Object)token);
                if (StringUtils.isNotBlank((CharSequence)token)) {
                    DockingPlatform dockingPlatform = (DockingPlatform)this.infrastructureClientInterfaceService.getDockingPlatformByCode(this.platInfoConfig.getOilToSyyPlatformCode(), null).getData();
                    RequestOilCardDto oilCardRequestDto = new RequestOilCardDto();
                    oilCardRequestDto.setData(AESUtil.encrypt((String)JSON.toJSONString((Object)callOilCardDto), (String)dockingPlatform.getPlatformSecretKey(), (String)dockingPlatform.getPlatformIv()));
                    oilCardRequestDto.setSign(AESUtil.encrypt((String)this.generateSignature(callOilCardDto), (String)dockingPlatform.getPlatformSecretKey(), (String)dockingPlatform.getPlatformIv()));
                    this.logger.info("====>>>\u8c03\u7528\u6cb9\u5361\u7cfb\u7edf\u7ed3\u679c\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\uff1a{}, {}, {}", new Object[]{callOilCardDto.getOrderNo(), token, JSON.toJSONString((Object)oilCardRequestDto)});
                    String resultStr = this.iOilCardClientService.callBack(token, JSON.toJSONString((Object)oilCardRequestDto));
                    this.logger.info("====>>>\u8c03\u7528\u6cb9\u5361\u7cfb\u7edf\u7ed3\u679c\u901a\u77e5\u54cd\u5e94\uff1a{}, {}", (Object)callOilCardDto.getOrderNo(), (Object)resultStr);
                    JSONObject jsonObject = JSON.parseObject((String)resultStr);
                    if ("1".equals(jsonObject.get((Object)"code").toString())) {
                        resultStatus = "PROCESS";
                    } else {
                        resultStatus = "FAIL";
                        rmk = jsonObject.get((Object)"code").toString() + jsonObject.get((Object)"message").toString();
                    }
                    break block7;
                }
                resultStatus = "FAIL";
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    this.logger.error("======>>>\u7ed3\u679c\u901a\u77e5\u5f02\u5e38{}", (Throwable)e);
                    resultStatus = "FAIL";
                    rmk = e.getMessage();
                }
                catch (Throwable throwable) {
                    this.iEquityClientInterfaceService.updateOperateSerial(callOilCardDto.getOrderNo(), "ADD", resultStatus, rmk);
                    throw throwable;
                }
                this.iEquityClientInterfaceService.updateOperateSerial(callOilCardDto.getOrderNo(), "ADD", resultStatus, rmk);
            }
        }
        this.iEquityClientInterfaceService.updateOperateSerial(callOilCardDto.getOrderNo(), "ADD", resultStatus, rmk);
        return true;
    }

    public boolean exchangeUserCoupon(CallOilCardDto callOilCardDto) {
        return false;
    }

    public boolean exchangeResult(EquityOilCardUserCouponRequestRecord recordEntity) {
        try {
            Response response = this.iEquityClientInterfaceService.updateOilCardUserCoupon(recordEntity.getOilOrderCode(), "IN_EXCHANGE", "USED");
            if ("000000".equals(response.getCode())) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public String generateSign(String platformCode, String platformKey, String uuid) {
        return RSAUtil.buildRSASignByPrivateKey((String)(platformCode + platformKey + uuid), (String)this.secretKeyConfig.getPrivateKey());
    }

    private String generateSignature(CallOilCardDto record) {
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"mobile", (Object)record.getMobile());
        param.add((Object)"amount", (Object)String.valueOf(record.getAmount()));
        param.add((Object)"orderNo", (Object)record.getOrderNo());
        param.add((Object)"userCouponCode", (Object)record.getUserCouponCode());
        param.add((Object)"couponType", (Object)record.getCouponType());
        param.add((Object)"effectTime", (Object)record.getEffectTime());
        param.add((Object)"expireTime", (Object)record.getExpireTime());
        String signStr = SignatureUtil.signatureStr((MultiValueMap)param);
        this.logger.info("====>>>\u751f\u6210\u56de\u8c03\u6cb9\u5361\u7684\u53c2\u6570\u7b7e\u540d:{}", (Object)signStr);
        return RSAUtil.buildRSASignByPrivateKey((String)signStr, (String)this.secretKeyConfig.getPrivateKey());
    }

    public String getToken(String orderNo) {
        String token = null;
        try {
            token = this.redisService.get("OIL_CARD_TOKEN");
        }
        catch (Exception e) {
            this.logger.error("====>>>\u8fde\u63a5redis\u83b7\u53d6\u6cb9\u5361token\u5931\u8d25:{}, {}", (Object)orderNo, (Object)e);
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            DockingPlatform dockingPlatform = (DockingPlatform)this.infrastructureClientInterfaceService.getDockingPlatformByCode(this.platInfoConfig.getOilToSyyPlatformCode(), null).getData();
            String key = dockingPlatform.getPlatformSecretKey();
            String iv = dockingPlatform.getPlatformIv();
            String uuid = UUID.randomUUID().toString();
            HashMap<String, String> uuidParam = new HashMap<String, String>();
            uuidParam.put("uuid", uuid);
            TokenRequestDto tokenRequestDto = new TokenRequestDto();
            try {
                tokenRequestDto.setPlatFormCode(this.platInfoConfig.getSyyToOilPlatformCode());
                tokenRequestDto.setData(AESUtil.encrypt((String)JSON.toJSONString(uuidParam), (String)key, (String)iv));
                tokenRequestDto.setSign(AESUtil.encrypt((String)this.generateSign(dockingPlatform.getCode(), key, uuid), (String)key, (String)iv));
                HashMap reqToken = new HashMap();
                this.logger.info("======>>>\u8c03\u7528\u6cb9\u5361\u83b7\u53d6token\u8bf7\u6c42\u53c2\u6570:{}, {}, {}", new Object[]{orderNo, uuid, JSON.toJSONString((Object)tokenRequestDto)});
                String retObject = this.iOilCardClientService.getToken(JSON.toJSONString((Object)tokenRequestDto));
                this.logger.info("======>>>\u8c03\u7528\u6cb9\u5361\u83b7\u53d6token\u54cd\u5e94\u7ed3\u679c:{}, {}, {}", new Object[]{orderNo, uuid, retObject});
                JSONObject jsonObject = JSONObject.parseObject((String)retObject);
                if ("1".equals(jsonObject.get((Object)"code").toString())) {
                    TokenResponseDto tokenDto = (TokenResponseDto)JSONObject.parseObject((String)AESUtil.decrypt((String)jsonObject.get((Object)"data").toString(), (String)key, (String)iv), TokenResponseDto.class);
                    token = tokenDto.getAccessToken();
                    this.redisService.set("OIL_CARD_TOKEN", token, Long.parseLong(tokenDto.getExpireTime()), TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("====>>>\u8bbe\u7f6etoken\u5230redis\u5f02\u5e38:{}, {}", (Object)orderNo, (Object)e);
            }
        }
        return token;
    }
}

