/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.message.server.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RSAUtil {
    public static final String CHARSET = "UTF-8";
    public static final String ALGORITHM_RSA = "RSA";
    public static final String ALGORITHM_RSA_SIGN = "SHA256WithRSA";
    public static final int ALGORITHM_RSA_PRIVATE_KEY_LENGTH = 2048;

    private RSAUtil() {
    }

    public static Map<String, String> initRSAKey(int keysize) {
        KeyPairGenerator kpg;
        if (keysize != 2048) {
            throw new IllegalArgumentException("RSA1024\u5df2\u7ecf\u4e0d\u5b89\u5168\u4e86,\u8bf7\u4f7f\u75282048\u521d\u59cb\u5316RSA\u5bc6\u94a5\u5bf9");
        }
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm-->[RSA]");
        }
        kpg.initialize(2048);
        KeyPair keyPair = kpg.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        String publicKeyStr = Base64.getEncoder().encodeToString(publicKey.getEncoded());
        PrivateKey privateKey = keyPair.getPrivate();
        String privateKeyStr = Base64.getEncoder().encodeToString(privateKey.getEncoded());
        HashMap<String, String> keyPairMap = new HashMap<String, String>();
        keyPairMap.put("publicKey", publicKeyStr);
        keyPairMap.put("privateKey", privateKeyStr);
        return keyPairMap;
    }

    public static String buildRSAEncryptByPublicKey(String data, String key) {
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(key));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicKey);
            return Base64.getEncoder().encodeToString(RSAUtil.rsaSplitCodec((Cipher)cipher, (int)1, (byte[])data.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String buildRSADecryptByPublicKey(String data, String key) {
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(key));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, publicKey);
            return new String(RSAUtil.rsaSplitCodec((Cipher)cipher, (int)2, (byte[])Base64.getDecoder().decode(data)), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String buildRSAEncryptByPrivateKey(String data, String key) {
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(key));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, privateKey);
            return Base64.getEncoder().encodeToString(RSAUtil.rsaSplitCodec((Cipher)cipher, (int)1, (byte[])data.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String buildRSADecryptByPrivateKey(String data, String key) {
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(key));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateKey);
            return new String(RSAUtil.rsaSplitCodec((Cipher)cipher, (int)2, (byte[])Base64.getDecoder().decode(data)), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String buildRSASignByPrivateKey(String data, String key) {
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(key));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(privateKey);
            signature.update(data.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static boolean buildRSAverifyByPublicKey(String data, String key, String sign) {
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(key));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(publicKey);
            signature.update(data.getBytes("UTF-8"));
            return signature.verify(Base64.getDecoder().decode(sign));
        }
        catch (Exception e) {
            throw new RuntimeException("\u9a8c\u7b7e\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas) {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? 256 : 245;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u89e3\u5bc6\u9600\u503c\u4e3a[" + maxBlock + "]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
        byte[] resultDatas = out.toByteArray();
        IOUtils.closeQuietly((OutputStream)out);
        return resultDatas;
    }
}

