/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.message.server.equity.service;

import com.rocogz.redis.RedisService;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCoupon;
import com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCouponRequestRecord;
import com.rocogz.syy.message.server.client.IEquityClientInterfaceService;
import com.rocogz.syy.message.server.client.IInfrastructureClientInterfaceService;
import com.rocogz.syy.message.server.client.InterfaceAggregateClientService;
import com.rocogz.syy.message.server.equity.dto.CallOilCardDto;
import com.rocogz.syy.rabbitmq.RabbitMqService;
import com.rocogz.util.DateUtil;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class OilCardUserCouponService {
    private static final Logger log = LoggerFactory.getLogger(OilCardUserCouponService.class);
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInfrastructureClientInterfaceService infrastructureClientInterfaceService;
    @Autowired
    private InterfaceAggregateClientService interfaceAggregateClientService;
    @Autowired
    private IEquityClientInterfaceService iEquityClientInterfaceService;
    @Autowired
    private RabbitMqService rabbitMqService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private ThreadPoolTaskExecutor executorService;

    public boolean checkOrderIsExistByOrderCode(String orderCode, String type) {
        EquityOilCardUserCouponRequestRecord equityOilCardUserCouponRequestRecord = (EquityOilCardUserCouponRequestRecord)this.iEquityClientInterfaceService.checkOrderIsExistByOrderCode(orderCode, type).getData();
        return !Objects.isNull(equityOilCardUserCouponRequestRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean grantUserCoupon(EquityOilCardUserCouponRequestRecord entity) {
        block9: {
            String orderCode = entity.getOilOrderCode();
            if (this.redisService.tryLock(orderCode, 30L, TimeUnit.SECONDS)) {
                try {
                    boolean isExist = this.checkOrderIsExistByOrderCode(entity.getOilOrderCode(), "ADD");
                    if (!isExist) {
                        Response response = this.iEquityClientInterfaceService.saveOilCardRequestRecord(entity);
                        if ("000000".equals(response.getCode())) {
                            EquityOilCardUserCoupon oilCardUserCoupon = (EquityOilCardUserCoupon)response.getData();
                            CallOilCardDto callOilCardDto = new CallOilCardDto();
                            callOilCardDto.setMobile(oilCardUserCoupon.getMobile());
                            callOilCardDto.setAmount(String.valueOf(oilCardUserCoupon.getOrderAmount().setScale(3)));
                            callOilCardDto.setOrderNo(oilCardUserCoupon.getOilOrderCode());
                            callOilCardDto.setRedeemCode(oilCardUserCoupon.getRedeemCode());
                            callOilCardDto.setEffectTime(DateUtil.formatLocalDateTimeToString((LocalDateTime)oilCardUserCoupon.getEffectiveDate()));
                            callOilCardDto.setExpireTime(DateUtil.formatLocalDateTimeToString((LocalDateTime)oilCardUserCoupon.getInvalidDate()));
                            callOilCardDto.setRetryQuantity(Integer.valueOf(0));
                            this.executorService.submit(() -> {
                                try {
                                    this.interfaceAggregateClientService.callBackOilCardResult(callOilCardDto);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.logger.error("====>>>\u5f02\u6b65\u8c03\u7528\u63a5\u53e3\u805a\u5408\u901a\u77e5\u6cb9\u5361\u53d1\u5238\u7ed3\u679c\u5931\u8d25:{}", (Throwable)e);
                                }
                            });
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    break block9;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.redisService.unLock(orderCode);
                }
            }
            this.logger.error("====>>>\u8ba2\u5355\u53f7\u91cd\u590d\u8bf7\u6c42\u53d1\u5238:{}", (Object)orderCode);
        }
        return true;
    }

    public boolean exchangeResult(EquityOilCardUserCouponRequestRecord recordEntity) {
        try {
            Response response = this.iEquityClientInterfaceService.updateOilCardUserCoupon(recordEntity.getOilOrderCode(), "IN_EXCHANGE", "USED");
            if ("000000".equals(response.getCode())) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

