/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.message.server.activity.service;

import com.rocogz.redis.RedisService;
import com.rocogz.syy.activity.entity.ActivityUserCouponReceiveInfo;
import com.rocogz.syy.common.exception.ServiceException;
import com.rocogz.syy.message.server.client.IActivityClientInterfaceService;
import io.seata.spring.annotation.GlobalTransactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityService {
    private static final Logger log = LoggerFactory.getLogger(ActivityService.class);
    @Autowired
    IActivityClientInterfaceService activityClientInterfaceService;
    @Autowired
    RedisService redisService;

    @GlobalTransactional(rollbackFor={Exception.class})
    public void saveInfoAndUpdateCouponConfig(ActivityUserCouponReceiveInfo userCouponReceiveInfo) throws ServiceException {
        this.activityClientInterfaceService.saveActivityUserCouponReceiveInfo(userCouponReceiveInfo);
        String redisKey = "ACTIVITY:RECEIVE_ONLINE:COUPON_CONFIG:" + userCouponReceiveInfo.getActivityCode() + userCouponReceiveInfo.getCouponCode();
        this.redisService.lock(redisKey, 60L);
        try {
            this.activityClientInterfaceService.incrActivityCouponConfigReceiveQuantity(userCouponReceiveInfo.getActivityCode(), userCouponReceiveInfo.getCouponCode());
        }
        finally {
            this.redisService.unLock(redisKey);
        }
    }
}

