package com.rocogz.account.api.entity.account.ext;

import com.rocogz.account.api.entity.account.Account;
import com.rocogz.account.api.enums.account.AccountTradeRecordType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author Andrew
 * @create 2020/4/8 5:20 下午
 */
@Getter
@Setter
@ToString
@EqualsAndHashCode(of = {"acctNo", "balance", "usedAmount", "frozenAmount", "transferAmount", "status", "recordType"})
public class UpdateAccountParam implements Serializable {

    // set
    
    /**
     * 余额
     */
    private BigDecimal balance;
    
    /**
     * 已用金额
     */
    private BigDecimal usedAmount;
    
    /**
     * 冻结金额
     */
    private BigDecimal frozenAmount;
    
    /**
     * 转出额度
     */
    private BigDecimal transferAmount;
    


    private String updateUser;
    private String updateName;
    private LocalDateTime updateTime;
    private LocalDate updateDate;

    //where

    private String acctNo;

    private String acctStatus;


    //after

    private AfterAccountAmount afterAccountAmount;
    
    
    //Transient
    
    @Transient
    private AccountTradeRecordType recordType;
    
    
    
}
