package com.rocogz.account.api.enums.account;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 账户事件
 *
 * @author Andrew
 * @create 2020/8/7
 */
@RequiredArgsConstructor
public enum AccountEventType {
    
    SYS_DECR("集成商收回"),
    
    SYS_ADD("集成商划拨"),
    
    TRANS_CHILD("划拨下级机构总账户"),
    
    TRANS_CHILD_BACK("收回下级机构总账户"),
    
    TRANS_DETAIL("划拨机构明细账户"),
    
    TRANS_DETAIL_BACK("收回机构明细账户"),
    
    GIFT_APPROVED("礼品发放审核"),
    
    GIFT_INVALID("礼品发放作废"),
    
    GIFT_RECHARGE("礼品发放"),
    
    GIFT_REVOKE("礼品发放撤回");
    
    @Getter
    private final String label;
    
    
}
