package com.rocogz.account.api.request.account.base;

import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;


/**
 * 顶级机构总账户开户
 */
@Data
@ToString(callSuper = true)
public class AccountOpenTopOrgReq extends AccountOpenCommonReq {

    /**
     * 集成商编码
     */
    @NotBlank(message = "集成商编码不能为空")
    private String integrationCode;

    /**
     * 集成商名称
     */
    @NotBlank(message = "集成商名称不能为空")
    private String integrationName;

    /**
     * 机构编码
     */
    @NotBlank(message = "机构编码不能为空")
    private String orgNo;

    /**
     * 机构名称
     */
    @NotBlank(message = "机构名称不能为空")
    private String orgName;
    
    /**
     * 机构代码
     */
    private String orgCode;

  
}