package com.rocogz.account.api.request.account.trade;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 划拨到通用账户
 * @author Andrew
 * @create 2020/8/18 3:00 下午
 */
@Data
public class AccountTransGeneralReq implements Serializable {
    
    @NotBlank
    private String acctNo;
    
    @NotBlank
    private String eventNo;
    
    @NotNull
    @Digits(integer = 999999999, fraction = 2)
    @DecimalMin("0.01")
    private BigDecimal amount;
    
    
    @Length(max = 1024)
    private String remark;
    
    
}
