package com.rocogz.account.api.entity.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.account.api.request.account.base.AccountOpenTopOrgReq;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author Andrew
 * @create 2020/8/7 2:52 下午
 */
@Data
@Table(name = "account_biz_ref")
public class AccountBizRef implements Serializable {

    @Id
    private Long id;


    /**
     * 账户编号
     */
    private String acctNo;

    /**
     * 集成商编码
     */
    private String integrationCode;

    /**
     * 集成商名称
     */
    private String integrationName;

    /**
     * 机构编码
     */
    private String orgNo;

    /**
     * 机构名称
     */
    private String orgName;
    
    /**
     * 机构代码
     */
    private String orgCode;
    
    /**
     * 上级机构编码
     */
    private String parentOrgNo;

    /**
     * 上级机构名称
     */
    private String parentOrgName;

    /**
     * 个人账号编码
     */
    private String personUserNo;

    /**
     * 个人名称
     */
    private String personUserName;

    /**
     * 个人手机号
     */
    private String personUserMobile;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 创建人id
     */
    private String createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人用户类型
     */
    @Column(name="create_usertype")
    private String createUsertype;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 修改日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate updateDate;

    /**
     * 修改人id
     */
    private String updateUser;

    /**
     *  修改人姓名
     */
    private String updateName;

    /**
     * 修改人用户类型
     */
    @Column(name="update_usertype")
    private String updateUsertype;



    public static AccountBizRef initAccountBizRef(AccountOpenTopOrgReq req){
        AccountBizRef accountBizRef = new AccountBizRef();
        accountBizRef.setIntegrationName(req.getIntegrationName());
        accountBizRef.setIntegrationCode(req.getIntegrationCode());
        accountBizRef.setOrgNo(req.getOrgNo());
        accountBizRef.setOrgName(req.getOrgName());
        accountBizRef.setOrgCode(req.getOrgCode());
        accountBizRef.setRemark(req.getRemark());
        return accountBizRef;
    }
}
