package com.rocogz.account.api.entity.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 账户交易请求日志(AccountTradeReqLog)实体类
 *
 * @author Andrew
 * @since 2020-04-08 15:34:09
 */
@Data
@Table(name = "account_trade_log")
public class AccountTradeLog implements Serializable {
    
    
    @Id
    private Long id;
    
    /**
     * 日志编号
     */
    private String logNo;
    
    /**
     * 事件编号
     */
    private String eventNo;
    
    /**
     * 事件类型
     */
    private String eventType;
    
    /**
     * 金额
     */
    private BigDecimal amount;
    
    /**
     * 账户编码
     */
    private String acctNo;
    
    /**
     * 目标账户编码
     */
    private String targetAcctNo;
    
    /**
     * 请求md5
     */
    private String reqMd5;
    
    /**
     * 请求参数
     */
    private String reqJson;
    
    /**
     * 响应json
     */
    private String resJson;
    
    
    /**
     * 结果
     */
    private String result;
    
    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;
    
    /**
     * 创建日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate createDate;
    
    /**
     * 更新时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;
    
    /**
     * 更新日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate updateDate;
    
    /**
     * 完成日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate finishDate;
    
    /**
     * 完成时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime finishTime;
    
    
    /**
     * 异常描述
     */
    private String errorMsg;
    
    /**
     * 备注
     */
    private String remark;
    
    
}