package com.rocogz.account.api.enums.account;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 账户金额类型
 * @author Andrew
 * @create 2020/4/29 2:58 下午
 */
@RequiredArgsConstructor
public enum AccountAmountType {

    /**
     * 余额
     */
    BALANCE("余额"),
    /**
     * 冻结金额
     */
    FROZEN_AMOUNT("冻结金额"),
    /**
     * 已用金额
     */
    USED_AMOUNT("已用金额"),
    /**
     * 划拨金额
     */
    TRANSFER_AMOUNT("转出金额");
    
    @Getter
    private final String label;
    
    
    
}
