package com.rocogz.account.api.enums.account;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * @author Andrew
 * @create 2020/4/8 5:40 下午
 */
@RequiredArgsConstructor
public enum AccountStatus {
    
    /**
     * 停用
     */
    LOCK("停用"),
    /**
     * 正常
     */
    OPEN("启用");
    
    @Getter
    private final String label;
    
    
    public static String getLabel(String name) {
        for (AccountStatus status : values()) {
            if (status.name().equals(name)) {
                return status.label;
            }
        }
        return name;
    }
    
    
}
