package com.rocogz.account.api.service.account;

import com.rocogz.account.api.request.account.query.AccountQueryReq;
import com.rocogz.account.api.request.account.query.AccountQueryTradeLogReq;
import com.rocogz.account.api.request.account.query.AccountQueryTradeRecordReq;
import com.rocogz.account.api.response.account.query.AccountDetailRes;
import com.rocogz.account.api.response.account.query.AccountRes;
import com.rocogz.account.api.response.account.query.AccountTradeLogRes;
import com.rocogz.account.api.response.account.query.AccountTradeRecordRes;
import com.rocogz.common.api.request.BaseUniqueCodeRequest;
import com.rocogz.common.api.request.CommonQueryPageRequest;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.api.response.CommonQueryPageResponse;
import com.rocogz.common.api.response.CommonResponse;

import java.util.List;

/**
 * @author Andrew
 * @create 2020/8/7 2:44 下午
 */
public interface AccountQueryService {
    
    /**
     * 分页查询账户
     *
     * @param request
     * @return
     */
    CommonQueryPageResponse<AccountRes> pageAcct(CommonQueryPageRequest<AccountQueryReq> request);
    
    
    /**
     * 查询账户列表
     *
     * @param request
     * @return
     */
    CommonResponse<List<AccountRes>> listAcct(CommonRequest<AccountQueryReq> request);
    
    
    /**
     * 查询账户详情
     *
     * @param request
     * @return
     */
    CommonResponse<AccountDetailRes> queryDetail(CommonRequest<BaseUniqueCodeRequest> request);

    /**
     * 查询账户详情ByOrgNo
     *
     * @param request
     * @return
     */
    CommonResponse<AccountDetailRes> queryDetailByOrgNo(CommonRequest<BaseUniqueCodeRequest> request);

    
    /**
     * 分页查询交易日志
     *
     * @param request
     * @return
     */
    CommonQueryPageResponse<AccountTradeLogRes> pageTradeLog(CommonQueryPageRequest<AccountQueryTradeLogReq> request);
    
    
    /**
     * 分页查询交易流水
     *
     * @param request
     * @return
     */
    CommonQueryPageResponse<AccountTradeRecordRes> pageTradeRecord(CommonQueryPageRequest<AccountQueryTradeRecordReq> request);

    /**
     * 分页查询交易日志
     *
     * @param request
     * @return
     */
    CommonQueryPageResponse<AccountTradeLogRes> pageSubTradeLog(CommonQueryPageRequest<AccountQueryTradeLogReq> request);

}
