/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.account.api.enums.account;

import com.rocogz.account.api.enums.account.AccountAmountType;
import java.math.BigDecimal;

public enum AccountTradeRecordType {
    ADD,
    DECR,
    TRANSFER_BACK,
    TRANSFER_OUT,
    FROZEN,
    UNFROZEN,
    CONSUME_UNFROZEN,
    CONSUME,
    REFUND;

    public static final String ADD_FLAG = "+";
    public static final String DECR_FLAG = "-";

    public static String getFlag(BigDecimal amount, AccountAmountType amountType, String type) {
        try {
            AccountTradeRecordType transRecordType = AccountTradeRecordType.valueOf(type);
            switch (transRecordType) {
                case ADD: {
                    return AccountTradeRecordType.getFlag(AccountAmountType.BALANCE, null, amountType, amount);
                }
                case DECR: {
                    return AccountTradeRecordType.getFlag(null, AccountAmountType.BALANCE, amountType, amount);
                }
                case TRANSFER_BACK: {
                    return AccountTradeRecordType.getFlag(AccountAmountType.BALANCE, AccountAmountType.TRANSFER_AMOUNT, amountType, amount);
                }
                case TRANSFER_OUT: {
                    return AccountTradeRecordType.getFlag(AccountAmountType.TRANSFER_AMOUNT, AccountAmountType.BALANCE, amountType, amount);
                }
                case FROZEN: {
                    return AccountTradeRecordType.getFlag(AccountAmountType.FROZEN_AMOUNT, AccountAmountType.BALANCE, amountType, amount);
                }
                case UNFROZEN: {
                    return AccountTradeRecordType.getFlag(AccountAmountType.BALANCE, AccountAmountType.FROZEN_AMOUNT, amountType, amount);
                }
                case CONSUME_UNFROZEN: {
                    return AccountTradeRecordType.getFlag(AccountAmountType.USED_AMOUNT, AccountAmountType.FROZEN_AMOUNT, amountType, amount);
                }
                case CONSUME: {
                    return AccountTradeRecordType.getFlag(AccountAmountType.USED_AMOUNT, AccountAmountType.BALANCE, amountType, amount);
                }
                case REFUND: {
                    return AccountTradeRecordType.getFlag(AccountAmountType.BALANCE, AccountAmountType.USED_AMOUNT, amountType, amount);
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFlag(AccountAmountType addType, AccountAmountType decrType, AccountAmountType curType, BigDecimal amount) {
        if (addType == curType) {
            return ADD_FLAG.concat(amount.stripTrailingZeros().toPlainString());
        }
        if (decrType == curType) {
            return DECR_FLAG.concat(amount.stripTrailingZeros().toPlainString());
        }
        return null;
    }
}

