package com.rocogz.account.api.entity.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@Table(name = "account_deposit_audit_log")
public class AccountDepositAuditLog implements Serializable {

    @Id
    private Long id;

    /**
     * 方案编号
     */
    private String orderNo;

    /**
     * 操作项
     */
    private String operation;

    /**
     * 操作备注
     */
    private String remark;

    /**
     * 操作人
     */
    private String operationName;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;


}
