package com.rocogz.account.api.entity.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.account.api.enums.account.AccountAmountType;
import com.rocogz.account.api.enums.account.AccountTradeRecordType;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 账户交易流水(AccountTransRecord)实体类
 *
 * @author Andrew
 * @since 2020-04-08 15:33:43
 */
@Data
@Table(name = "account_trade_record")
public class AccountTradeRecord implements Serializable {
    
    
    @Id
    private Long id;
    
    /**
     * 交易流水号
     */
    private String tradeNo;
    
    /**
     * 账户编号
     */
    private String acctNo;
    
    /**
     * 日志编号
     */
    private String logNo;
    
    /**
     * 事件编号
     */
    private String eventNo;
    
    /**
     * 事件类型
     */
    private String eventType;
    
    
    /**
     * 流水类型
     */
    private String recordType;
    
    /**
     * 金额
     */
    private BigDecimal amount;
    
    /**
     * 变更后余额
     */
    private BigDecimal afterBalance;
    
    /**
     * 变更后冻结金额
     */
    private BigDecimal afterFrozenAmount;
    
    /**
     * 变更后已用金额
     */
    private BigDecimal afterUsedAmount;
    
    /**
     * 变更后已划拨给子账户金额
     */
    private BigDecimal afterTransferAmount;
    
    /**
     * 备注
     */
    private String remark;
    
    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;
    
    /**
     * 创建日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate createDate;
    
    private String createUsertype;
    
    private String createUser;
    
    private String createName;
    
    
    public String getBalanceChange() {
        return AccountTradeRecordType.getFlag(amount, AccountAmountType.BALANCE, recordType);
    }
    
    public String getFrozenChange() {
        return AccountTradeRecordType.getFlag(amount, AccountAmountType.FROZEN_AMOUNT, recordType);
    }
    
    public String getUsedChange() {
        return AccountTradeRecordType.getFlag(amount, AccountAmountType.USED_AMOUNT, recordType);
    }
    
    public String getTransferChange() {
        return AccountTradeRecordType.getFlag(amount, AccountAmountType.TRANSFER_AMOUNT, recordType);
    }
    
    public BigDecimal getAfterTotalAmount() {
        try {
            return afterBalance.add(afterFrozenAmount).add(afterTransferAmount).add(afterUsedAmount);
        } catch (Exception e) {
            return null;
        }
    }
    
    
}