package com.rocogz.account.api.request.account.audit;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class AccountDepositAuditReq implements Serializable {

    /**
     * 方案编号
     */
    @NotBlank
    private String orderNo;

    /**
     * 账户编号
     */
    @NotBlank
    private String acctNo;

    /**
     * 客户姓名
     */
    @NotBlank
    private String customerName;

    /**
     * 客户手机号
     */
    @NotBlank
    private String customerMobile;

    /**
     * 客户车牌号
     */
    @NotBlank
    private String customerCarNumber;

    /**
     * 机构编号（礼赠机构）
     */
    @NotBlank
    private String enterpriseCode;

    /**
     * 机构名称
     */
    @NotBlank
    private String enterpriseName;

    /**
     * 方案类型
     */
    @NotBlank
    private String giftType;

    /**
     * 产品套餐性质
     */
    @NotBlank
    private String productType;

    /**
     * 产品数量
     */
    @NotBlank
    private String productNumber;

    /**
     * 预算金额
     */
    @NotNull
    private BigDecimal budgetPrice;

    /**
     * 市场价值
     */
    @NotNull
    private BigDecimal marketPrice;

    /**
     * 终端价合计
     */
    @NotNull
    private BigDecimal amount;

    /**
     * 利润（可正，可负）
     */
    @NotNull
    private BigDecimal preferentialAmount;

    /**
     * 申请人
     */
    @NotBlank
    private String applyName;

    /**
     * 是否自动审核
     */
    @NotNull
    private Boolean autoAudit;

    /**
     * 是否自动发放
     */
    @NotNull
    private Boolean autoProvide;

}
