package com.rocogz.account.api.request.account.base;

import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;


/**
 * 账户开户
 * @author roco
 */
@Data
@ToString(callSuper = true)
public class AccountOpenDetailReq extends AccountOpenTopOrgReq {



    /**
     * 个人账号编码
     */
    private String personUserNo;

    /**
     * 个人名称
     */
    private String personUserName;

    /**
     * 个人手机号
     */
    private String personUserMobile;

    /**
     * 明细账户类型
     */
    @Pattern(regexp = "^(GENERAL|PERSON|OTHER|TOUBAOLGENERAL|TOUBAOLPERSON|TOUBAOLOTHER)$")
    @NotBlank(message = "明细账户类型不能为空")
    private String childAcctType;
    
}