package com.rocogz.account.api.entity.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.account.api.enums.account.AccountLogType;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/9 12:17</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name = "account_base_log")
public class AccountLog implements Serializable {


    @Id
    private Long id;

    /**
     * 账户编码
     */
    private String acctNo;

    /**
     * 日志类型 OPEN_ACCT:开户  STATUS_UPDATE: 状态变更
     */
    private String logType;

    /**
     * 变更说明
     */
    private String description;

    /**
     * 备注
     */
    private String remark;



    /**
     * 变更前json
     */
    private String beforeJson;

    /**
     * 变更后json
     */
    private String afterJson;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 创建人id
     */
    private String createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人用户类型
     */
    @Column(name="create_usertype")
    private String createUsertype;


    public static AccountLog buildOpenLog(Account account){
        AccountLog accountLog = new AccountLog();
        accountLog.setAcctNo(account.getAcctNo());
        accountLog.setLogType(AccountLogType.OPEN_ACCT.name());
        accountLog.setDescription("账户开户");
        accountLog.setRemark(account.getRemark());
        return accountLog;
    }


}