package com.rocogz.account.api.response.account.query;

import com.rocogz.account.api.entity.account.Account;
import lombok.Data;
import lombok.ToString;

import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * @author Andrew
 * @create 2020/8/7 3:08 下午
 */
@Data
@ToString(callSuper = true)
public class AccountRes extends Account {
    
    /**
     * 集成商名称
     */
    private String integrationName;
    /**
     * 机构名称
     */
    private String orgName;
    
    
    /**
     * 机构编号
     */
    private String orgNo;

    /**
     * 机构代码
     */
    private String orgCode;

    /**
     * 个人账户编码
     */
    private String personUserNo;
    
    /**
     * 个人姓名
     */
    private String personUserName;
    
    /**
     * 个人手机号
     */
    private String personUserMobile;
    
    
    @Transient
    private BigDecimal totalChildUsedAmount = BigDecimal.ZERO;

    /**
     * 下级机构数量
     */
    private int childOrgCount;

    /**
     * 变更后关联的操作
     */
    private String updateRefOperate;
    
    public BigDecimal getTotalAvailableAmount() {
        try {
            return this.getTotalAmount().subtract(totalChildUsedAmount);
        } catch (Exception e) {
            return null;
        }
    }
    
}
