package com.rocogz.account.api.entity.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@Table(name = "account_deposit_audit")
public class AccountDepositAudit implements Serializable {

    @Id
    private Long id;

    /**
     * 方案编号
     */
    private String orderNo;

    /**
     * 账户编号
     */
    private String acctNo;

    /**
     * 客户姓名
     */
    private String customerName;

    /**
     * 客户手机号
     */
    private String customerMobile;

    /**
     * 客户车牌号
     */
    private String customerCarNumber;

    /**
     * 机构编号（礼赠机构）
     */
    private String enterpriseCode;

    /**
     * 机构名称
     */
    private String enterpriseName;

    /**
     * 方案类型
     */
    private String giftType;

    /**
     * 产品套餐性质
     */
    private String productType;

    /**
     * 产品数量
     */
    private Integer productNumber;

    /**
     * 预算金额
     */
    private BigDecimal budgetPrice;

    /**
     * 市场价值
     */
    private BigDecimal marketPrice;

    /**
     * 终端价合计
     */
    private BigDecimal amount;

    /**
     * 利润（可正，可负）
     */
    private BigDecimal preferentialAmount;

    /**
     * 申请人
     */
    private String applyName;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime applyTime;

    /**
     * 审核状态
     */
    private String status;

    /**
     * 是否通知异常
     */
    private String notifySuccess;

}
