package com.rocogz.account.api.entity.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.account.api.enums.account.AccountStatus;
import com.rocogz.common.api.constant.FormatConstant;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 账户表(Account)实体类
 *
 * @author Andrew
 * @since 2020-04-08 15:33:18
 */
@Data
@Table(name = "account")
public class Account implements Serializable {
    
    
    @Id
    private Long id;

    /**
     * 账户编码
     */
    private String acctNo;

    /**
     * 账户名称
     */
    private String acctName;

    /**
     * 账户分类
     */
    private String acctClass;

    /**
     * 账户类型
     */
    private String acctType;

    /**
     * 总账户级别
     */
    private String totalAcctLevel;

    /**
     * 明细账户类型
     */
    private String childAcctType;

    /**
     * 明细账户对应的机构总账户编码
     */
    private String childCorresAcctCode;

    /**
     * 明细账户对应的机构总账户名称
     */
    private String childCorresAcctName;

    /**
     * 账户层级
     */
    private Integer acctLevel;

    /**
     * 账户路径
     */
    private String acctPath;

    /**
     * 账户状态
     */
    private String acctStatus;

    /**
     * 上级总机构账户编码
     */
    private String parentAcctNo;

    /**
     * 上级总机构账户名称
     */
    private String parentAcctName;

    /**
     * 余额
     */
    private BigDecimal balance;

    /**
     * 已用金额
     */
    private BigDecimal usedAmount;

    /**
     * 冻结金额
     */
    private BigDecimal frozenAmount;

    /**
     * 转出额度
     */
    private BigDecimal transferAmount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 创建人id
     */
    private String createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人用户类型
     */
    @Column(name="create_usertype")
    private String createUsertype;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD_HH_MM_SS, timezone = FormatConstant.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 修改日期
     */
    @JsonFormat(pattern = FormatConstant.YYYY_MM_DD, timezone = FormatConstant.TIME_ZONE)
    private LocalDate updateDate;

    /**
     * 修改人id
     */
    private String updateUser;

    /**
     *  修改人姓名
     */
    private String updateName;

    /**
     * 修改人用户类型
     */
    @Column(name="update_usertype")
    private String updateUsertype;


    public static Account initAccount(){
        Account account = new Account();
        account.setBalance(BigDecimal.ZERO);
        account.setTransferAmount(BigDecimal.ZERO);
        account.setFrozenAmount(BigDecimal.ZERO);
        account.setUsedAmount(BigDecimal.ZERO);
        account.setAcctStatus(AccountStatus.OPEN.name());
        return  account;
    }
    
    public BigDecimal getTotalAmount() {
        try {
            return balance.add(frozenAmount).add(usedAmount).add(transferAmount);
        } catch (Exception e) {
            return null;
        }
    }

}