package com.rocogz.account.api.enums.account;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 账户审核类型
 * @author looyee
 * @create 2020/11/19 19:19 下午
 */
@RequiredArgsConstructor
public enum AccountAuditStatus {

    /**
     * 待审核
     */
    WAIT_AUDIT("待审核"),
    /**
     * 待机构发放
     */
    WAIT_ENTERPRISE("待机构发放"),
    /**
     * 待平台发放
     */
    WAIT_PLATFORM("待平台发放"),
    /**
     * 已完成
     */
    SUCCESS("已完成"),
    /**
     * 审核不通过
     */
    FAIL("审核不通过");

    @Getter
    private final String label;

    public static String getLabel(String name) {
        for (AccountAuditStatus status : values()) {
            if (status.name().equals(name)) {
                return status.label;
            }
        }
        return name;
    }

}
