package com.rocogz.account.api.enums.account;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 总账户级别
 * @author Andrew
 * @create 2020/8/11 9:14 上午
 */
@RequiredArgsConstructor
public enum AccountType {
    
    /**
     * 总账户
     */
    TOTAL("机构总账户"),
    
    /**
     * 明细账户
     */
    DETAIL("机构明细账户"),

    /**
     * 投保礼总账户
     */
    TOUBAOLTOTAL("投保礼机构总账户"),

    /**
     * 投保礼明细账户
     */
    TOUBAOLDETAIL("投保礼机构明细账户");
    
    @Getter
    private final String label;
}
