package com.rocogz.account.api.request.account.query;

import lombok.Data;

import java.io.Serializable;

/**
 * @author Andrew
 * @create 2020/4/10 4:05 下午
 */
@Data
public class AccountQueryTradeLogReq implements Serializable {

    private String eventNo;

    private String eventType;

    private String[] eventTypes;

    private String acctNo;
    
    private String acctName;
    
    private String targetAcctNo;
    
    private String targetAcctName;
    
    private String result;

    private String orgNo;

    private String[] orgNos;

    private String orgName;
    
    private String integrationCode;
    
    private String integrationName;

    public void setEventType(String eventType) {
        if (null != eventType && eventType.length() > 0 && eventType.indexOf(',') > 0) {
            eventTypes = eventType.split(",");
            return;
        }
        this.eventType = eventType;
    }

    public void setOrgNo(String orgNo) {
        if (null != orgNo && orgNo.length() > 0 && orgNo.indexOf(',') > 0) {
            orgNos = orgNo.split(",");
            return;
        }
        this.orgNo = orgNo;
    }
}
